	var wait_save_data = 1;

	var error_code = 1;
	var visaPattern = /^(?:4[0-9]{12}(?:[0-9]{3})?)$/;
	var mastPattern = /^(?:5[1-5][0-9]{14})$/;
	var amexPattern = /^(?:3[47][0-9]{13})$/;
	var discPattern = /^(?:6(?:011|5[0-9][0-9])[0-9]{12})$/;

$('.form-activate').validator().on('submit', function (e) {
	$('.info').empty();
	error_code = 1;
  	if (e.isDefaultPrevented()) {
    	// handle the invalid form...
    	console.log('has error');
  	} else {
    	// everything looks good!
    	e.preventDefault();


    	var USER_DATA = {};
    	USER_DATA.projectTypeNumber = $('[name="projectNumber"]').val();
    	USER_DATA.dealerToken = $('[name="dealerToken"]').val();
    	USER_DATA.dealerName = $('[name="dealerName"]').val();

		USER_DATA.account 	= $('[name="account"]').val();
		USER_DATA.email 	= $('[name="email"]').val();

		USER_DATA.imei 		= $('[name="imei"]').val();
		USER_DATA.name 		= $('[name="name"]').val();
		USER_DATA.registration = $('[name="rego"]').val();
		USER_DATA.describe1 = $('[name="describe1"]').val();
		USER_DATA.describe2 = $('[name="describe2"]').val();
		USER_DATA.describe3 = $('[name="describe3"]').val();
		USER_DATA.describe4 = $('[name="describe4"]').val();
		USER_DATA.servicePlanCode = $('[name="servicePlan"]').val();
		USER_DATA.servicePlan = $('[name="servicePlan"] option:selected').text();
		USER_DATA.servicePlanType = $('[name="servicePlan"] option:selected').data('plantype');
		USER_DATA.countryCode = $('[name="country"]').val();
		USER_DATA.country = $('[name="country"] option:selected').text();

		USER_DATA.assetType = $('[name="assetType"]').val();
		USER_DATA.instalLocation = $('[name="instalLocation"]').val();
		USER_DATA.notes = $('[name="notes"]').val();
		USER_DATA.isDeviceInstalled = $('[name="isDeviceInstalled"]:checked').val();
		USER_DATA.initialMileage = $('[name="initialMileage"]').val();
		USER_DATA.initialEngineHours = $('[name="initialEngineHours"]').val();

		var phoneCode = $('[name="phoneCode"]').val();
		var mobile = $('[name="mobile"]').val();
		if ('+61' == phoneCode){
			if (mobile[0] === 0){
				mobile = mobile.substring(1);
			}
		}
		USER_DATA.phoneCode = phoneCode;
		USER_DATA.mobile = mobile;

		USER_DATA.paymentTypeCode = $('input[name="paymentType"]:checked').val();
		USER_DATA.paymentType = $('input[name="paymentType"]:checked').siblings('span').text();

		switch (USER_DATA.paymentTypeCode){
			case '1':
				USER_DATA.payment1 = $('[name="ccType"]:checked').val();
				USER_DATA.payment2 = $('[name="ccNumber"]').val();
				USER_DATA.payment3 = $('[name="ccExpiryDate"]').val();
				USER_DATA.payment4 = $('[name="ccNameOnCard"]').val();
				USER_DATA.payment5 = $('[name="ccCVV"]').val();

				error_code = validateCreditCardNumber({'ccNum':USER_DATA.payment2});
				break;
			case '2':
				USER_DATA.payment1 = $('[name="bankAccountName"]').val();
				USER_DATA.payment2 = $('[name="bankName"]').val();
				USER_DATA.payment3 = $('[name="bankBSB"]').val();
				USER_DATA.payment4 = $('[name="bankAccountNumber"]').val();
				break;

			case '4':
				USER_DATA.paymentType = 'voucher';
				USER_DATA.payment1 = $('[name="voucherCode"]').val();
				break;

			default:
				USER_DATA.payment1 = $('[name="invoiceName"]').val();
				USER_DATA.payment2 = $('[name="invoiceNumber"]').val();
				USER_DATA.payment3 = $('[name="invoiceRUT"]').val();
				USER_DATA.payment4 = $('[name="invoiceEmail"]').val();
		}

		if ($('[name="autosuspend"]').prop('checked')) {
			USER_DATA.autosuspend = 1;
		}else{
			USER_DATA.autosuspend = 0;
		}

		USER_DATA.solutionCode = $('[name="solution"]').val();
		USER_DATA.solution = $('[name="solution"] option:selected').text();
		USER_DATA.deviceType = $('[name="deviceType"]').val();
		USER_DATA.domain = $('[name="domain"]').val();

			let solutionTypeFeatures = $('#solution').find('option:selected').data('features');
			if(solutionTypeFeatures && solutionTypeFeatures.indexOf("IO,") >= 0){
				let deviceTypeFeatures = $('#deviceType').data('features');
				if((deviceTypeFeatures & PRODUCTFEATURES.Input1) > 0
					|| (deviceTypeFeatures & PRODUCTFEATURES.Input2) > 0 )
				{
					let isInputsConnected = $('[name="isDeviceInputsConnected"]:checked').val();
					if(isInputsConnected === 'yes'){
						if((deviceTypeFeatures & PRODUCTFEATURES.Input1) > 0){
							USER_DATA.Input1 = $('[name="Input1"]').val();
							USER_DATA.Input1MaskTime = $('[name="Input1MaskTime"]').val();
							USER_DATA.Input1Type = $('[name="Input1Type"]').val();
						}
						if((deviceTypeFeatures & PRODUCTFEATURES.Input2) > 0){
							USER_DATA.Input2 = $('[name="Input2"]').val();
							USER_DATA.Input2MaskTime = $('[name="Input2MaskTime"]').val();
							USER_DATA.Input2Type = $('[name="Input2Type"]').val();
						}
					}
				}
			}

			if(solutionTypeFeatures && solutionTypeFeatures.indexOf("LOWER_POWER,") >= 0){
				USER_DATA.LowerPower = $('[name="LowerPower"]').val();
			}
			if(solutionTypeFeatures && solutionTypeFeatures.indexOf("DISCONNECT_POWER,") >= 0){
				USER_DATA.DisconnectPower = $('[name="DisconnectPower"]').val();
			}
			if(solutionTypeFeatures && solutionTypeFeatures.indexOf("IGNITION_ON,") >= 0){
				USER_DATA.IgnitionPower = $('[name="IgnitionPower"]').val();
			}

		USER_DATA.fitoptions = $('[name="fitoptions"]').val();
		if (USER_DATA.fitoptions && USER_DATA.fitoptions.length) {
			USER_DATA.fitoptions = USER_DATA.fitoptions.reduce((a, b) => parseInt(a) + parseInt(b), 0);
		}else{
			USER_DATA.fitoptions = 0;
		}



		console.log(USER_DATA);

		/*USER_DATA.projectNumber = $('[name="projectNumber"]').val();*/



		console.log(error_code);
		switch (error_code){
			case 1:
				if (wait_save_data == 1) {
					$.ajax({
						type: "POST",
						url: "php/save_in_db_a.php",
						dataType: 'json',
						data: USER_DATA,
						async: true,
						cache: false,
						beforeSend: function(){
							wait_save_data = 0;
							$('.form_submit').toggleClass('disabled');
							$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
							preloader.on();
						},
						success: function(data){
							wait_save_data = 1;
							$('.form_submit').toggleClass('disabled');
							$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
							preloader.off();

							console.log(data);
							var replyCode = data.replyCode;
							var respondMsg = data.msg;

							switch (replyCode){
								case '9999': case '1005': case '1004': case '1002': case '1000':
                             Swal.fire({
 									 icon: 'error',
  									 title: '',
    								 text: respondMsg,
									 confirmButtonColor: '#e9142b',
 									 footer: '<a href="https://support.quiktrak.au/?s=31">Contact support</a>'
									}) 
									$('.info').html('<div class="errors">'+respondMsg+'</div>');
									break;

								case '000':
									$('.clearAfter').val('');
									$('.info').html('<div class="success">'+respondMsg+'</div>');

									var letter = data.letter;
									if (letter) {
										/*window.open(letter,'_blank');

										var letterFrame = '<iframe src="'+letter+'" onload="resizeIframe(this)" style="width: 100%;"></iframe>';
										$('#modalLetter').modal('show');
		                				$('#modalLetter .modal-content').html(letterFrame);*/
									}
									break;
								default:
								$('.info').html('<div class="errors">Error, please try again later</div>');
							}

						},
						error: function(XMLHttpRequest, textStatus, errorThrown){
							console.log(XMLHttpRequest);
							console.log(textStatus);
							console.log(errorThrown);
							$('.form_submit').toggleClass('disabled');
							$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
							$('.info').html('<div class="errors">Error, please try again later</div>');
							wait_save_data = 1;
							preloader.off();
						}
					});
				}else{
					console.log("Sending previous form data");
				}

				break;

			case 2:
				$('.info').html('<div class="errors">Enter valid payment details, please.</div>');
				break;
		}


  	}

  	return false;
});
/*
$('body').on('click', '.help-info', function(){
	var letterFrame = '<iframe src="http://app.quikprotect.co/activation2/letter/protect/v2/?ac=demochile" onload="resizeIframe(this)" style="width: 100%;"></iframe>';
	$('#modalLetter').modal('show');
	$('#modalLetter .modal-content').html(letterFrame);
})*/

function validateCreditCardNumber(data) {
    data.ccNum = data.ccNum.replace(/\s+/g, '');
    var code = 1;

    var isVisa = visaPattern.test( data.ccNum ) === true;
    var isMast = mastPattern.test( data.ccNum ) === true;
    var isAmex = amexPattern.test( data.ccNum ) === true;
    //var isDisc = discPattern.test( ccNum ) === true;

    if( isVisa || isMast || isAmex ) {
        if ( data.ccNum == '5555555555555555' || data.ccNum == '4444444444444444' || data.ccNum == '333333333333333') {
        	code = 2;
        }
    } else {
        //alert("Please enter a valid card number.");
        code = 2;
    }

    return code;
}

$(function() {

  	$('#country').on('change', function(){
    	var selected = $(this).val();
    	switch (selected) {
    		case 'ABW':	$("#phoneCode").val('+297'); 	break;
			case 'AFG': $("#phoneCode").val('+93'); 	break;
			case 'AGO':	$("#phoneCode").val('+244'); 	break;
			case 'AIA':	$("#phoneCode").val('+1'); 		break;
			case 'ALB': $("#phoneCode").val('+355'); 	break;
			case 'AND':	$("#phoneCode").val('+376'); 	break;
			case 'ANT':	$("#phoneCode").val('+376'); 	break;
			case 'ARE':	$("#phoneCode").val('+971'); 	break;
			case 'ARG':	$("#phoneCode").val('+54'); 	break;
			case 'ARM':	$("#phoneCode").val('+374'); 	break;
			case 'ASM':	$("#phoneCode").val('+1'); 		break;
			case 'ATA':	$("#phoneCode").val('+1'); 		break;
			case 'ATF':	$("#phoneCode").val('+1'); 		break;
			case 'ATG':	$("#phoneCode").val('+1'); 		break;
			case 'AUS':	$("#phoneCode").val('+61'); 	break;
			case 'AUT':	$("#phoneCode").val('+43'); 	break;
			case 'AZE':	$("#phoneCode").val('+994'); 	break;
			case 'BDI':	$("#phoneCode").val('+257'); 	break;
			case 'BEL':	$("#phoneCode").val('+32'); 	break;
			case 'BEN':	$("#phoneCode").val('+229'); 	break;
			case 'BFA':	$("#phoneCode").val('+226'); 	break;
			case 'BGD':	$("#phoneCode").val('+880'); 	break;
			case 'BGR':	$("#phoneCode").val('+359'); 	break;
			case 'BHR':	$("#phoneCode").val('+973'); 	break;
			case 'BHS':	$("#phoneCode").val('+1'); 		break;
			case 'BIH':	$("#phoneCode").val('+387'); 	break;
			case 'BLR':	$("#phoneCode").val('+375'); 	break;
			case 'BLZ':	$("#phoneCode").val('+501'); 	break;
			case 'BMU':	$("#phoneCode").val('+1'); 		break;
			case 'BOL':	$("#phoneCode").val('+591'); 	break;
			case 'BRA':	$("#phoneCode").val('+55'); 	break;
			case 'BRB':	$("#phoneCode").val('+1'); 		break;
			case 'BRN':	$("#phoneCode").val('+673'); 	break;
			case 'BTN':	$("#phoneCode").val('+975'); 	break;
			case 'BVT':	$("#phoneCode").val('+975'); 	break;
			case 'BWA':	$("#phoneCode").val('+267'); 	break;
			case 'CAF':	$("#phoneCode").val('+236'); 	break;
			case 'CAN':	$("#phoneCode").val('+1'); 		break;
			case 'CCK':	$("#phoneCode").val('+1'); 		break;
			case 'CHE':	$("#phoneCode").val('+41'); 	break;
			case 'CHL':	$("#phoneCode").val('+56'); 	break;
			case 'CHN':	$("#phoneCode").val('+86'); 	break;
			case 'CIV':	$("#phoneCode").val('+225'); 	break;
			case 'CMR':	$("#phoneCode").val('+237'); 	break;
			case 'COD':	$("#phoneCode").val('+242'); 	break;
			case 'COG':	$("#phoneCode").val('+243'); 	break;
			case 'COK':	$("#phoneCode").val('+682'); 	break;
			case 'COL':	$("#phoneCode").val('+57'); 	break;
			case 'COM':	$("#phoneCode").val('+269'); 	break;
			case 'CPV':	$("#phoneCode").val('+238'); 	break;
			case 'CRI':	$("#phoneCode").val('+506'); 	break;
			case 'CUB':	$("#phoneCode").val('+53'); 	break;
			case 'CXR':	$("#phoneCode").val('+1'); 		break;
			case 'CYM':	$("#phoneCode").val('+1'); 		break;
			case 'CYP':	$("#phoneCode").val('+357'); 	break;
			case 'CZE':	$("#phoneCode").val('+420'); 	break;
			case 'DEU':	$("#phoneCode").val('+49'); 	break;
			case 'DJI':	$("#phoneCode").val('+253'); 	break;
			case 'DMA':	$("#phoneCode").val('+1'); 		break;
			case 'DNK':	$("#phoneCode").val('+45'); 	break;
			case 'DOM':	$("#phoneCode").val('+1'); 		break;
			case 'DZA':	$("#phoneCode").val('+213'); 	break;
			case 'ECU':	$("#phoneCode").val('+593'); 	break;
			case 'EGY':	$("#phoneCode").val('+20'); 	break;
			case 'ERI':	$("#phoneCode").val('+291'); 	break;
			case 'ESH':	$("#phoneCode").val('+212'); 	break;
			case 'ESP':	$("#phoneCode").val('+34'); 	break;
			case 'EST':	$("#phoneCode").val('+372'); 	break;
			case 'ETH':	$("#phoneCode").val('+251'); 	break;
			case 'FIN':	$("#phoneCode").val('+358'); 	break;
			case 'FJI':	$("#phoneCode").val('+679'); 	break;
			case 'FLK':	$("#phoneCode").val('+500'); 	break;
			case 'FRA':	$("#phoneCode").val('+33'); 	break;
			case 'FRO':	$("#phoneCode").val('+298'); 	break;
			case 'FSM':	$("#phoneCode").val('+691'); 	break;
			case 'GAB':	$("#phoneCode").val('+241'); 	break;
			case 'GBR':	$("#phoneCode").val('+44'); 	break;
			case 'GEO':	$("#phoneCode").val('+995'); 	break;
			case 'GHA':	$("#phoneCode").val('+233'); 	break;
			case 'GIB':	$("#phoneCode").val('+350'); 	break;
			case 'GIN':	$("#phoneCode").val('+224'); 	break;
			case 'GLP':	$("#phoneCode").val('+590'); 	break;
			case 'GMB':	$("#phoneCode").val('+220'); 	break;
			case 'GNB':	$("#phoneCode").val('+245'); 	break;
			case 'GNQ':	$("#phoneCode").val('+240'); 	break;
			case 'GRC':	$("#phoneCode").val('+30'); 	break;
			case 'GRD':	$("#phoneCode").val('+1'); 		break;
			case 'GRL':	$("#phoneCode").val('+299'); 	break;
			case 'GTM':	$("#phoneCode").val('+502'); 	break;
			case 'GUF':	$("#phoneCode").val('+594'); 	break;
			case 'GUM':	$("#phoneCode").val('+1'); 		break;
			case 'GUY':	$("#phoneCode").val('+592'); 	break;
			case 'HKG':	$("#phoneCode").val('+852'); 	break;
			case 'HMD':	$("#phoneCode").val('+592'); 	break;
			case 'HND':	$("#phoneCode").val('+504'); 	break;
			case 'HRV':	$("#phoneCode").val('+385'); 	break;
			case 'HTI':	$("#phoneCode").val('+509'); 	break;
			case 'HUN':	$("#phoneCode").val('+36'); 	break;
			case 'IDN':	$("#phoneCode").val('+62'); 	break;
			case 'IND':	$("#phoneCode").val('+91'); 	break;
			case 'IOT':	$("#phoneCode").val('+246'); 	break;
			case 'IRL':	$("#phoneCode").val('+353'); 	break;
			case 'IRN':	$("#phoneCode").val('+98'); 	break;
			case 'IRQ':	$("#phoneCode").val('+964'); 	break;
			case 'ISL':	$("#phoneCode").val('+354'); 	break;
			case 'ISR':	$("#phoneCode").val('+972'); 	break;
			case 'ITA':	$("#phoneCode").val('+39'); 	break;
			case 'JAM':	$("#phoneCode").val('+1'); 		break;
			case 'JOR':	$("#phoneCode").val('+962'); 	break;
			case 'JPN':	$("#phoneCode").val('+81'); 	break;
			case 'KAZ':	$("#phoneCode").val('+7'); 		break;
			case 'KEN':	$("#phoneCode").val('+254'); 	break;
			case 'KGZ':	$("#phoneCode").val('+996'); 	break;
			case 'KHM':	$("#phoneCode").val('+855'); 	break;
			case 'KIR':	$("#phoneCode").val('+686'); 	break;
			case 'KNA':	$("#phoneCode").val('+1'); 		break;
			case 'KOR':	$("#phoneCode").val('+850'); 	break;
			case 'KWT':	$("#phoneCode").val('+965'); 	break;
			case 'LAO':	$("#phoneCode").val('+965'); 	break;
			case 'LBN':	$("#phoneCode").val('+961'); 	break;
			case 'LBR':	$("#phoneCode").val('+231'); 	break;
			case 'LBY':	$("#phoneCode").val('+218'); 	break;
			case 'LCA':	$("#phoneCode").val('+1'); 		break;
			case 'LIE':	$("#phoneCode").val('+423'); 	break;
			case 'LKA':	$("#phoneCode").val('+94'); 	break;
			case 'LSO':	$("#phoneCode").val('+266'); 	break;
			case 'LTU':	$("#phoneCode").val('+370'); 	break;
			case 'LUX':	$("#phoneCode").val('+352'); 	break;
			case 'LVA':	$("#phoneCode").val('+371'); 	break;
			case 'MAC':	$("#phoneCode").val('+853'); 	break;
			case 'MAR':	$("#phoneCode").val('+212'); 	break;
			case 'MCO':	$("#phoneCode").val('+377'); 	break;
			case 'MDA':	$("#phoneCode").val('+373'); 	break;
			case 'MDG':	$("#phoneCode").val('+261'); 	break;
			case 'MDV':	$("#phoneCode").val('+960'); 	break;
			case 'MEX':	$("#phoneCode").val('+52'); 	break;
			case 'MHL':	$("#phoneCode").val('+692'); 	break;
			case 'MKD':	$("#phoneCode").val('+389'); 	break;
			case 'MLI':	$("#phoneCode").val('+223'); 	break;
			case 'MLT':	$("#phoneCode").val('+356'); 	break;
			case 'MMR':	$("#phoneCode").val('+95'); 	break;
			case 'MNG':	$("#phoneCode").val('+976'); 	break;
			case 'MNP':	$("#phoneCode").val('+1'); 		break;
			case 'MOZ':	$("#phoneCode").val('+258'); 	break;
			case 'MRT':	$("#phoneCode").val('+222'); 	break;
			case 'MSR':	$("#phoneCode").val('+1'); 		break;
			case 'MTQ':	$("#phoneCode").val('+596'); 	break;
			case 'MUS':	$("#phoneCode").val('+230'); 	break;
			case 'MWI':	$("#phoneCode").val('+265'); 	break;
			case 'MYS':	$("#phoneCode").val('+60'); 	break;
			case 'MYT':	$("#phoneCode").val('+262'); 	break;
			case 'NAM':	$("#phoneCode").val('+264'); 	break;
			case 'NCL':	$("#phoneCode").val('+687'); 	break;
			case 'NER':	$("#phoneCode").val('+227'); 	break;
			case 'NFK':	$("#phoneCode").val('+672'); 	break;
			case 'NGA':	$("#phoneCode").val('+234'); 	break;
			case 'NIC':	$("#phoneCode").val('+505'); 	break;
			case 'NIU':	$("#phoneCode").val('+683'); 	break;
			case 'NLD':	$("#phoneCode").val('+31'); 	break;
			case 'NOR':	$("#phoneCode").val('+47'); 	break;
			case 'NPL':	$("#phoneCode").val('+977'); 	break;
			case 'NRU':	$("#phoneCode").val('+674'); 	break;
			case 'NZL':	$("#phoneCode").val('+64'); 	break;
			case 'OMN':	$("#phoneCode").val('+968'); 	break;
			case 'PAK':	$("#phoneCode").val('+92'); 	break;
			case 'PAN':	$("#phoneCode").val('+507'); 	break;
			case 'PCN':	$("#phoneCode").val('+507'); 	break;
			case 'PER':	$("#phoneCode").val('+51'); 	break;
			case 'PHL':	$("#phoneCode").val('+63'); 	break;
			case 'PLW':	$("#phoneCode").val('+680'); 	break;
			case 'PNG':	$("#phoneCode").val('+675'); 	break;
			case 'POL':	$("#phoneCode").val('+48'); 	break;
			case 'PRI':	$("#phoneCode").val('+1'); 		break;
			case 'PRK':	$("#phoneCode").val('+82'); 	break;
			case 'PRT':	$("#phoneCode").val('+351'); 	break;
			case 'PRY':	$("#phoneCode").val('+595'); 	break;
			case 'PSE':	$("#phoneCode").val('+970'); 	break;
			case 'PYF':	$("#phoneCode").val('+689'); 	break;
			case 'QAT':	$("#phoneCode").val('+974'); 	break;
			case 'REU':	$("#phoneCode").val('+262'); 	break;
			case 'ROM':	$("#phoneCode").val('+40'); 	break;
			case 'RUS':	$("#phoneCode").val('+7'); 		break;
			case 'RWA':	$("#phoneCode").val('+250'); 	break;
			case 'SAU':	$("#phoneCode").val('+966'); 	break;
			case 'SDN':	$("#phoneCode").val('+249'); 	break;
			case 'SEN':	$("#phoneCode").val('+221'); 	break;
			case 'SGP':	$("#phoneCode").val('+65'); 	break;
			case 'SGS':	$("#phoneCode").val('+65'); 	break;
			case 'SHN':	$("#phoneCode").val('+290'); 	break;
			case 'SJM':	$("#phoneCode").val('+290'); 	break;
			case 'SLB':	$("#phoneCode").val('+677'); 	break;
			case 'SLE':	$("#phoneCode").val('+232'); 	break;
			case 'SLV':	$("#phoneCode").val('+503'); 	break;
			case 'SMR':	$("#phoneCode").val('+378'); 	break;
			case 'SOM':	$("#phoneCode").val('+252'); 	break;
			case 'SPM':	$("#phoneCode").val('+508'); 	break;
			case 'STP':	$("#phoneCode").val('+239'); 	break;
			case 'SUR':	$("#phoneCode").val('+597'); 	break;
			case 'SVK':	$("#phoneCode").val('+421'); 	break;
			case 'SVN':	$("#phoneCode").val('+386'); 	break;
			case 'SWE':	$("#phoneCode").val('+46'); 	break;
			case 'SWZ':	$("#phoneCode").val('+268'); 	break;
			case 'SYC':	$("#phoneCode").val('+248'); 	break;
			case 'SYR':	$("#phoneCode").val('+963'); 	break;
			case 'TCA':	$("#phoneCode").val('+1'); 		break;
			case 'TCD':	$("#phoneCode").val('+235'); 	break;
			case 'TGO':	$("#phoneCode").val('+228'); 	break;
			case 'THA':	$("#phoneCode").val('+66'); 	break;
			case 'TJK':	$("#phoneCode").val('+992'); 	break;
			case 'TKL':	$("#phoneCode").val('+690'); 	break;
			case 'TKM':	$("#phoneCode").val('+993'); 	break;
			case 'TMP':	$("#phoneCode").val('+670'); 	break;
			case 'TON':	$("#phoneCode").val('+676'); 	break;
			case 'TTO':	$("#phoneCode").val('+1'); 		break;
			case 'TUN':	$("#phoneCode").val('+216'); 	break;
			case 'TUR':	$("#phoneCode").val('+90'); 	break;
			case 'TUV':	$("#phoneCode").val('+688'); 	break;
			case 'TWN':	$("#phoneCode").val('+886'); 	break;
			case 'TZA':	$("#phoneCode").val('+255'); 	break;
			case 'UGA':	$("#phoneCode").val('+256'); 	break;
			case 'UKR':	$("#phoneCode").val('+380'); 	break;
			case 'UMI':	$("#phoneCode").val('+380'); 	break;
			case 'UNK':	$("#phoneCode").val('+1'); 		break;
			case 'URY':	$("#phoneCode").val('+598'); 	break;
			case 'USA':	$("#phoneCode").val('+1'); 		break;
			case 'UZB':	$("#phoneCode").val('+998'); 	break;
			case 'VAT':	$("#phoneCode").val('+39'); 	break;
			case 'VCT':	$("#phoneCode").val('+1'); 		break;
			case 'VEN':	$("#phoneCode").val('+58'); 	break;
			case 'VGB':	$("#phoneCode").val('+1'); 		break;
			case 'VIR':	$("#phoneCode").val('+1'); 		break;
			case 'VNM':	$("#phoneCode").val('+84'); 	break;
			case 'VUT':	$("#phoneCode").val('+678'); 	break;
			case 'WLF':	$("#phoneCode").val('+681'); 	break;
			case 'WSM':	$("#phoneCode").val('+685'); 	break;
			case 'YEM':	$("#phoneCode").val('+967'); 	break;
			case 'YUG':	$("#phoneCode").val('+967'); 	break;
			case 'ZAF':	$("#phoneCode").val('+27'); 	break;
			case 'ZMB':	$("#phoneCode").val('+260'); 	break;
			case 'ZWE':	$("#phoneCode").val('+263'); 	break;
		}


  	});

});