<!DOCTYPE html>
<html lang="en">
<head>

	<meta charset="UTF-8">
	<!-- <meta name="viewport" content="width=device-width"> -->
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<link rel="shortcut icon" href="images/favicon-live.png" type="image/x-icon">
	<link rel="stylesheet" type="text/css" href="css/normalize.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap-theme.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap-select.min.css" />
	<link rel="stylesheet" type="text/css" href="css/materialPreloader.min.css" />
	<link rel="stylesheet" type="text/css" href="css/animate.css" />
	<link rel="stylesheet" type="text/css" href="css/checkbox-radio.css" />
	<link rel="stylesheet" type="text/css" href="css/fonts.css" />
	<link rel="stylesheet" type="text/css" href="fonts/fontastic/styles.css?v=<?php echo filemtime('fonts/fontastic/styles.css'); ?>" />
	<link rel="stylesheet" type="text/css" href="css/style.css?v=<?php echo filemtime('css/style.css'); ?>" />

	<title>Activation - Upgrade to Live</title>
</head>
<body class="bg_body">
<?php include "header.php"; ?>
	<div class="container page page_activate">
		<div class="col-xs-12 animated flipInX deivceInstalledTopWarning" style="display: none;">
			<div class="alert alert-warning max-width-940 mx-auto">
				<strong>Warning!</strong> The systems requires a series of commands to configure the unit and your account, please ensure the system is installed and has power within 3 days of activation.
			</div>
		</div>
		<div class="col-xs-12 form">
			<div class="form_header">
				<h3>Upgrade to Live Activation</h3>
				<span class="help-info">(* - fields are required)</span>
				<div class="form_header_divider"></div>
			</div>



			<form id="form-upgrade" data-toggle="validator" role="form" class="form-upgrade" >
				<input type="hidden" name="projectNumber" id="projectNumber" value="22">
				<input type="hidden" name="dealerToken" id="dealerToken" value="">
				<input type="hidden" name="domain" id="domain" value="cartrack.co">
				<input type="hidden" name="deviceType" id="deviceType" value="">
				<input type="hidden" name="assetType" id="assetType" value="Car">
				<input type="hidden" name="reportSubject" id="reportSubject" value="Upgrade to Live Asset Activation">


				<div class="form_section purchased_from_section">
					<h2>Purchased from</h2>
					<div class="form_divider"></div>
					<div class="row">
						<div class="form-group col-xs-12">
					  	  	<label for="dealerName" class="control-label">Dealer Name<span class="color-red">*</span></label>
					  	  	<input type="text" class="form-control clearAfter" id="dealerName" name="dealerName" placeholder="" required maxlength="100">
					  	</div>
					</div>

				</div>
				<div class="form_section">
					<h2>account</h2>
					<div class="form_divider"></div>
					<div class="row">
						<div class="form-group col-xs-12">
						  	<label for="account" class="control-label">Login Name / Email<span class="color-red">*</span></label>
						  	<input type="text" class="form-control clearAfter" id="account" name="account" placeholder="" maxlength="100" required >
						</div>
					</div>

					<!-- <div class="form-group">
											  	  	<label for="imeiOld" class="control-label">Old IMEI<span class="color-red">*</span></label>
											  	  	<input type="text" class="form-control clearAfter" id="imeiOld" name="imeiOld" value="" maxlength="16" required>
											  	</div> -->
				</div>

				<div class="form_section">
					<h2>asset</h2>
					<div class="form_divider"></div>
					<div class="row">
						<div class="form-group col-xs-12">
					  	  	<label for="imei" class="control-label">IMEI <span class="help-info">(recorded on device)<span class="color-red">*</span></span></label>
					  	  	<input type="text" class="form-control clearAfter" id="imei" name="imei" value="" maxlength="16" required>
					  	  	<!-- <h1>Remove the 0 at the start of the IMEI number and enter the remaining 15 digits</h1> -->
					  	</div>
					</div>
          <div class="row">
          	<div class="form-group col-xs-12 col-sm-6">
              <label for="rego" class="control-label">Registration<span class="color-red">*</span></label>
              <input type="text" class="form-control clearAfter" id="rego" name="rego" placeholder="" required maxlength="200">
            </div>
            <div class="form-group col-xs-12 col-sm-6">
              <label for="name" class="control-label">Asset Name<span class="color-red">*</span></label>
              <input type="text" class="form-control clearAfter" id="name" name="name" placeholder="" required maxlength="200">
            </div>

          </div>

					<div class="row form-group">
						<div class="col-xs-12">
							<label for="describe1" class="control-label">Asset Type<span class="color-red">*</span></label>
						</div>
						<div class="col-auto">
							<div class="asset-type-icon-wrapper active" data-type="Car" data-toggle="tooltip" title="Car">
								<i class="icon icon-car"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Truck" data-toggle="tooltip" title="Fleet">
								<i class="icon icon-fleet"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Boat" data-toggle="tooltip" title="Boat">
								<i class="icon icon-boat"></i>
							</div>
						</div>
                        <div class="col-auto ">
                            <div class="asset-type-icon-wrapper" data-type="SUV" data-toggle="tooltip" title="SUV">
                                <i class="icon icon-suv"></i>
                            </div>
                        </div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Jetski" data-toggle="tooltip" title="Jetski">
								<i class="icon icon-jetski"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Plant and Equipment" data-toggle="tooltip" title="Plant">
								<i class="icon icon-plant"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Bus" data-toggle="tooltip" title="Bus">
								<i class="icon icon-bus"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Bike" data-toggle="tooltip" title="Bike">
								<i class="icon icon-moto"></i>
							</div>
						</div>
						<!-- <div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="16" data-toggle="tooltip" title="Dron">
								<i class="icon icon-dron"></i>
							</div>
						</div> -->
						<!-- <div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="32" data-toggle="tooltip" title="Plane">
								<i class="icon icon-plane"></i>
							</div>
						</div> -->
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Containor" data-toggle="tooltip" title="Container">
								<i class="icon icon-container"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Trailer" data-toggle="tooltip" title="Trailer">
								<i class="icon icon-trailer1"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Caravan" data-toggle="tooltip" title="Caravan">
								<i class="icon icon-caravan"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Dump Truck" data-toggle="tooltip" title="Dump Truck">
								<i class="icon icon-dumptruck"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Personal" data-toggle="tooltip" title="Personal">
								<i class="icon icon-person"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Pet" data-toggle="tooltip" title="Pet">
								<i class="icon icon-pet"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="WiTi" data-toggle="tooltip" title="WiTi">
								<i class="icon icon-witi"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Other" data-toggle="tooltip" title="Other">
								<i class="icon icon-other"></i>
							</div>
						</div>
					</div>

					<div class="row">
						<div class="form-group col-xs-12 col-sm-3">
					  	  	<label for="describe1" class="control-label">Make<span class="color-red">*</span></label>
					  	  	<input type="text" class="form-control clearAfter" id="describe1" name="describe1" placeholder="" required maxlength="200">
					  	</div>
					  	<div class="form-group col-xs-12 col-sm-3">
					  	  	<label for="describe2" class="control-label">Model<span class="color-red">*</span></label>
					  	  	<input type="text" class="form-control clearAfter" id="describe2" name="describe2" placeholder="" required maxlength="200">
					  	</div>
					  	<div class="form-group col-xs-12 col-sm-3">
					  	  	<label for="describe3" class="control-label">Color<span class="color-red">*</span></label>
					  	  	<input type="text" class="form-control clearAfter" id="describe3" name="describe3" placeholder="" required maxlength="200">
					  	</div>
					  	<div class="form-group col-xs-12 col-sm-3">
					  	  	<label for="describe4" class="control-label">Year<span class="color-red">*</span></label>
					  	  	<input type="text" class="form-control clearAfter only_numbers" id="describe4" name="describe4" placeholder="" required maxlength="200">
					  	</div>
					</div>

					<div class="row">
						<div class="form-group  col-xs-12 col-sm-6">
					  	  	<label for="solution" class="control-label">Solution Type <a target="_blank" href="https://quiktrak.com.au/plans.php#plans" class="help-info">(view Solution Types)</a><span class="color-red">*</span></label>
					  	  	<select id="solution" name="solution" class="selectpicker form-control" title="- Select Solution Type -" data-size="8" disabled required>
					  	  		<!-- <option value="BikeProtect" >BikeProtect</option>
					  	  							      	<option value="boatloc8" >BoatLoc8</option>
					  	  							      	<option value="boatprotect" >BoatProtect</option>
					  	  							      	<option value="boatwatch" >BoatWatch</option>
					  	  							      	<option value="carwatch" >CarWatch</option>
					  	  							      	<option value="fleetwatch" >FleetWatch</option>
					  	  							      	<option value="fleetwatch_ibutton"  data-subtext="(with iButton)">FleetWatch </option>
					  	  							      	<option value="fuelwatch_fuel"  data-subtext="(with Fuel)">FuelWatch </option>
					  	  							      	<option value="plantloc8" >PlantLoc8</option>
					  	  							      	<option value="plantprotect" >PlantProtect</option>
					  	  							      	<option value="plantwatch" >PlantWatch</option>
					  	  							      	<option value="quikloc8" >QuikLoc8</option>
					  	  							      	<option value="quikprotect" >QuikProtect</option>
					  	  							      	<option value="quiktrak" >QuikTrak</option>		 -->
						    </select>
						    <!-- <div class="help-block with-errors"></div> -->
					  	</div>
						<div class="form-group  col-xs-12 col-sm-6">
					  	  	<label for="servicePlan" class="control-label">Service Plan<span class="color-red">*</span></label>
					  	  	<select id="servicePlan" name="servicePlan" class="selectpicker form-control" title="- Select Service Plan -" data-size="8" disabled required>
					  	  		<!-- <option value="0000000000000" data-plantype="0">Protect</option>
					  	  						      	<option value="QUIKLOC800000" data-plantype="8">Loc8</option>
					  	  						      						      	<option value="1C783FA4TRAK" data-plantype="1">Track Only Annual</option>
					  	  						      						      	<option value="LR6Z8YPFC8PHJ" data-plantype="3">Track Only Monthly</option>
					  	  						      						      	<option value="2Y6Z8YPFC8P2Y" data-plantype="10">Track Only 2 years</option>
					  	  						      						      	<option value="4Y6Z8YPFC8P4Y" data-plantype="11">Track Only 3 years</option>
					  	  						      						      	<option value="1C8D3EDEMOTI" data-plantype="2">Full Alarm Monitoring Annual</option>
					  	  						      						      	<option value="33ENPEYR38SRC" data-plantype="5">Full Alarm Monitoring Monthly</option>	 -->
						    </select>
						    <!-- <div class="help-block with-errors"></div> -->
					  	</div>

					</div>

					<div class="row">
						<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="fitoptions" class="control-label">Fitment Options</label>
					  	  	<select id="fitoptions" name="fitoptions" class="selectpicker form-control" title="- Select Fitment Options -" data-size="8" multiple disabled>
					  	  		<!-- <option value="2" >Alarm Integration</option>
					  	  		<option value="16">Fitment After Isolator</option>
					  	  		<option value="8" >Not Connected to Ignition/Accessory Power</option>
					  	  		<option value="1" >Remote Immobilisation</option>
					  	  		<option value="4" >SOS Button</option>

								<option value="128" >Bilge Alarm</option>
					  	  		<option value="32" >Engine Theft</option>
					  	  		<option value="1" >Remote Immobilisation</option>
					  	  		<option value="256" >Shore Power Disconnect</option>
					  	  		<option value="64" >Siren</option> -->
						    </select>
						</div>
						<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="instalLocation" class="control-label">Installation Location <span class="hint-icon-wrapper" data-toggle="tooltip" title="Location of device within the asset"><i class="icon icon-hint"></i></span></label>
					  	  	<input type="text" class="form-control clearAfter" id="instalLocation" name="instalLocation" placeholder=""  maxlength="200">
					  	</div>
					</div>
        </div>

        <div class="form_section input-configuration-section-wrapper" style="display: none;">
          <p >Has the device inputs been connected ?</p>
          <div class="row">
            <div class="form-group col-xs-12">
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isDeviceInputsConnected" value="no" checked>
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>No</span>
                </label>
              </div>
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isDeviceInputsConnected" value="yes">
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>Yes</span>
                </label>
              </div>
            </div>
          </div>

          <div class="input-configuration-section" style="display: none;">
            <h2 class="accordion-toggle " role="button" data-toggle="collapse" href="#collapseInputConfiguration" aria-expanded="true" aria-controls="collapseInputConfiguration">Input Configuration</h2>
            <div class="form_divider"></div>
            <div id="collapseInputConfiguration" class="panel-collapse collapse in " >

              <div class="row row-Input1 " style="display: none;">
                <div class="col-xs-12">
                  <h4>Input1</h4>
                  <div class="form_divider"></div>
                </div>
                <div class="form-group col-xs-12 col-sm-4">
                  <label for="Input1" class="control-label">Input1 Name</label>
                  <select id="Input1" name="Input1" class="selectpicker form-control" title="- Select -" data-size="8">
                    <option data-icon="f7-icons " value="NONE">None</option>
                    <option data-icon="f7-icons icon-input-car-alarm" value="ACC2">ACC2</option>
                    <option data-icon="f7-icons icon-input-car-alarm3" value="ALARM">Alarm</option>
                    <option data-icon="f7-icons icon-input-bilge-alarm" value="BILGE">Bilge</option>
                    <option data-icon="f7-icons icon-input-door-alarm" value="DOOR">Door</option>
                    <option data-icon="f7-icons icon-input-pto-alarm" value="PTO">PTO</option>
                    <option data-icon="f7-icons icon-input-shore-power" value="SHORE">Shore</option>
                    <option data-icon="f7-icons icon-input-snow-plow" value="PLOW">Snow Plow</option>
                    <option data-icon="f7-icons icon-input-tilt-alarm" value="TILT">Tilt</option>
                  </select>
                </div>
                <div class="form-group col-xs-12 col-sm-4">
                  <label for="Input1MaskTime" class="control-label">Mask Time</label>
                  <select id="Input1MaskTime" name="Input1MaskTime" class="selectpicker form-control" title="- Select -" data-size="8">
                    <option value="5" selected>5 seconds</option>
                    <option value="10">10 seconds</option>
                    <option value="30">30 seconds</option>
                  </select>
                </div>
                <div class="form-group col-xs-12 col-sm-4">
                  <label for="Input1Type" class="control-label">Type</label>
                  <select id="Input1Type" name="Input1Type" class="selectpicker form-control" title="- Select -" data-size="8">
                    <option value="-Ve" selected>-Ve</option>
                    <option value="+Ve">+Ve</option>
                  </select>
                </div>
              </div>
              <div class="row row-Input2" style="display: none;">
                <div class="col-xs-12">
                  <h4>Input2</h4>
                  <div class="form_divider"></div>
                </div>
                <div class="form-group col-xs-12 col-sm-4">
                  <label for="Input2" class="control-label">Input2 Name</label>
                  <select id="Input2" name="Input2" class="selectpicker form-control" title="- Select -" data-size="8">
                    <option data-icon="f7-icons " value="NONE">None</option>
                    <option data-icon="f7-icons icon-input-car-alarm" value="ACC2">ACC2</option>
                    <option data-icon="f7-icons icon-input-car-alarm3" value="ALARM">Alarm</option>
                    <option data-icon="f7-icons icon-input-bilge-alarm" value="BILGE">Bilge</option>
                    <option data-icon="f7-icons icon-input-door-alarm" value="DOOR">Door</option>
                    <option data-icon="f7-icons icon-input-pto-alarm" value="PTO">PTO</option>
                    <option data-icon="f7-icons icon-input-shore-power" value="SHORE">Shore</option>
                    <option data-icon="f7-icons icon-input-snow-plow" value="PLOW">Snow Plow</option>
                    <option data-icon="f7-icons icon-input-tilt-alarm" value="TILT">Tilt</option>
                  </select>
                </div>
                <div class="form-group col-xs-12 col-sm-4">
                  <label for="Input2MaskTime" class="control-label">Mask Time</label>
                  <select id="Input2MaskTime" name="Input2MaskTime" class="selectpicker form-control" title="- Select -" data-size="8">
                    <option value="5" selected>5 seconds</option>
                    <option value="10">10 seconds</option>
                    <option value="30">30 seconds</option>
                  </select>
                </div>
                <div class="form-group col-xs-12 col-sm-4">
                  <label for="Input2Type" class="control-label">Type</label>
                  <select id="Input2Type" name="Input2Type" class="selectpicker form-control" title="- Select -" data-size="8">
                    <option value="-Ve" >-Ve</option>
                    <option value="+Ve" selected>+Ve</option>
                  </select>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!--<div class="form_section power_settings_wrapper" style="display: none;">
          <h2>Power Settings</h2>
          <div class="form_divider"></div>
          <div class="row-flex">
            <div class="form-group col col_lower_power" style="display: none;">
              <label for="LowerPower" class="control-label">Lower Power(V)</label>
              <input type="tel" class="form-control only_numbers_double clearAfter" id="LowerPower" name="LowerPower" placeholder="" maxlength="190">
            </div>
            <div class="form-group col col_disconnect_power" style="display: none;">
              <label for="DisconnectPower" class="control-label">Disconnect Power(V)</label>
              <input type="tel" class="form-control only_numbers_double clearAfter" id="DisconnectPower" name="DisconnectPower" placeholder="" maxlength="190">
            </div>
            <div class="form-group col col_ignition_power" style="display: none;">
              <label for="IgnitionPower" class="control-label">Ignition Power(V)</label>
              <input type="tel" class="form-control only_numbers_double clearAfter" id="IgnitionPower" name="IgnitionPower" placeholder="" maxlength="190">
            </div>
          </div>
        </div>-->

        <div class="form_section">
          <h2>Other Asset Details</h2>
          <div class="form_divider"></div>
					<div class="row">
						<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="initialMileage" class="control-label">Initial Mileage <span class="help-info">(km)</span></label>
					  	  	<input type="tel" class="form-control only_numbers_and_negative clearAfter" id="initialMileage" name="initialMileage" placeholder="" maxlength="200">
					  	</div>
					  	<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="initialEngineHours" class="control-label">Initial Engine Hours <span class="help-info">(h)</span></label>
					  	  	<input type="tel" class="form-control only_numbers_and_negative clearAfter" id="initialEngineHours" name="initialEngineHours" placeholder="" maxlength="200">
					  	</div>
					</div>

					<div class="row">
						<div class="form-group col-xs-12 ">
							<label for="notes" class="control-label">Notes</label>
							<textarea name="notes" id="notes" class="form-control clearAfter"  maxlength="500"></textarea>
						</div>
					</div>

					<p >Has the device been installed and the asset currently has power ?</p>
					<div class="row">
						<div class="form-group col-xs-12">
							<div class="radio animated flipInX">
						      	<label class="control-label padding-left-0">
						        	<input type="radio" name="isDeviceInstalled" value="no" checked>
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	<span>No</span>
						      	</label>
						    </div>
						    <div class="radio animated flipInX">
						    	<label class="control-label padding-left-0">
						        	<input type="radio" name="isDeviceInstalled" value="yes">
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	<span>Yes</span>
						      	</label>
						    </div>
						</div>
					</div>
          <p>Connected to Ignition ?</p>
          <div class="row">
            <div class="form-group col-xs-12">
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isConnectedToIgnition" value="no" >
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>No</span>
                </label>
              </div>
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isConnectedToIgnition" value="yes" checked>
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>Yes</span>
                </label>
              </div>
            </div>
          </div>
					<div class="form_divider"></div>

					<div class="row groupAutoSuspend" style="display: none;">
						<div class="form-group col-xs-12 ">
						    <div class="checkbox">
						      	<label class="control-label padding-left-0">
						        	<input type="checkbox" id="autosuspend" name="autosuspend" >
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	Auto Suspend
						      	</label>
							     <div class="help-block with-errors"></div>
						    </div>
						</div>
					</div>
				  	<!-- <div class="form-group">
				  	  	<label for="deviceType" class="control-label">Device Type:</label>
				  	  	<input type="text" class="form-control clearAfter" id="deviceType" name="deviceType" data-code="" placeholder="" readonly maxlength="100">
				  	</div> -->

				</div>

				<div class="form_section form_section_payment ">

					<h2 class="animated flipInX">Payment Type</h2>
					<div class="form_divider"></div>
					<div class="row">
						<div class="form-group col-xs-12">
							<div class="radio animated flipInX">
						      	<label class="control-label padding-left-0">
						        	<input type="radio" name="paymentType" value="1" required>
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	<span>Credit Card</span>
						      	</label>
						    </div>
							<!-- <div class="radio animated flipInX">
											    					      	<label class="control-label">
											    					        	<input type="radio" name="paymentType" value="2" required>
											    					        	<span>Bank Direct Debit</span>
											    					      	</label>
											    					    </div>	 -->
						    <div class="radio animated flipInX other_payment_method">
						    	<label class="control-label padding-left-0">
						        	<input type="radio" name="paymentType" value="3" required>
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	<span>By Invoice</span>
						      	</label>
						    </div>
						    <div class="radio animated flipInX other_payment_method">
						    	<label class="control-label padding-left-0">
						        	<input type="radio" name="paymentType" value="4" required>
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	<span>Subscription Code</span>
						      	</label>
						    </div>
						</div>
					</div>

					<div class="paymentFieldWrapper creditCardWrapper ">
						<div class="row">
							<div class="form-group col-xs-12">
								<div class="radio animated flipInX">
							      	<label class="control-label padding-left-0">
							        	<input type="radio" name="ccType" value="Visa" >
							        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
							        	<span><img src="images/visa.png" alt=""></span>
							      	</label>
							    </div>
							    <div class="radio animated flipInX">
							    	<label class="control-label padding-left-0">
							        	<input type="radio" name="ccType" value="MasterCard" >
							        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
							        	<span><img src="images/mc.png" alt=""></span>
							      	</label>
							    </div>
							    <div class="radio animated flipInX">
							    	<label class="control-label padding-left-0">
							        	<input type="radio" name="ccType" value="Amex" >
							        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
							        	<span><img src="images/amex.png" alt=""></span>
							      	</label>
							    </div>
							</div>
						</div>
						<div class="row">
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="ccNumber" class="control-label animated flipInX ">Credit Card Number<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="ccNumber" name="ccNumber" placeholder=""  maxlength="200">
							</div>
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="ccCVV" class="control-label animated flipInX ">CVV<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="ccCVV" name="ccCVV" placeholder=""  maxlength="200">
							</div>
						</div>
						<div class="row">
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="ccExpiryDate" class="control-label animated flipInX ">Expiry Date<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="ccExpiryDate" name="ccExpiryDate" placeholder=""  maxlength="200">
							</div>
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="ccNameOnCard" class="control-label animated flipInX ">Name on Card<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="ccNameOnCard" name="ccNameOnCard" placeholder=""  maxlength="200">
							</div>
						</div>

					</div>
					<!-- <div class="paymentFieldWrapper bankDirectWrapper ">
								<div class="form-group">
							  	  	<label for="bankAccountName" class="control-label animated flipInX ">Bank Account Name:</label>
							  	  	<input type="text" class="form-control clearAfter animated flipInX " id="bankAccountName" name="bankAccountName" placeholder=""  maxlength="200">
								</div>
								<div class="form-group">
							  	  	<label for="bankName" class="control-label animated flipInX ">Bank Name:</label>
							  	  	<input type="text" class="form-control clearAfter animated flipInX " id="bankName" name="bankName" placeholder=""  maxlength="200">
								</div>
								<div class="form-group">
							  	  	<label for="bankBSB" class="control-label animated flipInX ">BSB:</label>
							  	  	<input type="text" class="form-control clearAfter animated flipInX " id="bankBSB" name="bankBSB" placeholder=""  maxlength="200">
								</div>
								<div class="form-group">
							  	  	<label for="bankAccountNumber" class="control-label animated flipInX">Account Number:</label>
							  	  	<input type="text" class="form-control clearAfter animated flipInX " id="bankAccountNumber" name="bankAccountNumber" placeholder=""  maxlength="200">
								</div>
							</div>			 -->
					<div class="paymentFieldWrapper byInvoiceWrapper other_payment_method">
						<div class="row">
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="invoiceName" class="control-label animated flipInX ">Invoice Name<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="invoiceName" name="invoiceName" placeholder=""  maxlength="200">
							</div>
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="invoiceNumber" class="control-label animated flipInX ">Invoice Number</label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="invoiceNumber" name="invoiceNumber" placeholder=""  maxlength="200">
							</div>
						</div>
						<div class="row">
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="invoiceRUT" class="control-label animated flipInX ">Tax ID</label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="invoiceRUT" name="invoiceRUT" placeholder=""  maxlength="200">
							</div>
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="invoiceEmail" class="control-label animated flipInX">Email Address for Invoice<span class="color-red">*</span></label>
						  	  	<input type="email" class="form-control clearAfter animated flipInX " id="invoiceEmail" name="invoiceEmail" data-error="That email address is invalid" placeholder=""  maxlength="200">
						  	  	<div class="help-block with-errors"></div>
							</div>
						</div>
					</div>

					<div class="paymentFieldWrapper byVoucherWrapper other_payment_method">
						<div class="row">
							<div class="form-group col-xs-12 ">
						  	  	<label for="voucherCode" class="control-label animated flipInX ">Code<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="voucherCode" name="voucherCode" placeholder=""  maxlength="200">
							</div>
						</div>
					</div>

				</div>

				<div class="form_section  margin-bottom-40">
					<div class="form-group ">
						<div class="checkbox">
					      	<label class="control-label padding-left-0">
					        	<input type="checkbox" id="terms" name="terms" required>
					        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
					        	I agree to be bound by the Terms and Conditions which can be found at <a target="_blank" href="https://quiktrak.com.au/">quiktrak.com.au</a>
					      	</label>
					    </div>
					</div>
				</div>


			  	<div class="form_section">
				  	<div class="form-group margin-0 ">
				  	  	<button type="submit" class="btn form_submit">
				  	  		<img class="preloader vis_hidden" src="images/loader.gif" alt="">
				  	  		<span class="submit_text">Submit</span>
				  	  	</button>
				  	  	<div class="help-block info"></div>
				  	</div>
				</div>
			</form>

			</div>

		</div>
	</div>
<?php include "footer.php"; ?>

	<script src="js/jquery-1.12.0.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<script src="js/validator.min.js"></script>
	<script src="js/bootstrap-select.min.js"></script>
	<script src="js/materialPreloader.min.js"></script>
	<script src="js/initialScript.js?v=<?php echo filemtime('js/initialScript.js'); ?>"></script>
	<script src="js/upgrade-to-live.js?v=<?php echo filemtime('js/upgrade-to-live.js'); ?>"></script>

	<!-- mask input -->
	<script src="js/maskedinput.js"></script>


	<script>
		var imeis = GetURLParameter('imeis');
		if (imeis) {
			$('#imei').val(imeis);
			getDefaultParams(imeis,DealerTokenUrl);
		}



		if (DealerTokenUrl && imeis) {
			getUserDetails({
				imeis: imeis,
				majortoken: DealerTokenUrl,
			});

		}else{
			alert('Dealer token is missing');
			$('.info').html('<div class="errors">Dealer token is missing</div>');
		}

		/*$('#imei').on('blur', function(){
			$(this).val( $(this).val().padStart(16,0) );
		});*/

		function getUserDetails(params){
			$.ajax({
				type: "GET",
				url: "https://newapi.quiktrak.co/Common/v1/Activation/GetAssetsInfo",
				dataType: 'json',
				data: params,
				async: true,
				cache: false,
				beforeSend: function(){
					wait_save_data = 0;
					$('.form_submit').toggleClass('disabled');
					$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
				},
				success: function(result){
					wait_save_data = 1;
					$('.form_submit').toggleClass('disabled');
					$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
					console.log(result);
					var MajorCode = result.MajorCode;
					if (MajorCode == '000') {
						if (result.Data) {
							setUserDetails(result.Data);
						}
					}else{
						$('.info').html('<div class="errors">This IMEI '+params.imeis+' not belong to Dealer Account '+$(dealerName).val()+'</div>');
					}
				},
				error: function(XMLHttpRequest, textStatus, errorThrown){
					console.log(XMLHttpRequest);
					console.log(textStatus);
					console.log(errorThrown);
					wait_save_data = 1;
					$('.form_submit').toggleClass('disabled');
					$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
				}
			});
		}

		function setUserDetails(params) {
			if (params && typeof(params) == 'object' && params.Assets && typeof(params.Assets) == 'object' && params.Assets[0] && typeof(params.Assets[0]) == 'object') {
				if (params.Name){
					$('#dealerName').val(params.Name);
					$('#invoiceName').val(params.Name);
				}

				if (params.Email) {
					$('#invoiceEmail').val(params.Email);
				}
				if (params.Assets[0].LoginName) {
					$('#account').val(params.Assets[0].LoginName);
				}
				if (params.Assets[0].Name && !$('#name').val()) {
					$('#name').val(params.Assets[0].Name);
				}
				if (params.Assets[0].Registration && !$('#rego').val()) {
					$('#rego').val(params.Assets[0].Registration);
				}
				if (params.Assets[0].Make && !$('#describe1').val()) {
					$('#describe1').val(params.Assets[0].Make);
				}
				if (params.Assets[0].Model && !$('#describe2').val()) {
					$('#describe2').val(params.Assets[0].Model);
				}
				if (params.Assets[0].Color && !$('#describe3').val()) {
					$('#describe3').val(params.Assets[0].Color);
				}
				if (params.Assets[0].Year && !$('#describe4').val()) {
					$('#describe4').val(params.Assets[0].Year);
				}

				if (params.Assets[0].AssetType) {
					$('.asset-type-icon-wrapper[data-type="'+params.Assets[0].AssetType+'"]').click();
				}

				if (params.Assets[0].Solution) {
					/*setTimeout(function(){ $('#solution').selectpicker('val', params.Assets[0].Solution); }, 500);

					if (params.Assets[0].Solution == 'Protect' || params.Assets[0].Solution == 'Loc8') {
						$('input[name="paymentType"]').attr('required',false);
						$('.form_section_payment').hide();
					}else{
						$('input[name="paymentType"]').attr('required',true);
						$('.form_section_payment').show();
					}		*/
				}else{
					$('.form_section_payment').hide();
				}
			}
		}

	</script>
</body>
</html>