<?php

session_start();

if (isset($_REQUEST['flashvar']) && ! isset($_SESSION['flashvar'])) {

    // Store any parameters received
    $_SESSION['flashvar'] = $_REQUEST['flashvar'];

    // Redirecting without query parameters
    header('Location: /index.php');
    exit;
}

 
if (is_file(realpath('system/stripe-php/init.php'))) {
	require_once(realpath('system/stripe-php/init.php'));
}


// Set your secret key. Remember to switch to your live secret key in production.
// See your keys here: https://dashboard.stripe.com/apikeys
\Stripe\Stripe::setApiKey('sk_live_wz1r8mYdFPWPPAMLDrFMrj4P');  //   sk_live_wz1r8mYdFPWPPAMLDrFMrj4P


if (isset($_GET['email'])) {
	$email = $_GET['email'];

	try {
		$stripe = new \Stripe\StripeClient('sk_live_wz1r8mYdFPWPPAMLDrFMrj4P');

		$customers = $stripe->customers->all([
			'email' => $email,
			'limit' => 15,
		]);



		if (!empty($customers->data)) {
			$customerId = $customers->data[0]->id;
			$customer = $stripe->customers->retrieve($customerId);
			if (empty($customer->invoice_settings->default_payment_method)) {
				$is_default_payment_exists = false;
			}
		} else {
			$is_default_payment_exists = false;
			//echo "No customers found with this email.";
		}
	} catch (\Stripe\Exception\ApiErrorException $e) {
		echo "Stripe API error: " . $e->getMessage();
	} catch (Exception $e) {
		echo "Error: " . $e->getMessage();
	}
} else {
	//echo "Email query parameter is missing.";
}
?>


<!DOCTYPE html>
<html lang="en">
<head>

	<meta charset="UTF-8">
	<!-- <meta name="viewport" content="width=device-width"> -->
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<link rel="shortcut icon" href="images/favicon-live.png" type="image/x-icon">
	<link rel="stylesheet" type="text/css" href="css/normalize.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap-theme.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap-select.min.css" />
	<link rel="stylesheet" type="text/css" href="css/materialPreloader.min.css" />
	<link rel="stylesheet" type="text/css" href="css/animate.css" />
	<link rel="stylesheet" type="text/css" href="css/checkbox-radio.css" />
	<link rel="stylesheet" type="text/css" href="css/fonts.css" />
	<link rel="stylesheet" type="text/css" href="fonts/fontastic/styles.css?v=<?php echo filemtime('fonts/fontastic/styles.css'); ?>" />
	<link rel="stylesheet" type="text/css" href="css/style.css?v=<?php echo filemtime('css/style.css'); ?>" />
  <link rel="stylesheet" type="text/css" href="css/stripe.css" />
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.17/dist/sweetalert2.min.css" />
	<title>Registration</title>
</head>
<body class="bg_body">
	<?php include "header.php"; ?>
	<script>
		var isDefaultPaymentExists = <?php echo json_encode($is_default_payment_exists); ?>;
 
		if (isDefaultPaymentExists) {
			console.log("The default payment exists.");
		} else {
			console.log("The default payment does not exist.");
		}
	</script>
	<div class="container page page_register">
		<div class="col-xs-12 animated flipInX deivceInstalledTopWarning" style="display: none;">
			<div class="alert alert-warning max-width-940 mx-auto">
				<strong>Warning!</strong> The systems requires a series of commands to configure the unit and your account, please ensure the system is installed and has power within 3 days of activation.
			</div>
		</div>
		<div class="col-xs-12 form">
			<div class="form_header">
				<h3>Registration <?php echo urlencode($_SESSION['flashvar']) ?> </h3>
				<span class="help-info">(* - fields are required)</span>
				<div class="form_header_divider"></div>
			</div>
			<form name="activation" data-toggle="validator" role="form" class="form-register" id="form-register">
				<input type="hidden" name="projectNumber" id="projectNumber" value="22">
				<input type="hidden" name="dealerToken" id="dealerToken" value="">
				<input type="hidden" name="domain" id="domain" value="quiktrak.co">
				<input type="hidden" name="deviceType" id="deviceType" value="">
				<input type="hidden" name="assetType" id="assetType" value="Car">
				<input type="hidden" name="MajorToken" id="MajorToken" value="<?php echo $_GET['MajorToken'] ?>">
				<input type="hidden" name="MinorToken" id="MinorToken" value="<?php echo $_GET['MinorToken'] ?>">
				<input type="hidden" name="imei2" id="imei2" value="">
				<input type="hidden" name="extraPaymentMethod" id="extraPaymentMethod" value="">
				<input type="hidden" name="operator" id="operator" value="2">
				<input type="hidden" name="tree" id="tree" value="">
				<!--~~<input type="hidden" class="" id="dealerName" name="dealerName" placeholder="" required maxlength="190" value="Leisure Technologies - WiTi ADMIN">-->
				<div class="form_section">
					<h2>Purchased from</h2>
					<div class="form_divider"></div>
					<div class="row">
						<div class="form-group col-xs-12">
					  	  	<label for="dealerName" class="control-label">Dealer Name<span class="color-red">*</span></label>
					  	  	<input type="text" class="form-control clearAfter" id="dealerName" name="dealerName" placeholder="" required maxlength="190">
					  	</div>
					</div>

				</div>

				<div class="form_section">
					<h2>personal</h2>
					<div class="form_divider"></div>
					<div class="row">
						<div class="form-group col-xs-12">
					  	  	<label for="accountName" class="control-label">Account Name<span class="color-red">*</span></label>
					  	  	<input type="text" class="form-control clearAfter" id="accountName" name="accountName" placeholder="" required maxlength="190">
					  	</div>
					</div>
				  	<div class="row">
				  		<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="firstName" class="control-label">First Name<span class="color-red">*</span></label>
					  	  	<input type="text" class="form-control clearAfter" id="firstName" name="firstName" placeholder="" required maxlength="190">
					  	</div>
					  	<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="subName" class="control-label">Last Name<span class="color-red">*</span></label>
					  	  	<input type="text" class="form-control clearAfter" id="subName" name="subName" placeholder="" required maxlength="190">
					  	</div>
				  	</div>

				</div>
				<div class="form_section">
					<h2>account</h2>
					<div class="form_divider"></div>
					<div class="row">
						<div class="form-group col-xs-12 col-sm-6">
						  	<label for="account" class="control-label">Login Name<span class="color-red">*</span></label>
                            <input type="text" class="form-control clearAfter" id="account" name="account" placeholder="" required data-error="Invalid login name - we do not allow special characters or spaces" maxlength="100" pattern="^[aA-z0-9_@.+-]{3,100}$">
                            <div class="help-block with-errors"></div>
						</div>
					  	<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="email" class="control-label">Clients Email<span class="color-red">*</span></label>
					  	  	<input type="email" class="form-control clearAfter" id="email" name="email" placeholder="" data-error="That email address is invalid" required maxlength="190">
					  	  	<div class="help-block with-errors"></div>
					  	</div>
					</div>


				</div>
				<div class="form_section">
					<h2>asset</h2>
					<div class="form_divider"></div>
					<div class="row">
						<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="imei" class="control-label">IMEI <span class="help-info">(recorded on device)<span class="color-red">*</span></span></label>
					  	  	<input type="text" class="form-control clearAfter" id="imei" name="imei" value="" maxlength="16" required>
					  	  	<!-- <h1>Remove the 0 at the start of the IMEI number and enter the remaining 15 digits</h1> -->
					  	</div>
						<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="name" class="control-label">Name / Registration<span class="color-red">*</span></label>
					  	  	<input type="text" class="form-control clearAfter" id="name" name="name" placeholder="" required maxlength="190">
					  	</div>

            <div class="form-group col-xs-12  col-sm-12">
              <label for="vin" class="control-label">VIN Number<span class="color-red"></span></label>
              <input type="text" class="form-control clearAfter" id="vin" name="vin"  maxlength="190">
            </div>
					</div>

					<div class="row form-group">
						<div class="col-xs-12">
							<label for="describe1" class="control-label">Asset Type<span class="color-red">*</span></label>
						</div>
						<div class="col-auto">
							<div class="asset-type-icon-wrapper active" data-type="Car" data-toggle="tooltip" title="Car">
								<i class="icon icon-car"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Truck" data-toggle="tooltip" title="Fleet">
								<i class="icon icon-fleet"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Boat" data-toggle="tooltip" title="Boat">
								<i class="icon icon-boat"></i>
							</div>
						</div>
            <div class="col-auto ">
                <div class="asset-type-icon-wrapper" data-type="SUV" data-toggle="tooltip" title="SUV">
                    <i class="icon icon-suv"></i>
                </div>
            </div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Jetski" data-toggle="tooltip" title="Jetski">
								<i class="icon icon-jetski"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Plant and Equipment" data-toggle="tooltip" title="Plant">
								<i class="icon icon-plant"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Bus" data-toggle="tooltip" title="Bus">
								<i class="icon icon-bus"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Bike" data-toggle="tooltip" title="Bike">
								<i class="icon icon-moto"></i>
							</div>
						</div>
						<!-- <div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="16" data-toggle="tooltip" title="Dron">
								<i class="icon icon-dron"></i>
							</div>
						</div> -->
						<!-- <div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="32" data-toggle="tooltip" title="Plane">
								<i class="icon icon-plane"></i>
							</div>
						</div> -->
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Containor" data-toggle="tooltip" title="Container">
								<i class="icon icon-container"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Trailer" data-toggle="tooltip" title="Trailer">
								<i class="icon icon-trailer1"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Caravan" data-toggle="tooltip" title="Caravan">
								<i class="icon icon-caravan"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Dump Truck" data-toggle="tooltip" title="Dump Truck">
								<i class="icon icon-dumptruck"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Personal" data-toggle="tooltip" title="Personal">
								<i class="icon icon-person"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Pet" data-toggle="tooltip" title="Pet">
								<i class="icon icon-pet"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper " data-type="WiTi" data-toggle="tooltip" title="WiTi">
								<i class="icon icon-witi"></i>
							</div>
						</div>
						<div class="col-auto ">
							<div class="asset-type-icon-wrapper" data-type="Other" data-toggle="tooltip" title="Other">
								<i class="icon icon-other"></i>
							</div>
						</div>
					</div>

					<div class="row">
						<div class="form-group col-xs-12 col-sm-3">
              <label for="describe1" class="control-label">Make<span class="color-red">*</span></label>
              <input type="text" class="form-control clearAfter" id="describe1" name="describe1" placeholder="" required maxlength="50">
            </div>
            <div class="form-group col-xs-12 col-sm-3">
              <label for="describe2" class="control-label">Model<span class="color-red">*</span></label>
              <input type="text" class="form-control clearAfter" id="describe2" name="describe2" placeholder="" required maxlength="50">
            </div>
            <div class="form-group col-xs-12 col-sm-3">
              <label for="describe3" class="control-label">Color<span class="color-red">*</span></label>
              <input type="text" class="form-control clearAfter" id="describe3" name="describe3" placeholder="" required maxlength="50">
            </div>
            <div class="form-group col-xs-12 col-sm-3">
              <label for="describe4" class="control-label">Year<span class="color-red">*</span></label>
              <input type="text" class="form-control clearAfter only_numbers" id="describe4" name="describe4" placeholder="" required maxlength="50">
            </div>
			</div>
					<div class="row">
						<div class="form-group  col-xs-12 col-sm-6">
              <label for="solution" class="control-label">Solution Type  <a target="_blank" href="https://quiktrak.com.au/service-plans.html" class="help-info" style="font-family:inherit">(view Solution Types)</a><span class="color-red">*</span></label>
              <select id="solution" name="solution" class="selectpicker form-control" title="- Select Solution Type -" data-size="8" disabled required>
              </select>
            </div>

						<div class="form-group  col-xs-12 col-sm-6">
              <label for="servicePlan" class="control-label">Service Plan<span class="color-red">*</span></label>
              <select id="servicePlan" name="servicePlan" class="selectpicker form-control" title="- Select Service Plan -" data-size="8" disabled required>
              </select>
            </div>








            <div class="form-group  col-xs-12 col-sm-6">
              <label for="extendedServicePlan" class="control-label">Extend Service Plan</label>
              <select id="extendedServicePlan" name="extendedServicePlan" class="selectpicker form-control" title="- Select Extended Plan -" data-size="8"  disabled>
    
              </select>
            </div>
            <div class="form-group  col-xs-12 col-sm-6">
              <label for="extendedServiceWarranty" class="control-label">Extended Warranty</label>
              <select id="extendedServiceWarranty" name="extendedServiceWarranty" class="selectpicker form-control" title="- Select Extended Warranty Plan -" data-size="8" disabled >
               
              </select>
              <span class="help-info" style="color:rgb(98, 98, 98);">(Standard Warranty is 2 years)</span>
            </div>







            <!--<div class="form-group  col-xs-12 ">
              <label for="extraServices" class="control-label">Extra Services</label>
              <select id="extraServices" name="extraServices" class="selectpicker form-control" title="- Select Extra Services -" data-size="8" multiple>
                <option value="iridium">WiTi Iridium</option>
              </select>
            </div>-->

						<div class="form-group col-xs-12 col-sm-6">
              <label for="fitoptions" class="control-label">Fitment Options</label>
              <select id="fitoptions" name="fitoptions" class="selectpicker form-control" title="- Select Fitment Options -" data-size="8" multiple disabled>
              </select>
						</div>
						<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="instalLocation" class="control-label">Installation Location <span class="hint-icon-wrapper" data-toggle="tooltip" title="Location of device within the asset"><i class="icon icon-hint"></i></span></label>
					  	  	<input type="text" class="form-control clearAfter" id="instalLocation" name="instalLocation" placeholder=""  maxlength="190">
            </div>
			
			</div>
			
			
			
			
			<div class="form_section iridium-configuration-section-wrapper" style="display: none;">
			  <p >Activate iridium?</p>
			  <div class="row">
				<div class="form-group col-xs-12">
				  <div class="radio animated flipInX">
					<label class="control-label padding-left-0">
					  <input type="radio" name="isDeviceIridiumConnected" value="no">
					  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
					  <span>No</span>
					</label>
				  </div>
				  <div class="radio animated flipInX">
					<label class="control-label padding-left-0">
					  <input type="radio" name="isDeviceIridiumConnected" value="yes">
					  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
					  <span>Yes</span>
					</label>
				  </div>
				</div>
			  </div>
			</div>

<!---->

<!---->

<div class="form_section input-configuration-section-wrapper" style="display: none;">
			  <p >Has the device inputs been connected ?</p>
			  <div class="row">
				<div class="form-group col-xs-12">
				  <div class="radio animated flipInX">
					<label class="control-label padding-left-0">
					  <input type="radio" name="isDeviceInputsConnected" value="notselected" checked>
					  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
					  <span>Ignore</span>
					</label>
				  </div>
				  <div class="radio animated flipInX">
					<label class="control-label padding-left-0">
					  <input type="radio" name="isDeviceInputsConnected" value="no">
					  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
					  <span>No</span>
					</label>
				  </div>
				  <div class="radio animated flipInX">
					<label class="control-label padding-left-0">
					  <input type="radio" name="isDeviceInputsConnected" value="yes">
					  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
					  <span>Yes</span>
					</label>
				  </div>
				</div>
			  </div>

			  <div class="input-configuration-section" style="display: none;">
				<h2 class="accordion-toggle " role="button" data-toggle="collapse" href="#collapseInputConfiguration" aria-expanded="true" aria-controls="collapseInputConfiguration">Input Configuration</h2>
				<div class="form_divider"></div>
				<div id="collapseInputConfiguration" class="panel-collapse collapse in " >

				  <div class="row row-Input1 " style="display: none;">
					<div class="col-xs-12">
					  <h4>Input1</h4>
					  <div class="form_divider"></div>
					</div>
					<div class="form-group col-xs-12 col-sm-4">
					  <label for="Input1" class="control-label">Input1 Name</label>
					  <select id="Input1" name="Input1" class="selectpicker form-control" title="- Select -" data-size="8">
						<option data-icon="f7-icons " value="Input1">None</option>
						<option data-icon="f7-icons icon-input-car-alarm" value="ACC2">ACC2</option>
						<option data-icon="f7-icons icon-input-car-alarm3" value="ALARM">Alarm</option>
						<option data-icon="f7-icons icon-input-bilge-alarm" value="BILGE">Bilge</option>
						<option data-icon="f7-icons icon-input-door-alarm" value="DOOR">Door</option>
						<option data-icon="f7-icons icon-input-pto-alarm" value="PTO">PTO</option>
						<option data-icon="f7-icons icon-input-shore-power" value="SHORE">Shore</option>
						<option data-icon="f7-icons icon-input-snow-plow" value="PLOW">Snow Plow</option>
						<option data-icon="f7-icons icon-input-tilt-alarm" value="TILT">Tilt</option>
					  </select>
					</div>
					<div class="form-group col-xs-12 col-sm-4">
					  <label for="Input1MaskTime" class="control-label">Mask Time</label>
					  <select id="Input1MaskTime" name="Input1MaskTime" class="selectpicker form-control" title="- Select -" data-size="8">
						<option value="5" selected>5 seconds</option>
						<option value="10">10 seconds</option>
						<option value="30">30 seconds</option>
					  </select>
					</div>
					<div class="form-group col-xs-12 col-sm-4">
					  <label for="Input1Type" class="control-label">Type</label>
					  <select id="Input1Type" name="Input1Type" class="selectpicker form-control" title="- Select -" data-size="8">
						<option value="-Ve" selected>-Ve</option>
						<option value="+Ve">+Ve</option>
					  </select>
					</div>
				  </div>
				  <div class="row row-Input2" style="display: none;">
					<div class="col-xs-12">
					  <h4>Input2</h4>
					  <div class="form_divider"></div>
					</div>
					<div class="form-group col-xs-12 col-sm-4">
					  <label for="Input2" class="control-label">Input2 Name</label>
					  <select id="Input2" name="Input2" class="selectpicker form-control" title="- Select -" data-size="8">
						<option data-icon="f7-icons " value="Input2">None</option>
						<option data-icon="f7-icons icon-input-car-alarm" value="ACC2">ACC2</option>
						<option data-icon="f7-icons icon-input-car-alarm3" value="ALARM">Alarm</option>
						<option data-icon="f7-icons icon-input-bilge-alarm" value="BILGE">Bilge</option>
						<option data-icon="f7-icons icon-input-door-alarm" value="DOOR">Door</option>
						<option data-icon="f7-icons icon-input-pto-alarm" value="PTO">PTO</option>
						<option data-icon="f7-icons icon-input-shore-power" value="SHORE">Shore</option>
						<option data-icon="f7-icons icon-input-snow-plow" value="PLOW">Snow Plow</option>
						<option data-icon="f7-icons icon-input-tilt-alarm" value="TILT">Tilt</option>
					  </select>
					</div>
					<div class="form-group col-xs-12 col-sm-4">
					  <label for="Input2MaskTime" class="control-label">Mask Time</label>
					  <select id="Input2MaskTime" name="Input2MaskTime" class="selectpicker form-control" title="- Select -" data-size="8">
						<option value="5" selected>5 seconds</option>
						<option value="10">10 seconds</option>
						<option value="30">30 seconds</option>
					  </select>
					</div>
					<div class="form-group col-xs-12 col-sm-4">
					  <label for="Input2Type" class="control-label">Type</label>
					  <select id="Input2Type" name="Input2Type" class="selectpicker form-control" title="- Select -" data-size="8">
						<option value="-Ve" >-Ve</option>
						<option value="+Ve" selected>+Ve</option>
					  </select>
					</div>
				  </div>
				</div>
			  </div>
			</div>



			
			
		  
          <div class="form_divider"></div>
		  			<div class="row">
						<div class="form-group col-xs-12 col-sm-6">
              <label for="initialMileage" class="control-label">Initial Mileage <span class="help-info">(km)</span></label>
              <input type="tel" class="form-control only_numbers_and_negative clearAfter" id="initialMileage" name="initialMileage" placeholder="" maxlength="190">
            </div>
            <div class="form-group col-xs-12 col-sm-6">
              <label for="initialEngineHours" class="control-label">Initial Engine Hours <span class="help-info">(h)</span></label>
              <input type="tel" class="form-control only_numbers_and_negative clearAfter" id="initialEngineHours" name="initialEngineHours" placeholder="" maxlength="190">
            </div>

						<div class="form-group col-xs-12 ">
							<label for="notes" class="control-label">Notes</label>
							<textarea name="notes" id="notes" class="form-control clearAfter"  maxlength="190"></textarea>
						</div>
					</div>

					<p >Has the device been installed and the asset currently has power ?</p>
					<div class="row">
						<div class="form-group col-xs-12">
							<div class="radio animated flipInX">
						      	<label class="control-label padding-left-0">
						        	<input type="radio" name="isDeviceInstalled" value="no" checked>
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	<span>No</span>
						      	</label>
						    </div>
						    <div class="radio animated flipInX">
						    	<label class="control-label padding-left-0">
						        	<input type="radio" name="isDeviceInstalled" value="yes">
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	<span>Yes</span>
						      	</label>
						    </div>
						</div>
					</div>



          <p>Connected to Ignition ?</p>
          <div class="row">
            <div class="form-group col-xs-12">
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isConnectedToIgnition" value="no" >
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>No</span>
                </label>
              </div>
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isConnectedToIgnition" value="yes" checked>
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>Yes</span>
                </label>
              </div>
            </div>
          </div>
		  
					<div class="form_divider"></div>
                            
					<div class="row ">
						<div class="form-group col-xs-6 groupRenewal"  style="display: none;">
						    <div class="checkbox">
						      	<label class="control-label padding-left-0">
						        	<input type="checkbox" id="renewal" name="renewal" >
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	Renewal
						      	</label>
							     <div class="help-block with-errors"></div>
						    </div>
						</div>
						<div class="form-group col-xs-6 groupAutoSuspend" style="display: none;">
						    <div class="checkbox">
						      	<label class="control-label padding-left-0">
						        	<input type="checkbox" id="autosuspend" name="autosuspend" >
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	Auto Suspend
						      	</label>
							     <div class="help-block with-errors"></div>
						    </div>
						</div>
					</div>

				  	<!-- <div class="form-group">
				  	  	<label for="deviceType" class="control-label">Device Type:</label>
				  	  	<input type="text" class="form-control clearAfter" id="deviceType" name="deviceType" data-code="" placeholder="" readonly maxlength="100">
				  	</div> -->

				</div>
				<div class="form_section">
					<h2>Contact</h2>
					<div class="form_divider"></div>
					<div class="row">
						<div class="form-group col-xs-12">
					  	  	<label for="address1" class="control-label">Address<span class="color-red">*</span></label>
					  	  	<input type="text" class="form-control clearAfter" id="address1" name="address1" placeholder="" required maxlength="190">
					  	</div>
					</div>

					<div class="row">
						<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="address3" class="control-label">City<span class="color-red">*</span></label>
					  	  	<input type="text" class="form-control clearAfter" id="address3" name="address3" placeholder="" required maxlength="190">
					  	</div>
					  	<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="address4" class="control-label">State / Province / Region<span class="color-red">*</span></label>
					  	  	<input type="text" class="form-control clearAfter" id="address4" name="address4" placeholder="" required maxlength="190">
					  	</div>
					  	<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="address5" class="control-label">Zip / Postal Code<span class="color-red">*</span></label>
					  	  	<input type="text" class="form-control clearAfter" id="address5" name="address5" placeholder="" required maxlength="190">
					  	</div>
						<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="country" class="control-label">Country<span class="color-red">*</span></label>
					  	  	<select id="country" name="country" class="selectpicker form-control" data-live-search="true" title="- Select your country -" data-size="5" required>
						      	<?php include "country-list.php"; ?>
						    </select>
						    <!-- <div class="help-block with-errors"></div> -->
					  	</div>
					  	<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="timeZone" class="control-label">Time Zone<span class="color-red">*</span></label>
					  	  	<select id="timeZone" name="timeZone" class="selectpicker form-control" title="- Select your time zone -" data-size="5" data-live-search="true" required>
						      	<?php include "time-zone.php"; ?>
						    </select>
						    <!-- <div class="help-block with-errors"></div> -->
					  	</div>
					  	<div class="form-group col-xs-12 col-sm-6">
					  	  	<label for="language" class="control-label">Language<span class="color-red">*</span></label>
					  	  	<select id="language" name="language" class="selectpicker form-control" title="- Select your language -" data-size="5" required>
						      	<?php include "languages.php"; ?>
						    </select>
						    <!-- <div class="help-block with-errors"></div> -->
					  	</div>
					</div>

					<div class="row">
						<div class="form-group no-gutter col-xs-12">
							<label for="mobile" class="control-label phoneLabel">Mobile<span class="color-red">*</span></label>
						  	<input id="phoneCode" type="text" name="phoneCode" class="form-control phoneCode" maxlength="190" value="+61" readonly>
						  	<input type="tel" class="form-control clearAfter mobile only_numbers"  id="mobile" name="mobile" placeholder="" required maxlength="190">
							<!-- <label for="mobile" class="control-label">Mobile:</label>
							<input type="tel" class="form-control only_numbers" class="form-control" id="mobile" name="mobile" placeholder="" required maxlength="190"> -->
					  	</div>
					</div>


				</div>
				

				<div class="form_section">
					<h2 class="accordion-toggle collapsed" role="button" data-toggle="collapse" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">Emergency Contacts <span class="help-info">(Optional)</span></h2>
					<div class="form_divider"></div>
					<div id="collapseOne" class="panel-collapse collapse " >

						<div class="row">
							<div class="col-xs-12">
								<h4>Contact #1</h4>
								<div class="form_divider"></div>
							</div>
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="emcfirstname1" class="control-label">First Name</label>
						  	  	<input type="text" class="form-control clearAfter" id="emcfirstname1" name="emcfirstname1" placeholder="" maxlength="190">
						  	</div>
						  	<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="emclastname1" class="control-label">Last Name</label>
						  	  	<input type="text" class="form-control clearAfter" id="emclastname1" name="emclastname1" placeholder="" maxlength="190">
						  	</div>
						</div>
						<div class="row">
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="emcemail1" class="control-label">Email</label>
						  	  	<input type="email" class="form-control clearAfter" id="emcemail1" name="emcemail1" placeholder="" maxlength="190">
						  	</div>
						  	<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="emcphone1" class="control-label">Phone</label>
						  	  	<input type="tel" class="form-control clearAfter" id="emcphone1" name="emcphone1" placeholder="" maxlength="190">
						  	</div>
						</div>

						<div class="row">
							<div class="col-xs-12">
								<h4>Contact #2</h4>
								<div class="form_divider"></div>
							</div>
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="emcfirstname2" class="control-label">First Name</label>
						  	  	<input type="text" class="form-control clearAfter" id="emcfirstname2" name="emcfirstname2" placeholder="" maxlength="190">
						  	</div>
						  	<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="emclastname2" class="control-label">Last Name</label>
						  	  	<input type="text" class="form-control clearAfter" id="emclastname2" name="emclastname2" placeholder="" maxlength="190">
						  	</div>
						</div>
						<div class="row">
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="emcemail2" class="control-label">Email</label>
						  	  	<input type="email" class="form-control clearAfter" id="emcemail2" name="emcemail2" placeholder="" maxlength="190">
						  	</div>
						  	<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="emcphone2" class="control-label">Phone</label>
						  	  	<input type="tel" class="form-control clearAfter" id="emcphone2" name="emcphone2" placeholder="" maxlength="190">
						  	</div>
						</div>

					</div>
				</div>

				<div class="form_section form_section_payment ">

					<h2 class="animated flipInX">Payment Type</h2>
					<div class="form_divider"></div>
					<div class="row">
						<div class="form-group col-xs-12">
							<!-- <div class="radio animated flipInX">
											    					      	<label class="control-label">
											    					        	<input type="radio" name="paymentType" value="2" required>
											    					        	<span>Bank Direct Debit</span>
											    					      	</label>
											    					    </div>	 -->
						    <div class="radio animated flipInX other_payment_method display-none no-stripe is-invoice">
						    	<label class="control-label padding-left-0">
						        	<input type="radio" name="paymentType" value="3" required checked>
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	<span>By Invoice</span>
						      	</label>
						    </div>
							<div class="radio animated flipInX is-stripe no-invoice">
						      	<label class="control-label padding-left-0">
						        	<input type="radio" name="paymentType" value="12" required >
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	<span>Credit Card (Stripe API)</span>
						      	</label>
						  </div>
							<div class="radio animated flipInX is-stripe no-invoice">
						      	<label class="control-label padding-left-0">
						        	<input type="radio" name="paymentType" value="13" required >
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	<span>BECS Direct Debit (Stripe API)</span>
						      	</label>
						  </div>
							<div class="radio animated flipInX no-stripe  no-invoice" style="display:none">
						      	<label class="control-label padding-left-0">
						        	<input type="radio" name="paymentType" value="1" required >
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	<span>Credit Card</span>
						      	</label>
						    </div>
						    <div class="radio animated flipInX no-stripe no-invoice">
						    	<label class="control-label padding-left-0">
						        	<input type="radio" name="paymentType" value="4" required>
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	<span>Subscription Code</span>
						      	</label>
						    </div>
						    <!--<div class="radio animated flipInX">
						    	<label class="control-label padding-left-0">
						        	<input type="radio" name="paymentType" value="4" required>
						        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
						        	<span>Subscription Code</span>
						      	</label>
						    </div>-->
						</div>
					</div>
					<div class="col paymentFieldWrapper" id="mandate-acceptance">
										By providing your bank account details, you agree to this Direct Debit Request
										and the <a target="_blank" href="https://stripe.com/au/legal/becs-dd-service-agreement">Direct Debit Request service agreement</a>,
										and authorise Stripe Payments Australia Pty Ltd ACN 160 180 343
										Direct Debit User ID number 507156 (“Stripe”) to debit your account
										through the Bulk Electronic Clearing System (BECS) on behalf of
										Automotive Technology Group Australia (the "Merchant") for any amounts separately
										communicated to you by the Merchant. You certify that you are either
										an account holder or an authorised signatory on the account listed above.
									</div>


					<div class="paymentFieldWrapper creditCardStripeWrapper ">
					</div>
					
					
					<div class="paymentFieldWrapper creditCardWrapper ">
						<div class="row">
							<div class="form-group col-xs-12">
								<div class="radio animated flipInX">
							      	<label class="control-label padding-left-0">
							        	<input type="radio" name="ccType" value="Visa" >
							        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
							        	<span><img src="images/visa.png" alt=""></span>
							      	</label>
							    </div>
							    <div class="radio animated flipInX">
							    	<label class="control-label padding-left-0">
							        	<input type="radio" name="ccType" value="MasterCard" >
							        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
							        	<span><img src="images/mc.png" alt=""></span>
							      	</label>
							    </div>
							    <div class="radio animated flipInX">
							    	<label class="control-label padding-left-0">
							        	<input type="radio" name="ccType" value="Amex" >
							        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
							        	<span><img src="images/amex.png" alt=""></span>
							      	</label>
							    </div>
							</div>
						</div>

						<div class="row">
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="ccNumber" class="control-label animated flipInX ">Credit Card Number<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="ccNumber" name="ccNumber" placeholder=""  maxlength="190">
							</div>
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="ccCVV" class="control-label animated flipInX ">CVV<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="ccCVV" name="ccCVV" placeholder=""  maxlength="190">
							</div>
						</div>
						<div class="row">
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="ccExpiryDate" class="control-label animated flipInX ">Expiry Date<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="ccExpiryDate" name="ccExpiryDate" placeholder=""  maxlength="190">
							</div>
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="ccNameOnCard" class="control-label animated flipInX ">Name on Card<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="ccNameOnCard" name="ccNameOnCard" placeholder=""  maxlength="190">
							</div>
						</div>
					</div>
					<!--<div class="paymentFieldWrapper creditCardWrapper ">
						<div class="row">
							<div class="form-group col-xs-12">
								<div class="radio animated flipInX">
							      	<label class="control-label padding-left-0">
							        	<input type="radio" name="ccType" value="Visa" >
							        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
							        	<span><img src="images/visa.png" alt=""></span>
							      	</label>
							    </div>
							    <div class="radio animated flipInX">
							    	<label class="control-label padding-left-0">
							        	<input type="radio" name="ccType" value="MasterCard" >
							        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
							        	<span><img src="images/mc.png" alt=""></span>
							      	</label>
							    </div>
							    <div class="radio animated flipInX">
							    	<label class="control-label padding-left-0">
							        	<input type="radio" name="ccType" value="Amex" >
							        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
							        	<span><img src="images/amex.png" alt=""></span>
							      	</label>
							    </div>
							</div>
						</div>

						<div class="row">
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="ccNumber" class="control-label animated flipInX ">Credit Card Number<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="ccNumber" name="ccNumber" placeholder=""  maxlength="190">
							</div>
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="ccCVV" class="control-label animated flipInX ">CVV<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="ccCVV" name="ccCVV" placeholder=""  maxlength="190">
							</div>
						</div>
						<div class="row">
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="ccExpiryDate" class="control-label animated flipInX ">Expiry Date<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="ccExpiryDate" name="ccExpiryDate" placeholder=""  maxlength="190">
							</div>
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="ccNameOnCard" class="control-label animated flipInX ">Name on Card<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="ccNameOnCard" name="ccNameOnCard" placeholder=""  maxlength="190">
							</div>
						</div>
					</div>-->
					<!-- <div class="paymentFieldWrapper bankDirectWrapper ">
												<div class="form-group">
											  	  	<label for="bankAccountName" class="control-label animated flipInX ">Bank Account Name:</label>
											  	  	<input type="text" class="form-control clearAfter animated flipInX " id="bankAccountName" name="bankAccountName" placeholder=""  maxlength="190">
												</div>
												<div class="form-group">
											  	  	<label for="bankName" class="control-label animated flipInX ">Bank Name:</label>
											  	  	<input type="text" class="form-control clearAfter animated flipInX " id="bankName" name="bankName" placeholder=""  maxlength="190">
												</div>
												<div class="form-group">
											  	  	<label for="bankBSB" class="control-label animated flipInX ">BSB:</label>
											  	  	<input type="text" class="form-control clearAfter animated flipInX " id="bankBSB" name="bankBSB" placeholder=""  maxlength="190">
												</div>
												<div class="form-group">
											  	  	<label for="bankAccountNumber" class="control-label animated flipInX">Account Number:</label>
											  	  	<input type="text" class="form-control clearAfter animated flipInX " id="bankAccountNumber" name="bankAccountNumber" placeholder=""  maxlength="190">
												</div>
											</div>		 -->
					<div class="paymentFieldWrapper byInvoiceWrapper ">
						<div class="row">
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="invoiceName" class="control-label animated flipInX ">Invoice Name<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="invoiceName" name="invoiceName" placeholder=""  maxlength="190">
							</div>
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="invoiceNumber" class="control-label animated flipInX ">Invoice Number</label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="invoiceNumber" name="invoiceNumber" placeholder=""  maxlength="190">
							</div>
						</div>
						<div class="row">
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="invoiceRUT" class="control-label animated flipInX ">Tax ID</label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="invoiceRUT" name="invoiceRUT" placeholder=""  maxlength="190">
							</div>
							<div class="form-group col-xs-12 col-sm-6">
						  	  	<label for="invoiceEmail" class="control-label animated flipInX">Email Address for Invoice<span class="color-red">*</span></label>
						  	  	<input type="email" class="form-control clearAfter animated flipInX " id="invoiceEmail" name="invoiceEmail" data-error="That email address is invalid" placeholder=""  maxlength="190">
						  	  	<div class="help-block with-errors"></div>
							</div>
						</div>
					</div>

					<div class="paymentFieldWrapper byVoucherWrapper ">
						<div class="row">
							<div class="form-group col-xs-12 ">
						  	  	<label for="voucherCode" class="control-label animated flipInX ">Code<span class="color-red">*</span></label>
						  	  	<input type="text" class="form-control clearAfter animated flipInX " id="voucherCode" name="voucherCode" placeholder=""  maxlength="190">
							</div>
						</div>
					</div>
				</div>

				<div class="form_section  margin-bottom-40">
					<div class="form-group ">
						<div class="checkbox">
					      	<label class="control-label padding-left-0">
					        	<input type="checkbox" id="terms" name="terms" required>
					        	<span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                    I agree to be bound by the Terms and Conditions which can be found at <a target="_blank" href="https://www.quiktrak.com.au/online-purchasing-policy/">quiktrak.com.au</a>
					      	</label>

									
					    </div>
					</div>
				</div>

			  	<div class="form_section">
				  	<div class="form-group margin-0 ">
				  	  	<button type="submit" class="btn form_submit">
				  	  		<img class="preloader vis_hidden" src="images/loader.gif" alt="">
				  	  		<span class="submit_text">Submit</span>
				  	  	</button>
				  	  	<div class="help-block info"></div>
				  	</div>
				</div>

			</form>


		</div>
	</div>
<?php include "footer.php"; ?>

	<script src="js/jquery-1.12.0.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<script src="js/validator.min.js"></script>
	<script src="js/bootstrap-select.min.js"></script>
	<script src="js/materialPreloader.min.js"></script>
  <script src="https://js.stripe.com/v3/"></script>
  <script src="https://polyfill.io/v3/polyfill.min.js?version=3.52.1&features=fetch"></script>
	<script src="js/initialScript.js?v=<?php echo filemtime('js/initialScript.js'); ?>"></script>
	<!--<script src="js/register.js?v=<?php /*echo filemtime('js/register.js'); */?>"></script>-->
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.17/dist/sweetalert2.all.min.js"></script>
	<script src="js/client-activation.js?v=<?php echo filemtime('js/client-activation.js'); ?>"></script>

	<!-- mask input -->
	<script src="js/maskedinput.js"></script>




</body>
</html>
