//live cartack api key
let stripe = Stripe('pk_live_9ABjJfCGyYaDEJPJlswWW4tj');

//test cartack api key
//let stripe = Stripe('pk_test_mL1Sp5RBGwoa8Bx6Od8FmHBD');

let elements = stripe.elements();
let isFormLoading = false;
let USER_DATA = {};

$(function (){
  let card = elements.create('card');
  let form = document.getElementById("payment-form");

  card.mount('#card-element');

  card.on('change', function (event) {
    // Disable the Pay button if there are no card details in the Element
    document.querySelector("#submit").disabled = event.empty;
    document.querySelector("#card-error").textContent = event.error ? event.error.message : "";
  });

  form.addEventListener("submit", function(event) {
    event.preventDefault();
    let $this = $('[name="activation"]');
    let name = '';
    let email = $('[name="email"]').val();
    let imei = $('[name="imei"]').val();
    let account = $('[name="account"]').val();
    let priceId = $('[name="servicePlan"] option:selected').data('priceid');
    if($this.hasClass('form-register')){
      name = $('[name="firstName"]').val() + ' ' + $('[name="subName"]').val();
    }else if($this.hasClass('form-activate') || $this.hasClass('form-replace') || $this.hasClass('form-upgrade')){
      if(email) {
        name = email.split("@")[0];
      }else if(account){
        name = account.split("@")[0];
      }
    }

    // Complete payment when the submit button is clicked
    loading(true);
    stripe
      .createPaymentMethod({
        type: 'card',
        card: card,
        billing_details: {
          name: name,
        },
      })
      .then((result) => {
        if (result.error) {
          showError(result.error.message);
        } else {
          createSubscription({
            //customerId: customerId,
            paymentMethodId: result.paymentMethod.id,
            priceId: priceId,
            email: email,
            imei: imei
          });
        }
      });
  });
})


$('[name="activation"]').validator().on('submit', function (e) {
  $('.info').empty();

  if (e.isDefaultPrevented()) {
    // handle the invalid form...
    console.log('has error');
    return
  }
  // everything looks good!
  e.preventDefault();

  let verifyUrl = '';

  let $this = $(this);
  USER_DATA.domain = $('[name="domain"]').val();
  USER_DATA.projectTypeNumber = $('[name="projectNumber"]').val();
  USER_DATA.dealerToken = $('[name="dealerToken"]').val();
  USER_DATA.dealerName = $('[name="dealerName"]').val();
  USER_DATA.imei = $('[name="imei"]').val();
  USER_DATA.account = $('[name="account"]').val();
  USER_DATA.email = $('[name="email"]').val();

  USER_DATA.name = $('[name="name"]').val();
  USER_DATA.registration = $('[name="rego"]').val();
  USER_DATA.describe1 = $('[name="describe1"]').val();
  USER_DATA.describe2 = $('[name="describe2"]').val();
  USER_DATA.describe3 = $('[name="describe3"]').val();
  USER_DATA.describe4 = $('[name="describe4"]').val();
  USER_DATA.servicePlanCode = $('[name="servicePlan"]').val();
  USER_DATA.servicePlan = $('[name="servicePlan"] option:selected').text();
  USER_DATA.servicePlanType = $('[name="servicePlan"] option:selected').data('plantype');
  USER_DATA.solutionCode = $('[name="solution"]').val();
  USER_DATA.solution = $('[name="solution"] option:selected').text();
  USER_DATA.deviceType = $('[name="deviceType"]').val();

  USER_DATA.assetType = $('[name="assetType"]').val();
  USER_DATA.instalLocation = $('[name="instalLocation"]').val();
  USER_DATA.notes = $('[name="notes"]').val();
  USER_DATA.isDeviceInstalled = $('[name="isDeviceInstalled"]:checked').val();
  USER_DATA.initialMileage = $('[name="initialMileage"]').val();
  USER_DATA.initialEngineHours = $('[name="initialEngineHours"]').val();

  USER_DATA.paymentTypeCode = $('input[name="paymentType"]:checked').val();
  USER_DATA.paymentType = $('input[name="paymentType"]:checked').siblings('span').text();

  switch (USER_DATA.paymentTypeCode){
    case '1':
      USER_DATA.paymentType += ' (Stripe API)';
      USER_DATA.payment1 = $('[name="ccType"]:checked').val();
      USER_DATA.payment2 = $('[name="ccNumber"]').val();
      USER_DATA.payment3 = $('[name="ccExpiryDate"]').val();
      USER_DATA.payment4 = $('[name="ccNameOnCard"]').val();
      USER_DATA.payment5 = $('[name="ccCVV"]').val();

      //error_code = validateCreditCardNumber({'ccNum':USER_DATA.payment2});
      break;
    case '2':
      USER_DATA.payment1 = $('[name="bankAccountName"]').val();
      USER_DATA.payment2 = $('[name="bankName"]').val();
      USER_DATA.payment3 = $('[name="bankBSB"]').val();
      USER_DATA.payment4 = $('[name="bankAccountNumber"]').val();
      break;
    case '4':
      USER_DATA.paymentType = 'voucher';
      USER_DATA.payment1 = $('[name="voucherCode"]').val();
      break;
    default:
      USER_DATA.payment1 = $('[name="invoiceName"]').val();
      USER_DATA.payment2 = $('[name="invoiceNumber"]').val();
      USER_DATA.payment3 = $('[name="invoiceRUT"]').val();
      USER_DATA.payment4 = $('[name="invoiceEmail"]').val();
  }

  if ($('[name="autosuspend"]').prop('checked')) {
    USER_DATA.autosuspend = 1;
  }else{
    USER_DATA.autosuspend = 0;
  }

  USER_DATA.fitoptions = $('[name="fitoptions"]').val();
  if (USER_DATA.fitoptions && USER_DATA.fitoptions.length) {
    USER_DATA.fitoptions = USER_DATA.fitoptions.reduce((a, b) => parseInt(a) + parseInt(b), 0);
  }else{
    USER_DATA.fitoptions = 0;
  }

  if($this.hasClass('form-register')){
    verifyUrl = 'php/save_in_db_r_verify.php';

    USER_DATA.accountName = $('[name="accountName"]').val();
    USER_DATA.firstName = $('[name="firstName"]').val();
    USER_DATA.subName = $('[name="subName"]').val();
    USER_DATA.fullName = USER_DATA.firstName + ' ' + USER_DATA.subName;

    USER_DATA.countryCode = $('[name="country"]').val();
    USER_DATA.country = $('[name="country"] option:selected').text();
    USER_DATA.timeZone = $('[name="timeZone"]').val();
    USER_DATA.languageCode = $('[name="language"]').val();
    USER_DATA.language = $('[name="language"] option:selected').text();
    USER_DATA.address1 = $('[name="address1"]').val();
    /*USER_DATA.address2 = $('[name="address2"]').val();*/
    USER_DATA.address3 = $('[name="address3"]').val();
    USER_DATA.address4 = $('[name="address4"]').val();
    USER_DATA.address5 = $('[name="address5"]').val();
    //USER_DATA.password = $('[name="password"]').val();

    USER_DATA.emContact = {
      contact1: {
        firstName: $('[name="emcfirstname1"]').val(),
        lastName: $('[name="emclastname1"]').val(),
        email: $('[name="emcemail1"]').val(),
        phone: $('[name="emcphone1"]').val(),
      },
      contact2: {
        firstName: $('[name="emcfirstname2"]').val(),
        lastName: $('[name="emclastname2"]').val(),
        email: $('[name="emcemail2"]').val(),
        phone: $('[name="emcphone2"]').val(),
      },
    };

    var phoneCode = $('[name="phoneCode"]').val();
    var mobile = $('[name="mobile"]').val();
    if ('+61' == phoneCode){
      if (mobile[0] === 0){
        mobile = mobile.substring(1);
      }
    }
    USER_DATA.phoneCode = phoneCode;
    USER_DATA.mobile = mobile;


  }else if($this.hasClass('form-replace')){
    verifyUrl = 'php/save_in_db_replace_verify.php';
    USER_DATA.imeiOld = $('[name="imeiOld"]').val();

  }else if($this.hasClass('form-activate')){
    verifyUrl = 'php/save_in_db_a_verify.php';

  }else if($this.hasClass('form-upgrade')){
    verifyUrl = 'php/save_in_db_u2l_verify.php';

  }

  if(isFormLoading){
    return;
  }

  if(USER_DATA.paymentTypeCode === '1'){
    isFormLoading = true;
    $('.form_submit').toggleClass('disabled');
    $('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
    preloader.on();
    fetch(verifyUrl, {
      method: 'post',
      headers: {
        'Content-type': 'application/json',
      },
      body: JSON.stringify(USER_DATA),
    })
      .then((response) => {
        return response.json();
      })
      .then((result) => {
        isFormLoading = false;
        $('.form_submit').toggleClass('disabled');
        $('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
        preloader.off();

        switch (result.replyCode){
          case '9999': case '1005': case '1004': case '1002': case '1000':
            $('.info').html('<div class="errors">'+result.msg+'</div>');
            break;

          case '000':
            $('#modalStripePayment').modal({keyboard: false, show: true, backdrop: 'static'});

            break;
          default:
            $('.info').html('<div class="errors">Error, please try again later</div>');
        }
      }).catch((error) => {
      // An error has happened. Display the failure to the user here.
      // We utilize the HTML element we created.
      //showCardError(error);
      //console.log(error)
      //console.log(error.message)
      isFormLoading = false;
      $('.form_submit').toggleClass('disabled');
      $('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
      preloader.off();
      showError(error.message);
    })

  }else{
    finalizeActivation({ userData:USER_DATA })
  }



});




function createSubscription({ email, paymentMethodId, priceId, imei }) {
  return (
    fetch('php/stripe-create.php', {
      method: 'post',
      headers: {
        'Content-type': 'application/json',
      },
      body: JSON.stringify({
        //customerId: customerId,
        email: email,
        paymentMethodId: paymentMethodId,
        priceId: priceId,
        imei: imei,
      }),
    })
      .then((response) => {
        return response.json();
      })
      // If the card is declined, display an error to the user.
      .then((result) => {
        if (result.error) {
          // The card had an error when trying to attach it to a customer.
          //console.log(result)
          throw result;
        }
        return result;
      })
      // Normalize the result to contain the object returned by Stripe.
      // Add the additional details we need.
      .then((result) => {
        return {
          paymentMethodId: paymentMethodId,
          priceId: priceId,
          subscription: result,
        };
      })
      // Some payment methods require a customer to be on session
      // to complete the payment process. Check the status of the
      // payment intent to handle these actions.
      .then(handlePaymentThatRequiresCustomerAction)
      // If attaching this card to a Customer object succeeds,
      // but attempts to charge the customer fail, you
      // get a requires_payment_method error.
      .then(handleRequiresPaymentMethod)
      // No more actions required. Provision your service for the user.
      .then(onSubscriptionComplete)
      .then(saveSuccessPaymentDetails)
      .then(finalizeActivation)
      .catch((error) => {
        // An error has happened. Display the failure to the user here.
        // We utilize the HTML element we created.
        //showCardError(error);
        //console.log(error)
        //console.log(error.message)
        loading(false);
        let message = error.message ? error.message : error.error ? error.error : 'Error, try again with another card'
        showError(message);
      })
  );
}


function handlePaymentThatRequiresCustomerAction({
                                                   subscription,
                                                   invoice,
                                                   priceId,
                                                   paymentMethodId,
                                                   isRetry,
                                                 }) {
  if (subscription && subscription.status === 'active') {
    // Subscription is active, no customer actions required.
    return { subscription, priceId, paymentMethodId };
  }

  //console.log(subscription)
  // If it's a first payment attempt, the payment intent is on the subscription latest invoice.
  // If it's a retry, the payment intent will be on the invoice itself.
  let paymentIntent = invoice ? invoice.payment_intent : subscription.latest_invoice.payment_intent;
  //let paymentIntent = subscription.latest_invoice.payment_intent;

  if (
    paymentIntent.status === 'requires_action' ||
    (isRetry === true && paymentIntent.status === 'requires_payment_method')
  ) {
    return stripe
      .confirmCardPayment(paymentIntent.client_secret, {
        payment_method: paymentMethodId,
      })
      .then((result) => {
        if (result.error) {
          // Start code flow to handle updating the payment details.
          // Display error message in your UI.
          // The card was declined (i.e. insufficient funds, card has expired, etc).
          //console.log(result)
          //Promise.reject(result.error)
          throw result.error;
          //showError(result.error.message);
        } else {
          //console.log(result)
          if (result.paymentIntent.status === 'succeeded') {
            subscription.status = 'active';
            //subscription.latest_invoice.payment_intent = result.paymentIntent
            //console.log('here')
            // Show a success message to your customer.
            return {
              priceId: priceId,
              subscription: subscription,
              invoice: invoice,
              paymentMethodId: paymentMethodId,
            };
          }
        }
      })
      .catch((error) => {
        //displayError(error);
        //console.log(error)
        //showError(error.message);
        throw error;
      });
  } else {
    // No customer action needed.
    return { subscription, priceId, paymentMethodId };
  }
}

function handleRequiresPaymentMethod({
                                       subscription,
                                       paymentMethodId,
                                       priceId,
                                     }) {
  //console.log('here2')
  //console.log(subscription)
  if (subscription.status === 'active') {
    // subscription is active, no customer actions required.
    return { subscription, priceId, paymentMethodId };
  } else if (
    subscription.latest_invoice.payment_intent.status ===
    'requires_payment_method'
  ) {
    // Using localStorage to manage the state of the retry here,
    // feel free to replace with what you prefer.
    // Store the latest invoice ID and status.
    localStorage.setItem('latestInvoiceId', subscription.latest_invoice.id);
    localStorage.setItem(
      'latestInvoicePaymentIntentStatus',
      subscription.latest_invoice.payment_intent.status
    );
    throw { message: 'Your card was declined.' };
  } else {
    //console.log('here3')
    return { subscription, priceId, paymentMethodId };
  }
}


function onSubscriptionComplete(result) {
  // Payment was successful.
  if (result.subscription.status === 'active') {
    // Change your UI to show a success message to your customer.
    // Call your backend to grant access to your service based on
    // `result.subscription.items.data[0].price.product` the customer subscribed to.

    console.log('success')
    loading(false);
    $('#modalStripePayment').modal('hide');
    USER_DATA.stripePyment = {
      subscriptionId: result.subscription.id,
      currentPeriodEnd: result.subscription.current_period_end,
      customer: result.subscription.customer,
      priceItemId: result.subscription.items.data[0].price.id,
    }
    if(result.subscription.latest_invoice && result.subscription.latest_invoice.hosted_invoice_url){
      window.open(result.subscription.latest_invoice.hosted_invoice_url,'_blank');
    }
    return USER_DATA
  }
}

function saveSuccessPaymentDetails(userData){
  return (
    fetch('php/save_success_payment.php', {
      method: 'post',
      headers: {
        'Content-type': 'application/json',
      },
      body: JSON.stringify(userData),
    })
      .then((response) => {
        return response.json();
      })
      .then((result) => {
        userData.stripePyment.savedStripeDetailsId = result.id
        return userData
      })
      .catch((error) => {
        console.log(error)
        throw error;
      })
  )
}

function finalizeActivation(userData){
  /*console.log(userData)
  console.log('SUCCESS, finalizing activation')
  var letter = `letter/witi/live/?ac=${ userData.account }&at=${ userData.assetType }&st=${ userData.solution }&sp=${ userData.servicePlan }`;
  if (letter) {
    window.open(letter,'_blank');
  }
  return ;*/

  let $this = $('[name="activation"]');
  let activateUrl = 'php/save_in_db_r.php';

  if($this.hasClass('form-activate')){
    activateUrl = 'php/save_in_db_a.php';
  }else if($this.hasClass('form-replace')){
    activateUrl = 'php/save_in_db_replace.php';
  }else if($this.hasClass('form-upgrade')){
    activateUrl = 'php/save_in_db_u2l.php';
  }

  $.ajax({
    type: "POST",
    url: activateUrl,
    dataType: 'json',
    data: userData,
    async: true,
    cache: false,
    beforeSend: function(){
      isFormLoading = true;
      $('.form_submit').toggleClass('disabled');
      $('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
      preloader.on();
    },
    success: function(data){
      isFormLoading = false;
      $('.form_submit').toggleClass('disabled');
      $('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
      preloader.off();

      console.log(data);
      var replyCode = data.replyCode;
      var respondMsg = data.msg;


      switch (replyCode){
        case '9999': case '1005': case '1004': case '1002': case '1000':
          $('.info').html('<div class="errors">'+respondMsg+'</div>');
          break;

        case '000':
          $('.clearAfter').val('');
          /*$('.device_count').empty();*/
          $('.info').html('<div class="success">'+respondMsg+'</div>');

          var letter = data.letter;
          if (letter) {
            window.open(letter,'_blank');

            /*var letterFrame = '<iframe src="'+letter+'" onload="resizeIframe(this)" style="width: 100%;"></iframe>';
            $('#modalLetter').modal('show');
            $('#modalLetter .modal-content').html(letterFrame);*/
          }
          break;
        default:
          $('.info').html('<div class="errors">Error, please try again later</div>');
      }

    },
    error: function(XMLHttpRequest, textStatus, errorThrown){
      console.log(XMLHttpRequest);
      console.log(textStatus);
      console.log(errorThrown);
      $('.form_submit').toggleClass('disabled');
      $('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
      $('.info').html('<div class="errors">Error, please try again later</div>');
      isFormLoading = false;
      preloader.off();
    }
  });
}

// Show the customer the error from Stripe if their card fails to charge
var showError = function(errorMsgText) {
  loading(false);
  var errorMsg = document.querySelector("#card-error");
  errorMsg.textContent = errorMsgText;
  setTimeout(function() {
    errorMsg.textContent = "";
  }, 5000);
};
// Show a spinner on payment submission
var loading = function(isLoading) {
  if (isLoading) {
    // Disable the button and show a spinner
    document.querySelector("#submit").disabled = true;
    document.querySelector("#spinner").classList.remove("hidden");
    document.querySelector("#button-text").classList.add("hidden");
  } else {
    document.querySelector("#submit").disabled = false;
    document.querySelector("#spinner").classList.add("hidden");
    document.querySelector("#button-text").classList.remove("hidden");
  }
};