<?php
if (is_file(realpath('../../system/stripe-php/init.php'))) {
  require_once(realpath('../../system/stripe-php/init.php'));
}

//live cartack api key
$stripe = new \Stripe\StripeClient('sk_live_V3ajZAOApWU5pcWZLelB65WE');

//test cartack api key
//$stripe = new \Stripe\StripeClient('sk_test_jA9KYwvTXiUIMMsk7hvMlfuh');


header('Content-Type: application/json');

try {
  // retrieve JSON from POST body
  $json_str = file_get_contents('php://input');
  $json_obj = json_decode($json_str);
  // Alternatively, set up a webhook to listen for the payment_intent.succeeded event
  // and attach the PaymentMethod to a new Customer
  $customers = $stripe->customers->all(['email'=>$json_obj->email,
    'limit' => 15,
  ]);

  if(empty($customers->data)){
    $customerId = createNewStripUser([
      'email' => $json_obj->email,
      'firstName' => $json_obj->firstName,
      'lastName' => $json_obj->subName,
      'imei' => $json_obj->imei,
    ]);
  }else{
    $customerId = $customers->data[0]->id;
  }

  try {
    $payment_method = $stripe->paymentMethods->retrieve(
      $json_obj->paymentMethodId
    );
    $payment_method->attach([
      'customer' => $customerId,
    ]);
  }catch(\Stripe\Exception\CardException $e) {
    // Since it's a decline, \Stripe\Exception\CardException will be caught
    /*echo 'Status is:' . $e->getHttpStatus() . '\n';
    echo 'Type is:' . $e->getError()->type . '\n';
    echo 'Code is:' . $e->getError()->code . '\n';
    // param is '' in this case
    echo 'Param is:' . $e->getError()->param . '\n';
    echo 'Message is:' . $e->getError()->message . '\n';*/
    echo json_encode(['error' => $e->getError()->message]);
    exit;
  } catch (Error $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
  }

  // Set the default payment method on the customer
  $stripe->customers->update($customerId, [
    'invoice_settings' => [
      'default_payment_method' => $json_obj->paymentMethodId
    ]
  ]);

  // Create the subscription
  $subscription = $stripe->subscriptions->create([
    'customer' => $customerId,
    'items' => [
      [
        'price' => $json_obj->priceId,
        'metadata' => ['imei' => $json_obj->imei]
      ],
    ],
    'expand' => ['latest_invoice.payment_intent'],
    'metadata' => ['imei' => $json_obj->imei]
  ]);

  $output = $subscription;
  echo json_encode($output);
} catch (Error $e) {
  echo json_encode(['test' => 'test']);
  http_response_code(500);
  echo json_encode(['error' => $e->getMessage()]);

}



function getTotalOrderAmount(array $items) {
  global $stripe;
  $currency = 'aud';
  $amount = 0;
  foreach ($items as $key => $value){
    $stripeItemPrice = $stripe->prices->retrieve(
      $value->priceId,
      []
    );
    $currency = $stripeItemPrice->currency;
    $amount .= $stripeItemPrice->unit_amount;
  }
  return ['amount' => $amount, 'currency' => $currency];
}

function createNewStripUser($data){
  global $stripe;
  $response = $stripe->customers->create([
    'email' => $data['email'],
    'name' => $data['firstName'] . " " . $data['lastName'],
    'description' => "First IMEI " . $data['imei'],
  ]);
  return $response->id;
}