<!DOCTYPE html>
<html lang="en">
<head>

	<meta charset="UTF-8">
	<!-- <meta name="viewport" content="width=device-width"> -->
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!--<link rel="shortcut icon" href="../images/favicon-live.png" type="image/x-icon">-->
	<link rel="stylesheet" type="text/css" href="../css/normalize.css" />
	<link rel="stylesheet" type="text/css" href="../css/bootstrap.css" />
	<link rel="stylesheet" type="text/css" href="../css/bootstrap-theme.css" />
	<link rel="stylesheet" type="text/css" href="../css/bootstrap-select.min.css" />
	<link rel="stylesheet" type="text/css" href="../css/materialPreloader.min.css" />
	<link rel="stylesheet" type="text/css" href="../css/animate.css" />
	<link rel="stylesheet" type="text/css" href="../css/checkbox-radio.css" />
	<link rel="stylesheet" type="text/css" href="../css/fonts.css" />
	<link rel="stylesheet" type="text/css" href="../fonts/fontastic/styles.css?v=<?php echo filemtime('fonts/fontastic/styles.css'); ?>" />
	<link rel="stylesheet" type="text/css" href="../css/style.css?v=<?php echo filemtime('css/style.css'); ?>" />
	<link rel="stylesheet" type="text/css" href="css/stripe.css" />

	<title>Activation - Upgrade to Live</title>
</head>
<body class="bg_body">

	<div class="container page page_activate">
		<div class="col-xs-12 animated flipInX deivceInstalledTopWarning" style="display: none;">
			<div class="alert alert-warning max-width-940 mx-auto">
				<strong>Warning!</strong> The systems requires a series of commands to configure the unit and your account, please ensure the system is installed and has power within 3 days of activation.
			</div>
		</div>
		<div class="col-xs-12 form">
      <div class="header">
        <!--<a href="https://al3rt.gps-secure.co/"><img src="../images/logo.png" alt=""></a>-->
      </div>
			<div class="form_header">
				<h3>Upgrade to Live Activation</h3>
				<span class="help-info">(* - fields are required)</span>
				<div class="form_header_divider"></div>
			</div>



			<form id="form-upgrade" name="activation" data-toggle="validator" role="form" class="form-upgrade" >
				<input type="hidden" name="projectNumber" id="projectNumber" value="33">
				<input type="hidden" name="dealerToken" id="dealerToken" value="">
				<input type="hidden" name="domain" id="domain" value="al3rt.gps-secure.co">
				<input type="hidden" name="deviceType" id="deviceType" value="">
				<input type="hidden" name="assetType" id="assetType" value="Bike">
				<input type="hidden" name="reportSubject" id="reportSubject" value="Upgrade to Live Asset Activation">
                <input type="hidden" name="dealerName" id="dealerName" value="">

                <input type="hidden" name="describe1" id="describe1" value="">
                <input type="hidden" name="describe2" id="describe2" value="">
                <input type="hidden" name="describe3" id="describe3" value="">
                <input type="hidden" name="describe4" id="describe4" value="">
                <input type="hidden" name="instalLocation" id="instalLocation" value="">
                <input type="hidden" name="initialMileage" id="initialMileage" value="">
                <input type="hidden" name="initialEngineHours" id="initialEngineHours" value="">


        <div class="form_section">
          <div class="row">
            <div class="form-group col-xs-12 ">
              <label for="account" class="control-label">Login Name / Email<span class="color-red">*</span></label>
              <input type="text" class="form-control clearAfter" id="account" name="account" placeholder="" maxlength="100" required >
            </div>
          </div>
          <div class="row">
            <div class="form-group col-xs-12">
              <label for="imei" class="control-label">IMEI <span class="help-info">(recorded on device)<span class="color-red">*</span></span></label>
              <input type="text" class="form-control clearAfter" id="imei" name="imei" value="" maxlength="16" required>
              <!-- <h1>Remove the 0 at the start of the IMEI number and enter the remaining 15 digits</h1> -->
            </div>
          </div>
          <div class="row">
            <div class="form-group col-xs-12 col-sm-6">
              <label for="name" class="control-label">Name<span class="color-red">*</span></label>
              <input type="text" class="form-control clearAfter" id="name" name="name" placeholder="" required maxlength="200">
            </div>
            <div class="form-group col-xs-12 col-sm-6">
              <label for="rego" class="control-label">Registration<span class="color-red">*</span></label>
              <input type="text" class="form-control clearAfter" id="rego" name="rego" placeholder="" required maxlength="200">
            </div>
          </div>
          <div class="row">
            <div class="form-group  col-xs-12 col-sm-6">
              <label for="solution" class="control-label">Solution Type <span class="color-red">*</span></label>
              <select id="solution" name="solution" class="selectpicker form-control" title="- Select Solution Type -" data-size="8" disabled required>

              </select>
            </div>
            <div class="form-group  col-xs-12 col-sm-6">
              <label for="servicePlan" class="control-label">Service Plan<span class="color-red">*</span></label>
              <select id="servicePlan" name="servicePlan" class="selectpicker form-control" title="- Select Service Plan -" data-size="8" disabled required>
              </select>
            </div>
          </div>

          <p >Has the device been installed and the asset currently has power ?</p>
          <div class="row">
            <div class="form-group col-xs-12">
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isDeviceInstalled" value="no" checked>
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>No</span>
                </label>
              </div>
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isDeviceInstalled" value="yes">
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>Yes</span>
                </label>
              </div>
            </div>
          </div>
          <div class="form_divider"></div>
        </div>

        <div class="row groupAutoSuspend" >
          <div class="form-group col-xs-12 ">
            <div class="checkbox">
              <label class="control-label padding-left-0">
                <input type="checkbox" id="autosuspend" name="autosuspend" >
                <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                Auto Suspend
              </label>
              <div class="help-block with-errors"></div>
            </div>
          </div>
        </div>

        <div class="form_section form_section_payment ">

          <h2 class="animated flipInX">Payment Type</h2>
          <div class="form_divider"></div>
          <div class="row">
            <div class="form-group col-xs-12">
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="paymentType" value="1" required>
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>Credit Card</span>
                </label>
              </div>
              <!--<div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="paymentType" value="3" required>
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>By Invoice</span>
                </label>
              </div>
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="paymentType" value="4" required>
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>Subscription Code</span>
                </label>
              </div>
            </div>-->
          </div>

          <!--<div class="paymentFieldWrapper creditCardWrapper ">
            <div class="row">
              <div class="form-group col-xs-12">
                <div class="radio animated flipInX">
                  <label class="control-label padding-left-0">
                    <input type="radio" name="ccType" value="Visa" >
                    <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                    <span><img src="images/visa.png" alt=""></span>
                  </label>
                </div>
                <div class="radio animated flipInX">
                  <label class="control-label padding-left-0">
                    <input type="radio" name="ccType" value="MasterCard" >
                    <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                    <span><img src="images/mc.png" alt=""></span>
                  </label>
                </div>
                <div class="radio animated flipInX">
                  <label class="control-label padding-left-0">
                    <input type="radio" name="ccType" value="Amex" >
                    <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                    <span><img src="images/amex.png" alt=""></span>
                  </label>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="form-group col-xs-12 col-sm-6">
                <label for="ccNumber" class="control-label animated flipInX ">Credit Card Number<span class="color-red">*</span></label>
                <input type="text" class="form-control clearAfter animated flipInX " id="ccNumber" name="ccNumber" placeholder=""  maxlength="200">
              </div>
              <div class="form-group col-xs-12 col-sm-6">
                <label for="ccCVV" class="control-label animated flipInX ">CVV<span class="color-red">*</span></label>
                <input type="text" class="form-control clearAfter animated flipInX " id="ccCVV" name="ccCVV" placeholder=""  maxlength="200">
              </div>
            </div>
            <div class="row">
              <div class="form-group col-xs-12 col-sm-6">
                <label for="ccExpiryDate" class="control-label animated flipInX ">Expiry Date<span class="color-red">*</span></label>
                <input type="text" class="form-control clearAfter animated flipInX " id="ccExpiryDate" name="ccExpiryDate" placeholder=""  maxlength="200">
              </div>
              <div class="form-group col-xs-12 col-sm-6">
                <label for="ccNameOnCard" class="control-label animated flipInX ">Name on Card<span class="color-red">*</span></label>
                <input type="text" class="form-control clearAfter animated flipInX " id="ccNameOnCard" name="ccNameOnCard" placeholder=""  maxlength="200">
              </div>
            </div>

          </div>-->

          <!--<div class="paymentFieldWrapper byInvoiceWrapper ">
            <div class="row">
              <div class="form-group col-xs-12 col-sm-6">
                <label for="invoiceName" class="control-label animated flipInX ">Invoice Name<span class="color-red">*</span></label>
                <input type="text" class="form-control clearAfter animated flipInX " id="invoiceName" name="invoiceName" placeholder=""  maxlength="200">
              </div>
              <div class="form-group col-xs-12 col-sm-6">
                <label for="invoiceNumber" class="control-label animated flipInX ">Invoice Number</label>
                <input type="text" class="form-control clearAfter animated flipInX " id="invoiceNumber" name="invoiceNumber" placeholder=""  maxlength="200">
              </div>
            </div>
            <div class="row">
              <div class="form-group col-xs-12 col-sm-6">
                <label for="invoiceRUT" class="control-label animated flipInX ">Tax ID</label>
                <input type="text" class="form-control clearAfter animated flipInX " id="invoiceRUT" name="invoiceRUT" placeholder=""  maxlength="200">
              </div>
              <div class="form-group col-xs-12 col-sm-6">
                <label for="invoiceEmail" class="control-label animated flipInX">Email Address for Invoice<span class="color-red">*</span></label>
                <input type="email" class="form-control clearAfter animated flipInX " id="invoiceEmail" name="invoiceEmail" data-error="That email address is invalid" placeholder=""  maxlength="200">
                <div class="help-block with-errors"></div>
              </div>
            </div>
          </div>-->

          <!--<div class="paymentFieldWrapper byVoucherWrapper ">
            <div class="row">
              <div class="form-group col-xs-12 ">
                <label for="voucherCode" class="control-label animated flipInX ">Code<span class="color-red">*</span></label>
                <input type="text" class="form-control clearAfter animated flipInX " id="voucherCode" name="voucherCode" placeholder=""  maxlength="200">
              </div>
            </div>
          </div>-->

        </div>
        <div class="form_section">
          <div class="form-group margin-0 ">
            <button type="submit" class="btn form_submit">
              <img class="preloader vis_hidden" src="images/loader.gif" alt="">
              <span class="submit_text">Submit</span>
            </button>
            <div class="help-block info"></div>
          </div>
        </div>
			</form>

			</div>

		</div>

<?php include "../footer.php"; ?>

	<script src="../js/jquery-1.12.0.min.js"></script>
	<script src="../js/bootstrap.min.js"></script>
	<script src="../js/validator.min.js"></script>
	<script src="../js/bootstrap-select.min.js"></script>
	<script src="../js/materialPreloader.min.js"></script>

	<script src="https://js.stripe.com/v3/"></script>
	<script src="https://polyfill.io/v3/polyfill.min.js?version=3.52.1&features=fetch"></script>
	<script src="js/initialScript.js?v=<?php echo filemtime('js/initialScript.js'); ?>"></script>
	<script src="js/client-activation.js?v=<?php echo filemtime('js/client-activation.js'); ?>"></script>
	<!--<script src="../js/upgrade-to-live.js?v=<?php /*echo filemtime('js/upgrade-to-live.js'); */?>"></script>-->


	<!-- mask input -->
	<script src="../js/maskedinput.js"></script>


	<script>
		var imeis = GetURLParameter('imeis');
		if (imeis) {
			$('#imei').val(imeis);
			getDefaultParams(imeis,DealerTokenUrl);
		}



		if (DealerTokenUrl && imeis) {
			getUserDetails({
				imeis: imeis,
				majortoken: DealerTokenUrl,
			});

		}else{
			alert('Dealer token is missing');
			$('.info').html('<div class="errors">Dealer token is missing</div>');
		}

		/*$('#imei').on('blur', function(){
			$(this).val( $(this).val().padStart(16,0) );
		});*/

		function getUserDetails(params){
			$.ajax({
				type: "GET",
				url: "https://api.m2mglobaltech.com/Common/v1/Activation/GetAssetsInfo",
				dataType: 'json',
				data: params,
				async: true,
				cache: false,
				beforeSend: function(){
					wait_save_data = 0;
					$('.form_submit').toggleClass('disabled');
					$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
				},
				success: function(result){
					wait_save_data = 1;
					$('.form_submit').toggleClass('disabled');
					$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
					console.log(result);
					var MajorCode = result.MajorCode;
					if (MajorCode == '000') {
						if (result.Data) {
							setUserDetails(result.Data);
						}
					}else{
						$('.info').html('<div class="errors">This IMEI '+params.imeis+' not belong to Dealer Account '+$(dealerName).val()+'</div>');
					}
				},
				error: function(XMLHttpRequest, textStatus, errorThrown){
					console.log(XMLHttpRequest);
					console.log(textStatus);
					console.log(errorThrown);
					wait_save_data = 1;
					$('.form_submit').toggleClass('disabled');
					$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
				}
			});
		}

		function setUserDetails(params) {
			if (params && typeof(params) == 'object' && params.Assets && typeof(params.Assets) == 'object' && params.Assets[0] && typeof(params.Assets[0]) == 'object') {
				if (params.Name){
					$('#dealerName').val(params.Name);
					$('#invoiceName').val(params.Name);
				}
				if (params.Email) {
					$('#invoiceEmail').val(params.Email);
				}
				if (params.Assets[0].LoginName) {
					$('#account').val(params.Assets[0].LoginName);
				}
				if (params.Assets[0].Name) {
					$('#name').val(params.Assets[0].Name);
				}
				if (params.Assets[0].Make) {
					$('#describe1').val(params.Assets[0].Make);
				}
				if (params.Assets[0].Model) {
					$('#describe2').val(params.Assets[0].Model);
				}
				if (params.Assets[0].Color) {
					$('#describe3').val(params.Assets[0].Color);
				}
				if (params.Assets[0].Year) {
					$('#describe4').val(params.Assets[0].Year);
				}

				if (params.Assets[0].AssetType) {
					$('.asset-type-icon-wrapper[data-type="'+params.Assets[0].AssetType+'"]').click();
				}

				if (params.Assets[0].Solution) {
					/*setTimeout(function(){ $('#solution').selectpicker('val', params.Assets[0].Solution); }, 500);

					if (params.Assets[0].Solution == 'Protect' || params.Assets[0].Solution == 'Loc8') {
						$('input[name="paymentType"]').attr('required',false);
						$('.form_section_payment').hide();
					}else{
						$('input[name="paymentType"]').attr('required',true);
						$('.form_section_payment').show();
					}		*/
				}else{
					$('.form_section_payment').hide();
				}
			}
		}

	</script>
</body>
</html>