<!DOCTYPE html>
<html lang="en">
<head>

	<meta charset="UTF-8">
	<!-- <meta name="viewport" content="width=device-width"> -->
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<link rel="shortcut icon" href="images/favicon-live.png" type="image/x-icon">
	<link rel="stylesheet" type="text/css" href="css/normalize.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap-theme.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap-select.min.css" />
	<link rel="stylesheet" type="text/css" href="css/materialPreloader.min.css" />
	<link rel="stylesheet" type="text/css" href="css/animate.css" />
	<link rel="stylesheet" type="text/css" href="css/fonts.css" />
	<link rel="stylesheet" type="text/css" href="css/style.css?v=<?php echo filemtime('css/style.css'); ?>" />

	<title>Activation</title>
</head>
<body class="bg_body">
<?php include "header.php"; ?>
	<div class="container page page_activate">
		<div class="col-xs-12 form">
      <div class="col-xs-12 header">
        <a href="https://western.gps-secure.co/"><img src="images/logo.png" alt=""></a>
      </div>
			<div class="form_header">
				<h3>Activation</h3>
				<!-- <span class="help-info">(all fields are required)</span> -->
				<div class="form_header_divider"></div>
			</div>

			<form data-toggle="validator" role="form" class="form-index" id="form-index">
				<div class="form_section">
					<p>Please, enter client Email address or Login Name.</p>
					<p>For new customers, please select New Customer tab below.</p>
				</div>
				<div class="form_section">
					<div class="form-group">
					  	<label for="account" class="control-label">Email / Login Name:</label>
					  	<input type="text" class="form-control clearAfter" id="account" name="account" placeholder="" maxlength="200" required >
					</div>
					<!-- <div class="form-group">
					  	<label for="imei" class="control-label">IMEI:</label>
					  	<input type="text" class="form-control clearAfter" id="imei" name="imei" placeholder="" maxlength="200" required value="<?= $_GET["imei"] ?>">
					</div> -->
				</div>

				<div class="form_section">
				  	<div class="form-group margin-0 ">
				  	  	<button type="submit" class="btn from-button form_submit">
				  	  		<img class="preloader vis_hidden" src="images/loader.gif" alt="">
				  	  		<span class="submit_text">Submit</span>
				  	  	</button>
				  	  	<a href='register.php?imei=<?= $_GET["imei"] ?>&ServiceProfile=<?= $_GET["ServiceProfile"] ?>&SolutionType=<?= $_GET["SolutionType"] ?>&DealerToken=<?= $_GET["DealerToken"] ?>&DealerName=<?= $_GET["DealerName"] ?>' class="btn from-button btn-dark ">New Customer</a>
				  	  	<div class="help-block info"></div>
				  	</div>
				</div>

			</form>

		</div>
	</div>
<?php include "footer.php"; ?>

	<!-- <script src="js/jquery-1.12.0.min.js"></script> -->
	<script src="js/jquery-3.3.1.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<script src="js/validator.min.js"></script>
	<script src="js/bootstrap-select.min.js"></script>
	<script src="js/materialPreloader.min.js"></script>


<script>
	var preloader = new $.materialPreloader({
        position: 'top',
        height: '5px',
        col_1: '#159756',
        col_2: '#da4733',
        col_3: '#3b78e7',
        col_4: '#fdba2c',
        fadeIn: 300,
        fadeOut: 300
    });
	var wait_save_data = 1;
	$('.form-index').validator().on('submit', function (e) {
		$('.info').empty();
		if (e.isDefaultPrevented()) {
		    	// handle the invalid form...
		    	console.log('has error');
		} else {
		   	// everything looks good!
		  	e.preventDefault();
		  	var data = {
		  		//Email: $('[name="account"]').val(),
		  		//IMEI: $('[name="imei"]').val(),
		  	};

		  	var input = $('[name="account"]').val();

		  	if (input.indexOf('@') != -1) {
		  		data.Email = input;
		  	}else{
		  		data.LoginName = input;
		  	}


			if (wait_save_data == 1) {
				$.ajax({
					type: "POST",
					url: "https://newapi.quiktrak.co/Common/V1/Activation/GetEmail",
					dataType: 'json',
					data: data,
					async: true,
					cache: false,
					beforeSend: function(){
						wait_save_data = 0;
						$('.form_submit').toggleClass('disabled');
						$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
						preloader.on();
					},
					success: function(result){
						wait_save_data = 1;
						$('.form_submit').toggleClass('disabled');
						$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
						preloader.off();

						console.log(result);

						if (result && result.MajorCode == '000' && result.Data && result.Data.Result && result.Data.Result.toLowerCase() == 'ok') {
							location.href = 'activate.php?imei=<?= $_GET["imei"] ?>&ServiceProfile=<?= $_GET["ServiceProfile"] ?>&SolutionType=<?= $_GET["SolutionType"] ?>&DealerToken=<?= $_GET["DealerToken"] ?>&DealerName=<?= $_GET["DealerName"] ?>&email='+result.Data.Email+'&LoginName='+result.Data.LoginName+'&Phone='+result.Data.MobilePhone+'&CountryCode='+result.Data.CountryCode;
						}else{
							$('.info').html('<div class="errors">This Email / Login Name not registered in our system.</div>');
						}

					},
					error: function(XMLHttpRequest, textStatus, errorThrown){
						console.log(XMLHttpRequest);
						console.log(textStatus);
						console.log(errorThrown);
						$('.form_submit').toggleClass('disabled');
						$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
						$('.info').html('<div class="errors">Error, please try again later</div>');
						wait_save_data = 1;
						preloader.off();
					}
				});
			}
		}

	});
</script>


</body>
</html>
