preloader = new $.materialPreloader({
  position: 'top',
  height: '5px',
  col_1: '#159756',
  col_2: '#da4733',
  col_3: '#3b78e7',
  col_4: '#fdba2c',
  fadeIn: 300,
  fadeOut: 300
});
preloader.on();

var FITMENTOPTIONS = {
RemoteImmob: '1',
AlarmIntegration: '2',
SOSButton: '4',
NotConnectedIgn: '8',
FitmentAfterIsolater: '16',
EngineTheft: '32',
Siren: '64',
BilgeAlarm: '128',
ShorePowerDisconn: '256',
RemoteDoor: '512'
}

var imeiUrl = GetURLParameter('imei');
if(imeiUrl.startsWith('868')){
	imeiUrl = '000' + imeiUrl.slice(3);
}
var ServiceProfileUrl = GetURLParameter('ServiceProfile');
var DealerTokenUrl = GetURLParameter('DealerToken');
var DealerNameUrl = GetURLParameter('DealerName');
var projectNumberUrl = GetURLParameter('pn');

var emailUrl = GetURLParameter('email');
var loginUrl = GetURLParameter('LoginName');
var countryCodeUrl = GetURLParameter('CountryCode');
var phoneUrl = GetURLParameter('Phone');
var fromAppFlagUrl = GetURLParameter('FromApp');
//console.log(fromAppFlagUrl)

if (ServiceProfileUrl) {

if (ServiceProfileUrl == '0000000000000') {
$('input[name="paymentType"]').attr('required',false);
$('.form_section_payment').hide();
}
}else{
$('.form_section_payment').hide();
}

if (DealerTokenUrl) {
$('#dealerToken').val(DealerTokenUrl);
if (ServiceProfileUrl && ServiceProfileUrl != '0000000000000' && ServiceProfileUrl != 'QUIKLOC800000' && !fromAppFlagUrl) {
$('.groupAutoSuspend').show();
}else{
$('.groupAutoSuspend').hide();
}
}else{
$('.groupAutoSuspend').hide();
}
if (imeiUrl) {
$('#imei').val(imeiUrl);
}

if (DealerNameUrl) {
$('#dealerName').val(decodeURIComponent(DealerNameUrl));
$('#invoiceName').val(decodeURIComponent(DealerNameUrl));
}

if (projectNumberUrl){
$('#projectNumber').val(parseInt(projectNumberUrl));
}
if (emailUrl) {
$('#account').val(decodeURIComponent(emailUrl));
$('#email').val(decodeURIComponent(emailUrl));
}
if(fromAppFlagUrl){
$('.purchased_from_section').hide();
$('.other_payment_method').hide();
}

$(function(){

$('[data-toggle="tooltip"]').tooltip();

/* mask input START */
$('#ccExpiryDate').mask("99/99");
$('input[name="ccNumber"]').mask("9999 9999 9999 9999");
$("#ccCVV").mask("999");
$("#voucherCode").mask("********-****-****-****-************");
//cb3ed0c4-ea04-4cb9-b9db-2e3993706b81

$('input[name="ccType"]').on('change', function(){
var val = $(this).val();
if (val == 'Amex') {
  $('input[name="ccNumber"]').mask("9999 9999 9999 999");
  $("#ccCVV").mask("9999");
}else{
  $('input[name="ccNumber"]').mask("9999 9999 9999 9999");
  $("#ccCVV").mask("999");
}
});

//getAdditionalData();
preloader.off();

if (imeiUrl) {
getDefaultParams(imeiUrl,DealerTokenUrl);
}

if (emailUrl) {
$('#email').val(decodeURIComponent(emailUrl));
}
if (loginUrl) {
$('#account').val(decodeURIComponent(loginUrl));
}
if (countryCodeUrl) {
$('#country').val(countryCodeUrl).change();   // fix to change phone code value
$('#country').selectpicker('val', countryCodeUrl);
setTimeout(function(){
  $('#country').change();
},500);
}
if (phoneUrl) {
$('#mobile').val(decodeURIComponent(phoneUrl));
}

$('#modalIsDeviceInstalled').modal({keyboard: false, show: true, backdrop: 'static'});
$('.changeIsInstalled').on('click',function(){
if($(this).data('is-installed') === 'yes'){
  $('input[name=isDeviceInstalled][value=yes]').prop('checked', true);
}else{
  $('input[name=isDeviceInstalled][value=no]').prop('checked', true);
  $('#modalDeviceInstalledWarning').modal('show');
  $('.deivceInstalledTopWarning').show();
}
})


});


function GetURLParameter(sParam){
var sParameterName = '';
var sPageURL = window.location.search.substring(1);
var sURLVariables = sPageURL.split('&');
for (var i = 0; i < sURLVariables.length; i++)
{
    sParameterName = sURLVariables[i].split('=');
    if (sParameterName[0] == sParam)
    {
        return sParameterName[1];
    }
}
}


function getAdditionalData(data){
console.log(data);
$.ajax({
type: "POST",
url: "https://api.m2mglobaltech.com/Common/V1/Activation/SSP",
dataType: 'json',
data: data,
async: true,
cache: false,
beforeSend: function(){
  $('#servicePlan, #solution').prop('disabled',true).selectpicker('refresh');
  preloader.on();
},
success: function(result){
  console.log(result);
  preloader.off();

  if (result.MajorCode == '000') {

    if (result.Data && result.Data.ServiceProfiles && result.Data.ServiceProfiles.length && result.Data.Solutions && result.Data.Solutions.length) {
      if (data.ProductCode && data.SolutionCode) {
        setServicePlans(result.Data, data.SolutionCode);
      }else{
        setSolutionTypes(result.Data);
      }
    }else{
      alert('There is no Solution Types for this IMEI');
    }
  }
},
error: function(XMLHttpRequest, textStatus, errorThrown){
  console.log(XMLHttpRequest);
  console.log(textStatus);
  console.log(errorThrown);
  $('#servicePlan').prop('disabled',false).selectpicker('refresh');
  preloader.off();
}
});
}

function getDefaultParams(imei, DealerToken){
var USER_DATA = {};
USER_DATA.imei = imei;

if (DealerToken) {
USER_DATA.DealerToken = DealerToken;
}

$.ajax({
type: "POST",
url: "https://newapi.quiktrak.co/Common/V1/Activation/Verify",
dataType: 'json',
data: USER_DATA,
async: true,
cache: false,
beforeSend: function(){
  preloader.on();
},
success: function(result){
  preloader.off();

  console.log(result);
  var MajorCode = result.MajorCode;
  var MinorCode = result.MinorCode;
  //if (MajorCode == '000') {
    if (result.Data) {
      setDefaultData(result.Data, USER_DATA);
      getAssetDetails({
        imeis: imei,
        majortoken: DealerToken ? DealerToken : result.Data.DEALER_TOKEN,
      });
      if(result.Data.TREE){
        checkDealer(result.Data.TREE)
      }
    }
  //}
},
error: function(XMLHttpRequest, textStatus, errorThrown){
  console.log(XMLHttpRequest);
  console.log(textStatus);
  console.log(errorThrown);
  preloader.off();
}
});
}

function getAssetDetails(params){
$.ajax({
type: "GET",
url: "https://api.m2mglobaltech.com/Common/v1/Activation/GetAssetsInfo",
dataType: 'json',
data: params,
async: true,
cache: false,
success: function(result){
  console.log(result);
  if (result.MajorCode == '000') {
    if (result.Data) {
      setAssetDetails(result.Data);
    }
  }
},
error: function(XMLHttpRequest, textStatus, errorThrown){
  console.log(XMLHttpRequest);
  console.log(textStatus);
  console.log(errorThrown);
}
});
}

function setDefaultData(data, prevData){
if (data) {
var countryCode = data.DEALER_COUNTRY_CODE;
var timeZone = data.DEALER_TIME_ZONE;
var dealerName = data.DEALER_NAME;
var dealerEmail = data.DEALER_EMAIL;
var deviceType = data.DEVICETYPE;
var productName = data.PRODUCTNAME;
var urlDName = GetURLParameter('DealerName');

if (countryCode) {
  $('#country').val(countryCode).change();   // fix to change phone code value
  $('#country').selectpicker('val', countryCode);
}
/*if (timeZone) {
  $('#timeZone').selectpicker('val', timeZone);
}*/
if (!urlDName){
  $('#dealerName').val(decodeURIComponent(dealerName));
  $('#invoiceName').val(decodeURIComponent(dealerName));
}
if (!DealerTokenUrl) {
  $('#dealerToken').val(data.DEALER_TOKEN);
}
if (dealerEmail) {
  $('#invoiceEmail').val(decodeURIComponent(dealerEmail));
}
if (deviceType && deviceType != 'NONE') {
  $('#deviceType').val(productName).data('code',deviceType);
  $('.info').empty();
  getAdditionalData(
    {
      ProductCode: deviceType,
      IMEI: prevData.imei,
      DealerToken: prevData.DealerToken ? prevData.DealerToken : data.DEALER_TOKEN,
    },
    { get: 'solutions' }
  );
  setFitmentOptions($('[name="assetType"]').val());
}else{
  $('.info').html('<div class="errors">IMEI not found</div>');
  $('#imei').closest('.form-group').addClass('has-error has-danger');
  $('#servicePlan, #solution').empty().prop('disabled',true).selectpicker('refresh');
  $('#deviceType').val('');
  //$('#solution').empty().prop('disabled',true)
}
}
}

function setAssetDetails(params) {
if (params && typeof(params) == 'object' && params.Assets && typeof(params.Assets) == 'object' && params.Assets[0] && typeof(params.Assets[0]) == 'object') {
if (params.Assets[0].Name && !$('#name').val()) {
  $('#name').val( params.Assets[0].Registration && params.Assets[0].Name === params.Assets[0].IMEI ? params.Assets[0].Registration : params.Assets[0].Name);
}
if (params.Assets[0].Registration && !$('#rego').val()) {
  $('#rego').val(params.Assets[0].Registration);
}
if (params.Assets[0].Make && !$('#describe1').val()) {
  $('#describe1').val(params.Assets[0].Make);
}
if (params.Assets[0].Model && !$('#describe2').val()) {
  $('#describe2').val(params.Assets[0].Model);
}
if (params.Assets[0].Color && !$('#describe3').val()) {
  $('#describe3').val(params.Assets[0].Color);
}
if (params.Assets[0].Year && !$('#describe4').val()) {
  $('#describe4').val(params.Assets[0].Year);
}
if (params.Assets[0].InstallLocation && !$('#instalLocation').val()) {
  $('#instalLocation').val(params.Assets[0].InstallLocation);
}
if (params.Assets[0].Notes && !$('#notes').val()) {
  $('#notes').val(params.Assets[0].Notes);
}
if (params.Assets[0].InitAccHours && parseFloat(params.Assets[0].InitAccHours) && !$('#initialEngineHours').val()) {
  $('#initialEngineHours').val(params.Assets[0].InitAccHours);
}
if (params.Assets[0].InitMileage && parseFloat(params.Assets[0].InitMileage) && !$('#initialMileage').val()) {
  $('#initialMileage').val(params.Assets[0].InitMileage);
}
if (params.Assets[0].Voucher && params.Assets[0].Voucher != 'NONE') {
  processVoucherDetails(params.Assets[0]);
}else{
  $('#imei').data('binded-solution-code', '');
  $('#imei').data('binded-plan-code', '');
}


if (params.Assets[0].AssetType) {
  $('.asset-type-icon-wrapper[data-type="'+params.Assets[0].AssetType+'"]').click();
  setFitmentOptions($('[name="assetType"]').val());
}

}
}

function processVoucherDetails(assetDetails){
if (assetDetails) {
var solutionSelect = $('#solution');
if (assetDetails.Solution) {
  solutionSelect.selectpicker('val', assetDetails.Solution).prop('disabled',true).selectpicker('refresh');
  $('#imei').data('binded-solution-code', assetDetails.Solution);
  $('#imei').data('binded-plan-code', assetDetails.ServicePlanCode);

  $('#voucherCode').val(assetDetails.Voucher);
  $('input[name="paymentType"][value="4"]').closest('label').click();
}

}

}

function resizeIframe(obj) {
  obj.style.height = obj.contentWindow.document.body.scrollHeight + 'px';
}

function setServicePlans(data, solutionCode){
var serviceSelect = $('#servicePlan');
var selectedOption = GetURLParameter('ServiceProfile');
//var deviceTypeInput = $('#deviceType');
var solutionSelect = $('#solution');
var imeiInput = $('#imei');

if (data && data.ServiceProfiles && data.ServiceProfiles.length > 0) {
  if (serviceSelect.is(':disabled')) {
    serviceSelect.prop('disabled',false);
    serviceSelect.selectpicker('refresh');
  }
  if (solutionSelect.is(':disabled')) {
    solutionSelect.prop('disabled',false);
    solutionSelect.selectpicker('refresh');
  }
  var optionsHTML = '';
  var planType = 0;
  var activationForm = serviceSelect.closest('form');
  var planPrice = '';
  $.each(data.ServiceProfiles, function(key, val){
    if(solutionSelect.val() === "QProtect" && val.Code === "4Y6Z8YPFC8P4Y" ||
      solutionSelect.val() === "Al3rtTrack" && val.Code === "5f87b4fc-d25b-4" ||
      solutionSelect.val() === "LongLifePortable" && val.Code === "5f87b4fc-d25b-4" ||
      solutionSelect.val() === "Al3rtProtect" && val.Code === "4Y6Z8YPFC8P4Y" ||
      solutionSelect.val() === "Loc8" && val.Code === "5f87b4fc-d25b-4" ||
      solutionSelect.val() === "Al3rtLoc8" && val.Code === "5f87b4fc-d25b-4"){
      planType = getPlanType(val.Code);
      //planPrice = getPlanPrice(val.Code, solutionSelect.val());
      optionsHTML += `<option value="${ val.Code }" data-plantype="${ planType }">${ val.Name } ${ !planPrice ? '' : ' - ' + planPrice  }</option>`;
    }
  });
  serviceSelect.html(optionsHTML);
  serviceSelect.selectpicker('refresh');


  if (selectedOption && serviceSelect.find('option[value="' + selectedOption + '"]').length > 0) {
    serviceSelect.selectpicker('val', selectedOption);
  }else if(serviceSelect.find('option[value="4Y6Z8YPFC8P4Y"]').length > 0){
    serviceSelect.selectpicker('val', '4Y6Z8YPFC8P4Y');
  }else{
    serviceSelect.selectpicker('val', '5f87b4fc-d25b-4');
  }

  if (imeiInput.data('binded-plan-code')) {
    selectedOption = imeiInput.data('binded-plan-code');
    //console.log('here');
    serviceSelect.selectpicker('val', selectedOption).prop('disabled',true).selectpicker('refresh');
    solutionSelect.prop('disabled',true).selectpicker('refresh');
  }
}
}

function setSolutionTypes(data){
var solutionSelect = $('#solution');
//var serviceSelect = $('#servicePlan');
var imeiInput = $('#imei');
var selectedOption = GetURLParameter('SolutionType');
var urlServProf = GetURLParameter('ServiceProfile');

if (data && data.Solutions && data.Solutions.length > 0) {
  if (solutionSelect.is(':disabled')) {
    solutionSelect.prop('disabled',false);
  solutionSelect.selectpicker('refresh');
  }

  var optionsHTML = '';
  var planType = 0;

  $.each(data.Solutions, function(key, val){
    if (val.Code === 'QProtect' || val.Code === 'Al3rtProtect' || val.Code === 'Loc8' || val.Code === 'Al3rtLoc8' || val.Code === 'Al3rtTrack'|| val.Code === 'LongLifePortable') {
      optionsHTML += '<option value="' + val.Code + '" >' + val.Name + '</option>';
    }
  });
  solutionSelect.html(optionsHTML);
  solutionSelect.selectpicker('refresh');

  if (selectedOption && solutionSelect.find('option[value="' + selectedOption + '"]').length > 0) {
    solutionSelect.selectpicker('val', selectedOption);
  }else if (solutionSelect.find('option[value="Al3rtLoc8"]').length > 0) {
    solutionSelect.selectpicker('val', 'Al3rtLoc8');
  } else{
    solutionSelect.selectpicker('val', 'Loc8');
  }

  if (imeiInput.data('binded-solution-code')) {
    selectedOption = imeiInput.data('binded-solution-code');
    solutionSelect.selectpicker('val', selectedOption).prop('disabled',true).selectpicker('refresh');
  }
}
}

function setFitmentOptions(selected){
//var solutionSelect = $('#solution');
var fitoptionsSelect = $('#fitoptions');
var optionsHTML = '';
var optionsArry = [];

if (selected && selected.toLowerCase() == 'boatwatch' || selected && selected.toLowerCase() == 'boatloc8' ||
  selected && selected.toLowerCase() == 'boat' || selected && selected.toLowerCase() == 'jetski') {
  optionsArry = [
    { Code: FITMENTOPTIONS.BilgeAlarm,	Name: 'Bilge Alarm', },
    { Code: FITMENTOPTIONS.EngineTheft,	Name: 'Engine Theft', },
    { Code: FITMENTOPTIONS.RemoteImmob,	Name: 'Remote Immobilisation', },
    { Code: FITMENTOPTIONS.ShorePowerDisconn,	Name: 'Shore Power Disconnect', },
    { Code: FITMENTOPTIONS.Siren,	Name: 'Siren', },
  ];
}else{
  optionsArry = [
    { Code: FITMENTOPTIONS.AlarmIntegration,	Name: 'Alarm Integration', },
    { Code: FITMENTOPTIONS.FitmentAfterIsolater,	Name: 'Fitment After Isolator', },
    { Code: FITMENTOPTIONS.NotConnectedIgn,	Name: 'Not Connected to Ignition / Accessory Power', },
    { Code: FITMENTOPTIONS.RemoteDoor,	Name: 'Remote Door', },
    { Code: FITMENTOPTIONS.RemoteImmob,	Name: 'Remote Immobilisation', },
    { Code: FITMENTOPTIONS.SOSButton,	Name: 'SOS Button', },
  ];
}

$.each(optionsArry, function(key, val){
  optionsHTML += '<option value="' + val.Code + '" >' + val.Name + '</option>';
});

if (fitoptionsSelect) {
  fitoptionsSelect.html(optionsHTML);
  if (fitoptionsSelect.is(':disabled')) {
    fitoptionsSelect.prop('disabled',false);
  }
  fitoptionsSelect.selectpicker('refresh');
}

}

function getPlanType(code){
var ret = 0;
  switch(code){
    case '0000000000000':
      ret = 0;
      break;
    case 'QUIKLOC800000':
      ret = 8;
      break;
    case '1C783FA4TRAK':
      ret = 1;
      break;
    case 'LR6Z8YPFC8PHJ':
      ret = 3;
      break;
    case '2Y6Z8YPFC8P2Y':
      ret = 10;
      break;
    case '4Y6Z8YPFC8P4Y':
      ret = 11;
      break;
    case '1C8D3EDEMOTI':
      ret = 2;
      break;
    case '33ENPEYR38SRC':
      ret = 3;
      break;
    case '5f87b4fc-d25b-4':
      ret = 1;
  }
return ret;
}

function getPlanPrice(servicePlanCode, solutionTypeCode){
//console.log(servicePlanCode)
//console.log(solutionTypeCode)
//'5f87b4fc-d25b-4' //"Annual"
//'33ENPEYR38SRC' //"Monthly"
let prices = {
/*QProtect: {
  '5f87b4fc-d25b-4': '$49.00',
},*/
Loc8: {
  '33ENPEYR38SRC': '$3.00',
  '5f87b4fc-d25b-4': '$36.00',
},
Track: {
  '33ENPEYR38SRC': '$8.00',
  '5f87b4fc-d25b-4': '$88.00',
},
/*Watch: {
  '33ENPEYR38SRC': '$33.00 inc GST',
  '5f87b4fc-d25b-4': '$360.00 inc GST',
}*/
}
let ret = ''
if(prices[solutionTypeCode] && prices[solutionTypeCode][servicePlanCode]){
ret = prices[solutionTypeCode][servicePlanCode]
}
return ret
}

function checkDealer(tree){
if (!tree){
return
}

let dealerList = {
  witi: {
    treeKey: '12354',
    name: 'WITI GPS',
    url: 'https://activation.witigps.com/'
  },
  warden: {
    treeKey: '13787',
    name: 'WardenGPS',
    url: 'https://activation.wardengps.com/'
  }
}

let treeNodes = tree.split('-');
let dealers = Object.keys(dealerList);

for (var i = treeNodes.length - 1; i >= 0; i--) {
for (const dealer of dealers) {
  if (treeNodes[i] === dealerList[dealer].treeKey){
    let pathArr = window.location.pathname.split('/')
    let redirectUrl = dealerList[dealer].url + '/' + pathArr[pathArr.length-1] + window.location.search

    $('.redirectUrl').attr('href', redirectUrl)
    $('.dealerName').text(dealerList[dealer].name)
    $('#modalDealerTransfer').modal({keyboard: false, show: true, backdrop: 'static'});
    break;
  }
}
}
}


$('#solution').on('changed.bs.select', function (e, clickedIndex, newValue, oldValue) {
var selected = $(e.currentTarget).val();
//setFitmentOptions(selected);
var sectionPayment = $('.form_section_payment');
var autosuspendGroup = $('.groupAutoSuspend');
var $formUpgrade = $('.form-upgrade');

if (selected ) {
if (selected.toLowerCase() != 'protect' && selected.toLowerCase() != 'witiprotect' && selected.toLowerCase() != 'witiqprotect' && selected.toLowerCase() != 'qprotect' || $formUpgrade.length) {
  if (DealerTokenUrl && !fromAppFlagUrl) {
    autosuspendGroup.show();
  }else{
    autosuspendGroup.hide();
  }
  sectionPayment.show();
  $('input[name="paymentType"]').attr('required',true);
}else{
  autosuspendGroup.hide();
  sectionPayment.hide();
  $('input[name="paymentType"]').attr('required',false);
}

getAdditionalData({
  SolutionCode: selected,
  ProductCode: $('#deviceType').data('code'),
  IMEI: $('#imei').val(),
  DealerToken: DealerTokenUrl ? DealerTokenUrl : $('#dealerToken').val(),
});
}else{
console.log('there in no Solution selected');
}

});

$("input[name='paymentType']").change(function () {
console.log();
var val = $(this).val();
$('.paymentFieldWrapper').hide();
$('.byInvoiceWrapper input, .creditCardWrapper input, .bankDirectWrapper input, .byVoucherWrapper input').attr('required',false);

switch (val){
  case '1':
    $('.creditCardWrapper').show();
    $('.creditCardWrapper input').attr('required',true);
    break;
  case '2':
    $('.bankDirectWrapper').show();
    $('.bankDirectWrapper input').attr('required',true);
    break;

  case '3':
    var form = $(this).closest('form');
    if (form && form.attr('id')) {
      if (form.attr('id') == 'form-upgrade') {
        $('.byInvoiceWrapper input[name="invoiceName"]').attr('required',true);
      }else if (form.attr('id') == 'form-register' || form.attr('id') == 'form-activate') {
        $('.byInvoiceWrapper input[name="invoiceName"], .byInvoiceWrapper input[name="invoiceEmail"]').attr('required',true);
      }else{
        $('.byInvoiceWrapper input').attr('required',true);
      }
    }else{
      $('.byInvoiceWrapper input').attr('required',true);
    }
    $('.byInvoiceWrapper').show();

    break;

  case '4':
    $('.byVoucherWrapper').show();
    $('.byVoucherWrapper input').attr('required',true);
    break;
}
});

//var savedImei = $('#imei').val();
$('#imei').data('prev-imei', $('#imei').val() );
$('#imei').on('blur', function(){
$(this).val( $(this).val().padStart(16,0) );
if ( $(this).data('prev-imei') != this.value ) {
$(this).data('prev-imei', this.value) ;
getDefaultParams(this.value, DealerTokenUrl);
}
});

$('#imei').on('input', function(){
if (this.value.length == 16 && $(this).data('prev-imei') != this.value ) {
let tempImei = this.value
if(tempImei.startsWith('868')){
	//tempImei = tempImei.replace('868','000');
	tempImei = '000' + tempImei.slice(3);
	$('#imei').val(tempImei)
}

$(this).data('prev-imei', tempImei) ;
getDefaultParams(tempImei, DealerTokenUrl);
}
});

$('[name="rego"]').on('input', function(){
let $name = $('[name="name"]');
//let $imei = $('[name="imei"]');

$name.val(this.value)
})

$('[name="isConnectedToIgnition"]').on('change', function (){
let fitoptionsSelect = $('#fitoptions');
let fitmentValue = fitoptionsSelect.val();
let ignitionIndex = fitmentValue ? fitmentValue.indexOf(FITMENTOPTIONS.NotConnectedIgn) : -1;
let newVal = fitmentValue ? fitmentValue : [];

if(this.value === 'no' && ignitionIndex === -1){
newVal.push(FITMENTOPTIONS.NotConnectedIgn);
}else if(this.value === 'yes' && ignitionIndex !== -1){
newVal.splice(ignitionIndex, 1);
}

fitoptionsSelect.selectpicker('val', newVal);
})
$('[name="fitoptions"]').on('change', function (){
let fitmentValue = $('#fitoptions').val();

if(fitmentValue && fitmentValue.includes(FITMENTOPTIONS.NotConnectedIgn)){
$('input[name=isConnectedToIgnition][value=no]').prop('checked', true);
}else{
$('input[name=isConnectedToIgnition][value=yes]').prop('checked', true);
}
});

var assetTypeIconWrapperEl = $('.asset-type-icon-wrapper');
assetTypeIconWrapperEl.on('click', function(){
var that = $(this);
var type = that.data('type');

assetTypeIconWrapperEl.removeClass('active');
that.addClass('active');
$('input[name="assetType"]').val(that.data("type"));

setFitmentOptions(type);
});


$('body').on('change keyup input click', '.only_numbers', function() {
if (this.value.match(/[^0-9]/g)) {
    this.value = this.value.replace(/[^0-9]/g, '');
}
});
$('body').on('change keyup input click', '.only_numbers_and_negative', function() {
if (this.value.match(/[^0-9-]/g)) {
    this.value = this.value.replace(/[^0-9-]/g, '');
}
});