<!DOCTYPE html>
<html lang="en">

<head>

  <meta charset="UTF-8">
  <!-- <meta name="viewport" content="width=device-width"> -->
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
  <link rel="shortcut icon" href="images/favicon-live.png" type="image/x-icon">
  <link rel="stylesheet" type="text/css" href="css/normalize.css" />
  <link rel="stylesheet" type="text/css" href="css/bootstrap.css" />
  <link rel="stylesheet" type="text/css" href="css/bootstrap-theme.css" />
  <link rel="stylesheet" type="text/css" href="css/bootstrap-select.min.css" />
  <link rel="stylesheet" type="text/css" href="css/materialPreloader.min.css" />
  <link rel="stylesheet" type="text/css" href="css/animate.css" />
  <link rel="stylesheet" type="text/css" href="css/checkbox-radio.css" />
  <link rel="stylesheet" type="text/css" href="css/fonts.css" />
  <link rel="stylesheet" type="text/css" href="fonts/fontastic/styles.css?v=<?php echo filemtime('fonts/fontastic/styles.css'); ?>" />
  <link rel="stylesheet" type="text/css" href="css/style.css?v=<?php echo filemtime('css/style.css'); ?>" />

  <title>Registration</title>
</head>

<body class="bg_body">
  <?php include "header.php"; ?>
  <div class="container page page_register">
    <div class="col-xs-12 animated flipInX deivceInstalledTopWarning" style="display: none;">
      <div class="alert alert-warning max-width-940 mx-auto">
        <strong>Warning!</strong> The systems requires a series of commands to configure the unit and your account, please ensure the system is installed and has power within 3 days of activation.
      </div>
    </div>
    <div class="col-xs-12 form">
      <div class="header">
        <a href="https://western.gps-secure.co/"><img src="images/logo.png" alt=""></a>
      </div>
      <div class="form_header">
        <h3>Registration </h3>
        <span class="help-info">(* - fields are required)</span>
        <div class="form_header_divider"></div>
      </div>
      <form data-toggle="validator" role="form" class="form-register" id="form-register">
        <input type="hidden" name="projectNumber" id="projectNumber" value="55">
        <input type="hidden" name="dealerToken" id="dealerToken" value="">
        <input type="hidden" name="domain" id="domain" value="western.gps-secure.co">
        <input type="hidden" name="deviceType" id="deviceType" value="">
        <input type="hidden" name="assetType" id="assetType" value="Bike">

        <input type="hidden" name="dealerName" id="dealerName" value="">
        <input type="hidden" name="mobile" id="mobile" value="123456789">
        <input type="hidden" name="country" id="country" value="USA">
        <input type="hidden" name="language" id="language" value="en">
        <input type="hidden" name="timeZone" id="timeZone" value="-6_Central Standard Time">
        <input type="checkbox" id="autosuspend" name="autosuspend" checked style="display:none;">

        <input type="hidden" name="paymentType" value="3">
        <input type="hidden" name="invoiceName" id="invoiceName">
        <input type="hidden" name="invoiceEmail" id="invoiceEmail">

        <div class="form_section">
          <div class="row">
            <div class="form-group col-xs-12">
              <label for="imei" class="control-label">IMEI <span class="help-info">(recorded on device)<span class="color-red">*</span></span></label>
              <input type="text" class="form-control clearAfter" id="imei" name="imei" value="" maxlength="16" required>

            </div>
            <div class="form-group col-xs-12 col-sm-6">
              <label for="accountName" class="control-label">Customer Name<span class="color-red">*</span></label>
              <input type="text" class="form-control clearAfter" id="accountName" name="accountName" placeholder="" required maxlength="190">
            </div>
            <div class="form-group col-xs-12 col-sm-6">
              <label for="email" class="control-label">Customer Email<span class="color-red">*</span></label>
              <input type="email" class="form-control clearAfter" id="email" name="email" placeholder="" data-error="That email address is invalid" required maxlength="190">
              <div class="help-block with-errors"></div>
            </div>
          </div>

          <div class="row">
            <div class="form-group col-xs-12  col-sm-6">
              <label for="phone" class="control-label">Customer Phone <span class="color-red">*</span></span></label>
              <input type="text" class="form-control clearAfter" id="phone" name="phone" value="" maxlength="16" required>

            </div>

            <div class="form-group col-xs-12  col-sm-6 ">
              <label for="vin" class="control-label">Customer VIN Number<span class="color-red">*</span></label>
              <input type="text" class="form-control clearAfter" id="vin" name="vin" required maxlength="190">
            </div>
          </div>

          <div class="row">
            <div class="form-group  col-xs-12 col-sm-6">
              <label for="solution" class="control-label">Solution Type <span class="color-red">*</span></label>
              <select id="solution" name="solution" class="selectpicker form-control" title="- Select Solution Type -" data-size="8" disabled required>
                <!--<option value="Loc8" selected>Loc8</option>-->
              </select>
            </div>
            <div class="form-group  col-xs-12 col-sm-6">
              <label for="servicePlan" class="control-label">Service Plan<span class="color-red">*</span></label>
              <select id="servicePlan" name="servicePlan" class="selectpicker form-control" title="- Select Service Plan -" data-size="8" disabled required>
                <!-- <option value="5f87b4fc-d25b-4" data-plantype="1" selected>Annual</option>-->
              </select>
            </div>
          </div>

          <p>Has the device been installed and the asset currently has power ?</p>
          <div class="row">
            <div class="form-group col-xs-12">
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isDeviceInstalled" value="no" checked>
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>No</span>
                </label>
              </div>
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isDeviceInstalled" value="yes">
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>Yes</span>
                </label>
              </div>
            </div>
          </div>

          <p>Connected to Ignition ?</p>
          <div class="row">
            <div class="form-group col-xs-12">
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isConnectedToIgnition" value="no">
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>No</span>
                </label>
              </div>
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isConnectedToIgnition" value="yes" checked>
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>Yes</span>
                </label>
              </div>
            </div>
          </div>


          <div class="form_section  margin-bottom-40">
            <span>Services are provided in accordance with the T & C which can be found at <a target="_blank" href="https://www.policy.westerngps.com/">policy.westerngps.com</a></span>
          </div>

          <div class="form_section">
            <div class="form-group margin-0 ">
              <button type="submit" class="btn form_submit">
                <img class="preloader vis_hidden" src="images/loader.gif" alt="">
                <span class="submit_text">Submit</span>
              </button>
              <div class="help-block info"></div>
            </div>
          </div>

      </form>


    </div>
  </div>
  <?php include "footer.php"; ?>

  <script src="js/jquery-1.12.0.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script src="js/validator.min.js"></script>
  <script src="js/bootstrap-select.min.js"></script>
  <script src="js/materialPreloader.min.js"></script>
  <script src="js/initialScript.js?v=<?php echo filemtime('js/initialScript.js'); ?>"></script>
  <script src="js/register.js?v=<?php echo filemtime('js/register.js'); ?>"></script>

  <!-- mask input -->
  <script src="js/maskedinput.js"></script>




</body>

</html>