<!DOCTYPE html>
<html lang="en">
<head>

	<meta charset="UTF-8">
	<!-- <meta name="viewport" content="width=device-width"> -->
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<link rel="shortcut icon" href="images/favicon-live.png" type="image/x-icon">
	<link rel="stylesheet" type="text/css" href="css/normalize.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap-theme.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap-select.min.css" />
	<link rel="stylesheet" type="text/css" href="css/materialPreloader.min.css" />
	<link rel="stylesheet" type="text/css" href="css/animate.css" />
	<link rel="stylesheet" type="text/css" href="css/checkbox-radio.css" />
	<link rel="stylesheet" type="text/css" href="css/fonts.css" />
	<link rel="stylesheet" type="text/css" href="fonts/fontastic/styles.css?v=<?php echo filemtime('fonts/fontastic/styles.css'); ?>" />
	<link rel="stylesheet" type="text/css" href="css/style.css?v=<?php echo filemtime('css/style.css'); ?>" />

	<title>Replace Unit Activation</title>
</head>
<body class="bg_body">
<?php include "header.php"; ?>
	<div class="container page page_activate">
		<div class="col-xs-12 animated flipInX deivceInstalledTopWarning" style="display: none;">
			<div class="alert alert-warning max-width-940 mx-auto">
				<strong>Warning!</strong> The systems requires a series of commands to configure the unit and your account, please ensure the system is installed and has power within 3 days of activation.
			</div>
		</div>
		<div class="col-xs-12 form">
      <div class="header">
        <a href="https://western.gps-secure.co/"><img src="images/logo.png" alt=""></a>
      </div>
			<div class="form_header">
				<h3>Replace Unit Activation</h3>
				<span class="help-info">(* - fields are required)</span>
				<div class="form_header_divider"></div>
			</div>



			<form id="form-replace" data-toggle="validator" role="form" class="form-replace" >
				<input type="hidden" name="projectNumber" id="projectNumber" value="55">
				<input type="hidden" name="dealerToken" id="dealerToken" value="">
				<input type="hidden" name="domain" id="domain" value="western.gps-secure.co">
				<input type="hidden" name="deviceType" id="deviceType" value="">
				<input type="hidden" name="assetType" id="assetType" value="Bike">
				<input type="hidden" name="reportSubject" id="reportSubject" value="Replace Unit Activation">

        <input type="hidden" name="dealerName" id="dealerName" value="">
        <input type="hidden" name="paymentType" value="3" >
        <input type="hidden" name="invoiceName" id="invoiceName">
        <input type="hidden" name="invoiceEmail" id="invoiceEmail">
        <input type="checkbox" id="autosuspend" name="autosuspend" checked style="display:none;">
        <input type="hidden" name="name" id="name" >
        <input type="hidden" name="describe1" id="describe1" >
        <input type="hidden" name="describe2" id="describe2" >
        <input type="hidden" name="describe3" id="describe3" >
        <input type="hidden" name="describe4" id="describe4" >

        <div class="form_section">
          <div class="row">
            <div class="form-group col-xs-12 col-sm-6">
              <label for="imeiOld" class="control-label">Old IMEI<span class="color-red">*</span></label>
              <input type="text" class="form-control clearAfter" id="imeiOld" name="imeiOld" value="" maxlength="16" required>
            </div>
            <div class="form-group col-xs-12 col-sm-6">
              <label for="imei" class="control-label">IMEI <span class="help-info">(recorded on device)<span class="color-red">*</span></span></label>
              <input type="text" class="form-control clearAfter" id="imei" name="imei" value="" maxlength="16" required>

            </div>

            <div class="form-group col-xs-12 ">
              <label for="account" class="control-label">Login Name / Email<span class="color-red">*</span></label>
              <input type="text" class="form-control clearAfter" id="account" name="account" placeholder="" required maxlength="190">
              <div class="help-block with-errors"></div>
            </div>
          </div>

          <div class="row" >
            <div class="form-group  col-xs-12 col-sm-6">
              <label for="solution" class="control-label">Solution Type <span class="color-red">*</span></label>
              <select id="solution" name="solution" class="selectpicker form-control" title="- Select Solution Type -" data-size="8" disabled required>
                <!--<option value="Loc8" selected>Loc8</option>-->
              </select>
            </div>
            <div class="form-group  col-xs-12 col-sm-6">
              <label for="servicePlan" class="control-label">Service Plan<span class="color-red">*</span></label>
              <select id="servicePlan" name="servicePlan" class="selectpicker form-control" title="- Select Service Plan -" data-size="8" disabled required>
                <!--<option value="5f87b4fc-d25b-4" data-plantype="1" selected>Annual</option>-->
              </select>
            </div>
          </div>

          <p >Has the device been installed and the asset currently has power ?</p>
          <div class="row">
            <div class="form-group col-xs-12">
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isDeviceInstalled" value="no" checked>
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>No</span>
                </label>
              </div>
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isDeviceInstalled" value="yes">
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>Yes</span>
                </label>
              </div>
            </div>
          </div>

          <p>Connected to Ignition ?</p>
          <div class="row">
            <div class="form-group col-xs-12">
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isConnectedToIgnition" value="no" >
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>No</span>
                </label>
              </div>
              <div class="radio animated flipInX">
                <label class="control-label padding-left-0">
                  <input type="radio" name="isConnectedToIgnition" value="yes" checked>
                  <span class="cr"><i class="cr-icon glyphicon glyphicon-ok"></i></span>
                  <span>Yes</span>
                </label>
              </div>
            </div>
          </div>
        </div>
              
              
				<div class="form_section  margin-bottom-40">
            <span>Services are provided in accordance with the T & C which can be found at <a target="_blank" href="https://www.policy.westerngps.com/">policy.westerngps.com</a></span>
          </div>

        <div class="form_section">
          <div class="form-group margin-0 ">
            <button type="submit" class="btn form_submit">
              <img class="preloader vis_hidden" src="images/loader.gif" alt="">
              <span class="submit_text">Submit</span>
            </button>
            <div class="help-block info"></div>
          </div>
				</div>
			</form>

		</div>
	</div>
<?php include "footer.php"; ?>

	<script src="js/jquery-1.12.0.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<script src="js/validator.min.js"></script>
	<script src="js/bootstrap-select.min.js"></script>
	<script src="js/materialPreloader.min.js"></script>
	<script src="js/initialScript.js?v=<?php echo filemtime('js/initialScript.js'); ?>"></script>
	<script src="js/replace.js?v=<?php echo filemtime('js/replace.js'); ?>"></script>

	<!-- mask input -->
	<script src="js/maskedinput.js"></script>


	<script>
		var imeis = GetURLParameter('imeis');
		if (imeis) {
			$('#imeiOld').val(imeis);
			getDefaultParams(imeis,DealerTokenUrl);
		}

		if (DealerTokenUrl && imeis) {
			getUserDetails({
				imeis: imeis,
				majortoken: DealerTokenUrl,
			});

		}else{
			alert('Dealer token is missing');
			$('.info').html('<div class="errors">Dealer token is missing</div>');
		}

		/*$('#imei').on('blur', function(){
			$(this).val( $(this).val().padStart(16,0) );
		});*/

		function getUserDetails(params){
			$.ajax({
				type: "GET",
				url: "https://newapi.quiktrak.co/Common/v1/Activation/GetAssetsInfo",
				dataType: 'json',
				data: params,
				async: true,
				cache: false,
				beforeSend: function(){
					wait_save_data = 0;
					$('.form_submit').toggleClass('disabled');
					$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
				},
				success: function(result){
					wait_save_data = 1;
					$('.form_submit').toggleClass('disabled');
					$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
					console.log(result);
					var MajorCode = result.MajorCode;
					if (MajorCode == '000') {
						if (result.Data) {
							setUserDetails(result.Data);
						}
					}else{
						$('.info').html('<div class="errors">This IMEI '+params.imeis+' not belong to Dealer Account '+$(dealerName).val()+'</div>');
					}
				},
				error: function(XMLHttpRequest, textStatus, errorThrown){
					console.log(XMLHttpRequest);
					console.log(textStatus);
					console.log(errorThrown);
					wait_save_data = 1;
					$('.form_submit').toggleClass('disabled');
					$('.form_submit .submit_text, .form_submit .preloader').toggleClass('vis_hidden');
				}
			});
		}

		function setUserDetails(params) {
			if (params && typeof(params) == 'object' && params.Assets && typeof(params.Assets) == 'object' && params.Assets[0] && typeof(params.Assets[0]) == 'object') {
				if (params.Name){
					$('#dealerName').val(params.Name);
					$('#invoiceName').val(params.Name);
				}
		        if (params.Email) {
					$('#invoiceEmail').val(params.Email);
				}
				if (params.Assets[0].LoginName) {
					$('#account').val(params.Assets[0].LoginName);
				}
				if (params.Assets[0].Name && !$('#name').val()) {
					$('#name').val(params.Assets[0].Name);
				}
				if (params.Assets[0].Registration && !$('#rego').val()) {
					$('#rego').val(params.Assets[0].Registration);
				}
				if (params.Assets[0].Make && !$('#describe1').val()) {
					$('#describe1').val(params.Assets[0].Make);
				}
				if (params.Assets[0].Model && !$('#describe2').val()) {
					$('#describe2').val(params.Assets[0].Model);
				}
				if (params.Assets[0].Color && !$('#describe3').val()) {
					$('#describe3').val(params.Assets[0].Color);
				}
				if (params.Assets[0].Year && !$('#describe4').val()) {
					$('#describe4').val(params.Assets[0].Year);
				}

				if (params.Assets[0].AssetType) {
					$('.asset-type-icon-wrapper[data-type="'+params.Assets[0].AssetType+'"]').click();
				}

				if (params.Assets[0].Solution) {
					setTimeout(function(){ $('#solution').selectpicker('val', params.Assets[0].Solution); }, 500);

					if (params.Assets[0].Solution == 'Protect' || params.Assets[0].Solution == 'Loc8') {
						$('input[name="paymentType"]').attr('required',false);
						$('.form_section_payment').hide();
					}else{
						$('input[name="paymentType"]').attr('required',true);
						$('.form_section_payment').show();
					}
				}else{
					$('.form_section_payment').hide();
				}
			}
		}

	</script>
</body>
</html>