<!DOCTYPE html>
<html lang="en">
<head>

	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width">
	<link rel="shortcut icon" href="images/favicon.png" type="image/x-icon">
	<link rel="stylesheet" type="text/css" href="css/normalize.css" />
	<link rel="stylesheet" type="text/css" href="css/font-awesome.min.css" />
	<link rel="stylesheet" type="text/css" href="css/fonts.css" />
	<link rel="stylesheet" type="text/css" href="css/animate.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap-theme.css" />
	<link rel="stylesheet" type="text/css" href="css/style.css" />
	<!--checkboxes styles-->
	<!-- <link rel="stylesheet" type="text/css" href="css/checkboxes.css" /> -->
	<link rel="stylesheet" type="text/css" href="css/bootstrap-checkbox.css" />
	<!--slick slider styles-->
	<!-- <link rel="stylesheet" type="text/css" href="css/slick.css" />	
	<link rel="stylesheet" type="text/css" href="css/slick-theme.css" />
	<link rel="stylesheet" type="text/css" href="css/slick_corrections.css" /> -->
	<link rel="stylesheet" href="css/bootstrap-select.min.css">
	<link rel="stylesheet" href="css/bootstrap-datepicker3.min.css">

	<link rel="stylesheet" type="text/css" href="css/qtg-style.css" />
	<link rel="stylesheet" type="text/css" href="css/qtg-style-activation.css" />

	
	<title>QuikTrak Global</title>
	
</head>
<body>


	<?php include 'header.php'; ?>

	

	<section class="bg_block_one qtg_bg_block_one1" id="bg_block_one">
		<div class="container">
			<div class="col-xs-12 block_one_caption">
				<div class="caption" style="padding-top:70px">						
					<div style="color:rgb(255,255,255);font-size:1.6em;font-weight:lighter">Activation Existing Customer</div>
					<div class="qtg-text-decoration"></div>
				
					<div class="" style="color:rgb(255,255,255);font-weight:300px">You can leave a message using the contact form below</div>					
				</div>
			</div>

		</div>
	</section>
	
	
	
		<div class="container show_block bg_block_footer activation_container" style="">
			<form class="form-activation" >
				<div class="col-xs-12">
					<h4 style="color:rgb(255,255,255);">User <span style="color:#b3b3b3;font-size:14px;">(all fields are required)</span></h4>  					 
					<div class="qtg-text-decoration"></div>
				</div>			

				
				<div class="col-xs-12 nopadding" >
					<input type="hidden" id="customerType" name="customerType" value="2">
					<div class="col-xs-12 col-sm-6 nopadding align-left contact-form-m">
						<div class="col-xs-12 form-group">
							<input type="text" id="loginName" class="mandatory form-control" name="loginName" autocomplete="off" maxlength="200" placeholder="Login name" required>
						</div>
						<div class="col-xs-12 form-group">
							<input type="text" id="lastName" class="mandatory form-control" name="lastName" autocomplete="off" maxlength="200" placeholder="Last name" required>
						</div>
					</div>
					<div class="col-xs-12 col-sm-6 nopadding contact-form-m">
						<div class="col-xs-12 form-group">
							<input type="text" id="firstName" class="mandatory form-control" name="firstName" autocomplete="off" maxlength="200" placeholder="First name" required>
						</div>
						<div class="col-xs-12 form-group">
							<input type="text" id="accountName" class="mandatory form-control" name="accountName" autocomplete="off" maxlength="200" placeholder="Account name" required>
						</div>	
					</div>
				</div>
			
			
				<!-- <div class="col-xs-12 description nopadding">
					<div class="col-xs-12 form-group">
						<textarea name="assetsDetails" id="assetsDetails" class="mandatory form-control" placeholder="Assets Details" id="" cols="30" rows="10" maxlength="1000" required></textarea>
					</div>						
					
				</div> -->

				<div class="col-xs-12">
					<div style="border-bottom:1px solid #cccccc;width:100%;height:1px;margin-top:20px;margin-bottom:20px"></div>
				</div>
						
						
				<div class="col-xs-5 col-sm-8">							
					<h4 style="color:rgb(255,255,255);">Device <span class="count"></span> <span style="color:#b3b3b3;font-size:14px;">(all fields are required)</span></h4> 					 
					<div class="qtg-text-decoration"></div>					
				</div>
				<div class="col-xs-7 col-sm-4 addMoreWrapper">
					<button type="button" class="button_send_first" id="addMoreDev" style="width:150px;padding-left:25px;padding-right:25px;">
						<p><nobr>Add more</nobr></p>									
					</button>	
				</div>
				
				
				<!--contact form-->
				<div class="col-xs-12 nopadding" >						
					<div class="col-xs-12 col-sm-6 nopadding align-left contact-form-m">
						<div class="col-xs-12 form-group">
							<input type="text" id="imei_1" class="form-control mandatory " name="imei_1" autocomplete="off" maxlength="16" placeholder="IMEI (recorded on device)" required>
						</div>
						
						<!-- <div class="upload-logo-descr" style="padding:15px; margin-top:50px">
							Remove the 0 at the start of the IMEI number and enter the remaining 15 digits
						</div> -->
					</div>
					<div class="col-xs-12 col-sm-6 nopadding contact-form-m">
						<div class="col-xs-12 form-group">
							<input type="text" id="vehicleDevice_1" class="form-control mandatory " name="vehicleDevice_1" autocomplete="off" maxlength="200" placeholder="Registration of Vehicle Device fitted to" required>
						</div>
					</div>
					<div class="col-xs-12 col-sm-6 nopadding contact-form-m">
						<div class="col-xs-12 form-group">
							<input type="text" id="make_1" class="form-control mandatory " name="make_1" autocomplete="off" maxlength="200" placeholder="Make" required>
						</div>
					</div>
					<div class="col-xs-12 col-sm-6 nopadding contact-form-m">
						<div class="col-xs-12 form-group">
							<input type="text" id="model_1" class="form-control mandatory " name="model_1" autocomplete="off" maxlength="200" placeholder="Model" required>
						</div>
					</div>
					<div class="col-xs-12 col-sm-6 nopadding contact-form-m">
						<div class="col-xs-12 form-group">
							<input type="text" id="color_1" class="form-control mandatory " name="color_1" autocomplete="off" maxlength="200" placeholder="Color" required>
						</div>
					</div>
					<div class="col-xs-12 col-sm-6 nopadding contact-form-m">
						<div class="col-xs-12 form-group">
							<input type="text" id="year_1" class="form-control mandatory only_numbers" name="year_1" autocomplete="off" maxlength="200" placeholder="Year" required>
						</div>
					</div>
					<ul id="all_device_cards" class="col-xs-12 all_device_cards contact-form-m nopadding">
						
						<!-- <li class="device_card">
							<div class="col-xs-12 col-sm-4 col-md-5 form-group">
								<input type="text" name="imei" id="" class="form-control" readonly maxlength="50">
							</div>
							<div class="col-xs-12 col-sm-4 col-md-5">
								<input type="text" name="vehicleDevice" class="form-control" id="" readonly maxlength="50">	
							</div>
							<div class="col-xs-12 col-sm-4 col-md-2">
								<button class="buttonDeleteDev button_upload_first payment_button">
									<p>delete</p>
								</button>
							</div>
						</li> -->
					</ul>
				</div>					
				<div class="col-xs-12 description nopadding">
					<div class="col-xs-12">
						<div style="border-bottom:1px solid #cccccc;width:100%;height:1px;margin-top:20px;margin-bottom:20px">							
						</div>
					</div>
				</div>
				
				<div class="col-xs-12">							
					<h4 style="color:rgb(255,255,255);">Address <span style="color:#b3b3b3;font-size:14px;">(all fields are required)</span></h4> 					 
					<div class="qtg-text-decoration"></div>					
				</div>
				
				<div class="col-xs-12 nopadding" >						
					<div class="col-xs-12 col-sm-6 nopadding align-left contact-form-m">						
						<div class="row nomargin">
						  	<div class="col-xs-12">
							    <div class="form-group form-group">
									<select id="country" name="country" class="selectpicker form-control btn-big qtg-select" data-live-search="true" data-size="7" required>
									  	<?php include 'country-list.php'; ?>
									</select>
								</div>
							</div>
						</div>							
					</div>
					<div class="col-xs-12 col-sm-6 nopadding contact-form-m">
						<div class="col-xs-12 form-group">
							<input type="text" id="suburb" class="form-control mandatory" name="suburb" autocomplete="off" maxlength="200" placeholder="Suburb" required>
						</div>
					</div>						
				</div>	
				
				<div class="col-xs-12 nopadding" >						
					<div class="col-xs-12 col-sm-6 nopadding align-left contact-form-m" style="width:70%">
						<div class="col-xs-12 form-group">
							<input type="text" id="address" class="form-control mandatory" name="address" autocomplete="off" maxlength="200" placeholder="Address" required>
						</div>
					</div>
					<div class="col-xs-12 col-sm-6 nopadding contact-form-m" style="width:30%">
						<div class="col-xs-12 form-group">
							<input type="text" id="postcode" class="form-control mandatory " name="postcode" autocomplete="off" maxlength="200" placeholder="Postcode" required>
						</div>
					</div>
				</div>
				
				<div class="col-xs-12 description nopadding">
					<div class="col-xs-12">
						<div style="border-bottom:1px solid #cccccc;width:100%;height:1px;margin-top:20px;margin-bottom:20px">							
						</div>
					</div>
				</div>	

				<div class="col-xs-12">							
					<h4 style="color:rgb(255,255,255);">Payment</h4> 					 
					<div class="qtg-text-decoration"></div>					
				</div>	
				<div class="col-xs-12 nopadding" >
					<div class="row nomargin">
						<input type="hidden" id="paymentType" name="paymentType" value="1">
						<div class="col-xs-12 col-sm-6 send-but" style="margin-bottom:15px">
							<!--<button type="button" class="button_upload_first payment_button active" id="payment_button_credit_card" name="payment_button_credit_card" data-val="1" style="">
								<p>Credit Card</p>									
							</button>	-->							
						</div>
						<div class="col-xs-12 col-sm-6 send-but" style="margin-bottom:15px">
							<!-- <button type="button" class="button_upload_first payment_button " id="payment_button_bank_direct" name="payment_button_bank_direct" data-val="2" style="width:100%">
															<p><nobr>Bank Direct Debit</nobr></p>									
														</button>	 -->							
						</div>
					</div>

					<div class="block_payment_details block_credit_card ">
						<div class="col-xs-12  nopadding align-left contact-form-m">
							<div class="col-xs-12  form-group" style="margin: 9px 0;">
								<input id="visa" type="radio" name="creditCard" value="visa" checked="checked"><label for="visa"><img src="images/quiktrakglobal/visa.png" alt=""/></label>
								<input id="mc" type="radio" name="creditCard" value="mastercard"><label for="mc"><img src="images/quiktrakglobal/mastercard.png" alt=""/></label>
								<input id="amex" type="radio" name="creditCard" value="amex"><label for="amex"><img src="images/quiktrakglobal/american-express.png" alt=""/></label>	
							</div>	
						</div>
						
					</div>	
					
					<div class="block_payment_details block_credit_card1 ">
						<div class="col-xs-12 col-sm-6 nopadding align-left contact-form-m">
								
							<div class="col-xs-12 form-group">
								<input type="text" id="creditCardNumber" class="mandatory form-control" name="creditCardNumber" autocomplete="off" maxlength="200" placeholder="Credit card number" required>
							</div>			
							<div class="col-xs-12 form-group">
								<input type="text" id="cvv" class="mandatory form-control" name="cvv" autocomplete="off" maxlength="200" placeholder="CVV" required>
							</div>
							
						</div>
						<div class="col-xs-12 col-sm-6 nopadding contact-form-m" >	
							<div class="col-xs-12 form-group">
								<input type="text" id="expiryDate" class="mandatory form-control" name="expiryDate" autocomplete="off" maxlength="200" placeholder="Expiry date" required>
							</div>						
							<div class="col-xs-12 form-group">
								<input type="text" id="nameOnCard" class="mandatory form-control" name="nameOnCard" autocomplete="off" maxlength="200" placeholder="Name on card" required>
							</div>
							
						</div>
					</div>
					
					<div class="block_payment_details block_bank_direct hidden">
						<div class="col-xs-12 col-sm-6 nopadding align-left contact-form-m">							
							<div class="col-xs-12 form-group">
								<input type="text" id="bankAccountName" class="mandatory form-control" name="bankAccountName" autocomplete="off" maxlength="200" placeholder="Bank account name" >
							</div>
							<div class="col-xs-12 form-group">
								<input type="text" id="bankBSB" class="mandatory form-control" name="bankBSB" autocomplete="off" maxlength="200" placeholder="BSB" >
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 nopadding contact-form-m" >							
							<div class="col-xs-12 form-group">
								<input type="text" id="bankName" class="mandatory form-control" name="bankName" autocomplete="off" maxlength="200" placeholder="Bank name" >
							</div>
							<div class="col-xs-12 form-group">
								<input type="text" id="bankAccountNumber" class="mandatory form-control" name="bankAccountNumber" autocomplete="off" maxlength="200" placeholder="Account number" >
							</div>
						</div>
					</div>			
						
				</div>				
				<div class="col-xs-12 description nopadding">
					<div class="col-xs-12">
						<div style="border-bottom:1px solid #cccccc;width:100%;height:1px;margin-top:20px;margin-bottom:20px">
							
						</div>
					</div>
				</div>	
				
				<div class="col-xs-12">
					<h4 style="color:rgb(255,255,255);">Information <span style="color:#b3b3b3;font-size:14px;">(*mandatory fields)</span></h4>  
					 
					<div class="qtg-text-decoration"></div>
				</div>
				<div class="col-xs-12 nopadding" >						
					<div class="col-xs-12 col-sm-6 nopadding align-left contact-form-m">
						<div class="col-xs-12 form-group">
							<input type="email" id="email" class="mandatory form-control" data-error="That email address is invalid" name="email" autocomplete="off" maxlength="200" placeholder="Email*" required>
							<div class="help-block with-errors"></div>
						</div>
						<div class="col-xs-12 form-group">
							<input type="text" id="purchasedFrom" class="mandatory form-control" name="purchasedFrom" autocomplete="off" maxlength="200" placeholder="Purchased form">
						</div>
					</div>
					<div class="col-xs-12 col-sm-6 nopadding contact-form-m">
						<div class="col-xs-12 form-group">
							<input type="text" id="phone" class="mandatory only_numbers form-control" name="phone" autocomplete="off" maxlength="200" placeholder="Phone">
						</div>
						<div class="col-xs-12 form-group">
							<input type="text" id="datePurchased" class="datepicker form-control" name="datePurchased" placeholder="Date purchased" data-date-format="mm/dd/yyyy"> 
						</div>	
					</div>						
				</div>							
				<div class="col-xs-12 description nopadding">
					<div class="row nomargin">
					  	<div class="col-xs-12">
						    <div class="form-group">
								<select name="customerChoice" id="customerChoice" class="selectpicker form-control qtg-select" required>
									<option disabled value="00">- Customer choice of -</option>					
									<option value="3">Track Only Monthly</option>									
									<option value="1">Track Only Annual</option>
									<option value="5">Monitored Monthly</option>
									<option value="2">Monitored Annual</option>
								</select>
							</div>
						</div>
					</div>									
					<div class="col-xs-12">
						<div class="checkbox mt-10">								
							<label style="color:rgb(255,255,255);font-weight:400;font-size:0.8em;padding-left:0;cursor:pointer;" for="terms" class="no-padding">
								<input name="terms" id="terms" type="checkbox" >
								<span class="cr"><i class="cr-icon fa fa-check"></i></span>
								I agree to 
								<a href="legal.php" target="_blank" style="" >the terms and conditions</a>
							</label>
						</div>
						<div class="checkbox  ">								
							<label style="color:rgb(255,255,255);font-weight:400;font-size:0.8em;padding-left:0;cursor:pointer;" for="softwareLicense" class="no-padding">
								<input name="softwareLicense" id="softwareLicense" type="checkbox" >
								<span class="cr"><i class="cr-icon fa fa-check"></i></span>
								I agree to 
								<a href="legalSoftware.php" target="_blank" style="" >the software licensing terms</a>
							</label>
						</div>							
					</div>			
					<div class="col-xs-12 form-group">
						<textarea name="message" id="message" class="mandatory form-control" placeholder="Message" id="" cols="30" rows="10" maxlength="1000"></textarea>
					</div>						
				</div>
					
				<div class="col-xs-12 " >
					<button type="submit" class="button_send_second sendActivation" id="sendActivation" style="width:150px;padding-left:25px;padding-right:25px;">
						<p class="submitText"><nobr>send</nobr></p>
						<img alt="" src="images/ajax-loader-request.gif" class="preloader vis_hidden">
					</button>
					<div class="info"></div>
				</div>
						
			</form>		
		</div>



	<?php include 'footer.php'; ?>

	<script src="js/jquery-1.12.0.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	


	<!-- PAYMENT Change -->
	<script src="js/payment-type-change.js"></script>

	<script src="js/bootstrap-select.min.js"></script>

	<script src="js/bootstrap-datepicker.min.js"></script>
	<script>
		$('.datepicker').datepicker({		    
		    autoclose: true
		});
		$(".datepicker").datepicker("setDate", new Date);
	</script>
	

	<!-- FORM VALIDATION -->
	<script src="js/validator.min.js"></script>
	<script src="js/activation.js"></script>

	<!-- mask input -->
	<script src="js/maskedinput.js"></script>
	<script type="text/javascript">
	   	$(function($){
	  	 	$("#expiryDate").mask("99/99");
	  	 	$("#creditCardNumber").mask("9999 9999 9999 9999");
	   		
	   		$("#visa, #mc").change(function () {
		 		$("#creditCardNumber").mask("9999 9999 9999 9999");
		 		$("#cvv").mask("999")
		 	});
		 	
		 	$("#amex").change(function () {
		 		$("#creditCardNumber").mask("9999 9999 9999 999");
		 		$("#cvv").mask("9999")
		 	});

		 
		  $("#cvv").mask("999");
		  $("#year").mask("9999");
	   	});
	</script>

	
	<script>
		var mobile_flag;

		$(function() {
			var started_w = $(window).width();
			check_mobile(started_w);			
		});
		$(window).resize(function(){
			var window_w = $(window).width();
			check_mobile(window_w);
		});

		function check_mobile(w){
			if (w > 892) {
				mobile_flag = 0;
			}else{
				mobile_flag = 1;
			};
		}
		$('.scroll_to a').on('click', function () {
			if (mobile_flag) {
				$('button.navbar-toggle').click();
			};
		});
	</script>


	<script>
		var choice = GetURLParameter('s');		
		function GetURLParameter(sParam){
		    var sParameterName = '';
		    var sPageURL = window.location.search.substring(1);
		    var sURLVariables = sPageURL.split('&');
		    for (var i = 0; i < sURLVariables.length; i++)
		    {
		        sParameterName = sURLVariables[i].split('=');
		        if (sParameterName[0] == sParam)
		        {
		            return sParameterName[1];
		        }
		    }
		}
		
		if (choice>= 3 && choice <=5 ) {
			console.log(choice);
			$('#customerChoice').selectpicker('val', choice);
			//$("#customerChoice").val(choice);	
		}
	</script>
	

	<!-- HelloPreload -->
	<script type="text/javascript" src="js/helloPreloader.js"></script>
	<!--  HelloPreload -->


<?php include_once("google-analitycs.php") ?>
</body>
</html>