$(function(){

	$('.only_numbers').on('change keyup input click', function(){
	    if (this.value.match(/[^0-9]/g)) {
		     this.value = this.value.replace(/[^0-9]/g, '');
		}
	});

	filteremail  = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
	white_spaces = /([^\s])/;
	var salesWait = 1;


	$('.salesForm').validator().on('submit', function (e) {
		$('.salesInfo').empty();
		var error = 0;
	  	if (e.isDefaultPrevented()) {
	    	// handle the invalid form...
	    	console.log('has error');
	  	} else {
	  		e.preventDefault();
	    	// everything looks good!
	    	if (salesWait) {
	    		salesWait = 0;

	    		var USER_DATA = {};
				USER_DATA.name = $('#salesName').val();
				USER_DATA.phone = $('#salesPhone').val();
				USER_DATA.email = $('#salesEmail').val();
				USER_DATA.country = $('#salesCountry').val();
				USER_DATA.state = $('#salesState').val();
				USER_DATA.boat = 0;
				USER_DATA.car = 0;
				USER_DATA.machinery = 0;
				USER_DATA.other = 0;

			
				if($('#salesCheckBoat').prop('checked')==true){
					USER_DATA.boat = 1;
				}
				if($('#salesCheckCar').prop('checked')==true){
					USER_DATA.car = 1;
				}
				if($('#salesCheckMachinery').prop('checked')==true){
					USER_DATA.machinery = 1;
				}
				if($('#salesCheckOther').prop('checked')==true){
					USER_DATA.other = 1;
				}

				$.ajax({
						type: "POST",								
						url: "php/sales.php", 
						dataType: 'json',
						data: USER_DATA,
						async: true, 
						cache: false,
						beforeSend: function(){
							salesWait = 0;
							$('.salesSend').toggleClass('disabled');
							$('.salesSend .submitText, .salesSend .preloader').toggleClass('vis_hidden');				
						},	
						success: function(data){
							salesWait = 1;
							$('.salesSend').toggleClass('disabled');
							$('.salesSend .submitText, .salesSend .preloader').toggleClass('vis_hidden');
							console.log(data);
							var ReplyCode = data.ReplyCode;				
							var respondMsg = data.msg;

							switch (ReplyCode){
								case '9999': case '1005': case '1004': case '1002': case '1001': case '1000': 
									$('.salesInfo').html('<div class="with-errors">'+respondMsg+'</div>');
									break;

								case '000':								
									$('.salesInfo').html('<div class="success">'+respondMsg+'</div>');	
									$('#salesName').val(null);
									$('#salesPhone').val(null);
									$('#salesEmail').val(null);
									$('#salesState').val(null);
								
									
									break;
								default:
								$('.salesInfo').html('<div class="with-errors">Error, please try again later</div>');
							}												
						               			
						},
						error: function(XMLHttpRequest, textStatus, errorThrown){
							console.log(XMLHttpRequest);
							console.log(textStatus);
							console.log(errorThrown);
							$('.salesSend').toggleClass('disabled');
							$('.salesSend .submitText, .salesSend .preloader').toggleClass('vis_hidden');				
							$('.salesInfo').html('<div class="with-errors">Error, please try again later</div>');
							salesWait = 1;							        	
						}													
					});
	    	}
	    }

	  	return false;
	});
});


