var supportFormWait = 1;
$('.supportForm').validator().on('submit', function (e) {
	$('.supportInfo').empty();
	var error = 0;
  	if (e.isDefaultPrevented()) {
    	// handle the invalid form...
    	console.log('has error');
  	} else {
  		e.preventDefault();
    	// everything looks good!
    	if (supportFormWait) {
    		supportFormWait = 0;
    		
    		var USER_DATA = {};
			USER_DATA.Name = $('#supportName').val();
			USER_DATA.AccountName = $('#supportAccountName').val();
			USER_DATA.LoginName = $('#supportLoginName').val();
			USER_DATA.IMEI = $('#supportIMEI').val();
			USER_DATA.AssetName = $('#supportAssetName').val();
			USER_DATA.Email = $('#supportEmail').val();
			USER_DATA.Phone = $('#supportPhone').val();
			USER_DATA.Service = $('#supportService').val();
			USER_DATA.ServiceText = $('#supportService option:selected').text();
			//USER_DATA.ServicePlan = $('#supportServicePlan').val();
			//USER_DATA.ServicePlanText = $('#supportServicePlan option:selected').text();
			USER_DATA.TypeIssue = $('#supportTypeIssue').val();
			USER_DATA.TypeIssueText = $('#supportTypeIssue option:selected').text();
			USER_DATA.Notes = $('#supportNotes').val();

			USER_DATA.ServicePlanText = 'm2mglobaltech.com';
			USER_DATA.DeviceTypeText = "Don't know";

			$.ajax({
					type: "POST",								
					url: "php/support.php", 
					dataType: 'json',
					data: USER_DATA,
					async: true, 
					cache: false,
					beforeSend: function(){
						supportFormWait = 0;
						$('.supportSend').toggleClass('disabled');
						$('.supportSend .submitText, .supportSend .preloader').toggleClass('vis_hidden');				
					},	
					success: function(data){
						supportFormWait = 1;
						$('.supportSend').toggleClass('disabled');
						$('.supportSend .submitText, .supportSend .preloader').toggleClass('vis_hidden');
						console.log(data);
						var ReplyCode = data.ReplyCode;				
						var respondMsg = data.msg;

						switch (ReplyCode){
							case '9999': case '1005': case '1004': case '1002': case '1001': case '1000': 
								$('.supportInfo').html('<div class="with-errors">'+respondMsg+'</div>');
								break;

							case '000':								
								$('.supportInfo').html('<div class="success">'+respondMsg+'</div>');	
								$('#supportName').val(null);
								$('#supportAccountName').val(null);
								$('#supportLoginName').val(null);
								$('#supportIMEI').val(null);
								$('#supportAssetName').val(null);
								$('#supportEmail').val(null);
								$('#supportPhone').val(null);								
								$('#supportNotes').val(null);
								break;
							default:
							$('.supportInfo').html('<div class="with-errors">Error, please try again later</div>');
						}												
					               			
					},
					error: function(XMLHttpRequest, textStatus, errorThrown){
						console.log(XMLHttpRequest);
						console.log(textStatus);
						console.log(errorThrown);
						$('.supportSend').toggleClass('disabled');
						$('.supportSend .submitText, .supportSend .preloader').toggleClass('vis_hidden');				
						$('.supportInfo').html('<div class="with-errors">Error, please try again later</div>');
						supportFormWait = 1;							        	
					}													
				});
    	}
    }

  	return false;
});