<?php
    // My modifications to mailer script from:
    // http://blog.teamtreehouse.com/create-ajax-contact-form
    // Added input sanitizing to prevent injection

    // Only process POST reqeusts.
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
      function clean($value = "") {
          $value = trim($value);
          $value = stripslashes($value);
          $value = strip_tags($value);
          $value = htmlspecialchars($value);
          $value = str_replace(";", ",", $value);              
          return $value;
      }

      function check_length($value = "", $min, $max) {
          $result = (mb_strlen($value) < $min || mb_strlen($value) > $max);
          return !$result;
      }    
   
    $customerType = $_POST["customerType"];
     
    $FirstName = clean($_POST["firstName"]);      
    $LastName = clean($_POST["lastName"]);       
    $AccauntName = clean($_POST["accountName"]);

    $LoginName = clean($_POST["loginName"]);  
    $assetDitails = clean($_POST["assetsDetails"]);  

    $Imei = $_POST["imei"]; 
    $VehicleDevice = $_POST["vehicleDevice"];    
    $Make = $_POST["make"]; 
    $Model = $_POST["model"]; 
    $Color = $_POST["color"]; 
    $Year = $_POST["year"];   

    $Country = clean($_POST["country"]);      
    $Suburb = clean($_POST["suburb"]);     
    $Address = clean($_POST["address"]);
    $Postcode = clean($_POST["postcode"]);
    
    $CreditCard = clean($_POST["creditCard"]);      
    $CardNumber = clean($_POST["creditCardNumber"]);
    $CVV = clean($_POST["creditCVV"]);      
    $ExpiryDate = clean($_POST["expiryDate"]);      
    $NameOnCard = clean($_POST["nameOnCard"]);

    $BankAccountName = clean($_POST["bankAccountName"]);     
    $BankName = clean($_POST["bankBSB"]);     
    $BSB = clean($_POST["bankName"]);     
    $AccountNumber = clean($_POST["bankAccountNumber"]);

     $paymentType = $_POST["paymentType"];
     $paymentTypeText = $_POST["paymentTypeText"];

    $Email_val = clean($_POST["email"]);
    $Phone = clean($_POST["phone"]);
    $PurchsedFrom = clean($_POST["purchasedFrom"]);   
    $DatePurchased = $_POST["datePurchased"];
    $customerChoice = $_POST["customerChoice"];
    $customerChoiceText = $_POST["customerChoiceText"]; 

    $Message = clean($_POST["message"]);             
    //$Warranty = $_POST["warranty"]; 
    $DeviceCount = clean($_POST["deviceCount"]);
   

    if( !empty($FirstName) && !empty($LastName) && !empty($AccauntName) &&
       !empty($Country) && !empty($Suburb) && !empty($Address) && 
       !empty($Postcode) && !empty($Email_val) && !empty($customerChoiceText) ) {
      
      $Email = filter_var($Email_val, FILTER_VALIDATE_EMAIL);

      if(check_length($FirstName, 1, 50) && check_length($LastName, 1, 50) && 
        check_length($AccauntName, 1, 50) && check_length($Country, 1, 50) && check_length($Suburb, 1, 50) && 
        check_length($Address, 1, 50) && check_length($Postcode, 1, 50) && check_length($customerChoiceText, 1, 50) && $Email) {

        echo json_encode( array( 'ReplyCode' => '000', 'msg'=>'Thanks for choosing Quiktrak. Your device is now being activated.'), JSON_FORCE_OBJECT );
     
        
          $mailBody = "  
              <html>
                  <head>
                    <title>Activation QuikTrak Global</title>
                    <style type='text/css'>
                      table {
                       border-collapse: collapse;
                      }                        
                      td, th {
                       border: 1px solid #000;  
                       padding: 5px;            
                      } 
                      </style>
                  </head>
                  <body>";
                  if ($customerType==1) {
                    $mailBody .="<p>Activation QuikTrak Global New Customer</p>";
                  }else{
                    $mailBody .="<p>Activation QuikTrak Global Existing Customer</p>";
                  }
                    $mailBody .="
                    <table>
                      
                      <tr>
                        <th colspan='2'>USER</th>
                      </tr>
                      <tr>
                        <td>First Name:</td><td>".$FirstName."</td>
                      </tr>
                      <tr>
                        <td>Last Name:</td><td>".$LastName."</td>
                      </tr>
                      <tr>
                        <td>Account Name:</td><td>".$AccauntName."</td>
                      </tr>
                      <tr>
                        <th colspan='2'>DEVICE</th>
                      </tr>
                      ";                    
                      for ($i=1; $i <= $DeviceCount ; $i++) {                         
                        $mailBody .="
                        <tr>
                          <td>IMEI".$i.":</td><td>".$Imei[$i]."</td>
                        </tr>
                        <tr>
                          <td>Registration of Vehicle Device".$i.":</td><td>".$VehicleDevice[$i]."</td>
                        </tr>
                        <tr>
                          <td>Make".$i.":</td><td>".$Make[$i]."</td>
                        </tr>
                        <tr>
                          <td>Model".$i.":</td><td>".$Model[$i]."</td>
                        </tr>
                        <tr>
                          <td>Color".$i.":</td><td>".$Color[$i]."</td>
                        </tr>
                        <tr>
                          <td>Year".$i.":</td><td>".$Year[$i]."</td>
                        </tr>
                        ";
                      }                      
                      $mailBody .=" 
                      <tr>
                        <th colspan='2'>ADDRESS</th>
                      </tr>
                      <tr>     
                        <td>Country:</td><td>".$Country."</td>
                      </tr>  
                      <tr>     
                        <td>Suburb:</td><td>".$Suburb."</td>
                      </tr> 
                      <tr>     
                        <td>Address:</td><td>".$Address."</td>
                      </tr>
                      <tr>     
                        <td>Postcode:</td><td>".$Postcode."</td>
                      </tr>                     
                     <tr>
                        <th colspan='2'>PAYMENT</th>
                      </tr>";
                      if( $paymentType == 1 ){                        
                        $mailBody .=" 
                        <tr>     
                          <td>Credit Card:</td><td>".$CreditCard."</td>
                        </tr>
                        <tr>     
                          <td>Credit card number:</td><td>".$CardNumber."</td>
                        </tr>  
                        <tr>     
                          <td>CVV:</td><td>".$CVV."</td>
                        </tr>  						
                        <tr>
                          <td>Expiry date:</td><td>".$ExpiryDate."</td>
                        </tr>
                        <tr>
                          <td>Name on card:</td><td>".$NameOnCard."</td>
                        </tr>";
                      }else{                       
                        $mailBody .="
                        <tr>     
                          <td>Bank Account Name:</td><td>".$BankAccountName."</td>
                        </tr>
                        <tr>     
                          <td>Bank Name:</td><td>".$BankName."</td>
                        </tr>   
                        <tr>
                          <td>BSB:</td><td>".$BSB."</td>
                        </tr>
                        <tr>
                          <td>Account Number:</td><td>".$AccountNumber."</td>
                        </tr>";
                      }
                      $mailBody .="
                      <tr>
                        <th colspan='2'>INFORMATION</th>
                      </tr>
                      <tr>
                        <td>Email:</td><td>".$Email."</td>
                      </tr>
                      <tr>
                        <td>Phone:</td><td>".$Phone."</td>
                      </tr>
                      <tr>
                        <td>Purchased From:</td><td>".$PurchsedFrom."</td>
                      </tr>
                      <tr>
                        <td>Date Purchased:</td><td>".$DatePurchased."</td>
                      </tr>
                      <tr>
                        <td>Customer choice of:</td><td>".$customerChoiceText."</td>
                      </tr>                      
                      <tr>
                        <td>Message:</td><td>".$Message."</td>
                      </tr>
                    </table>
                  </body>
                  </html>"; 
        
require_once('PHPMailer_5.2.4/class.phpmailer.php');
           
        $mail = new PHPMailer(true); // the true param means it will throw exceptions on errors, which we need to catch

        $mail->IsSMTP(); // telling the class to use SMTP

       
          $mail = new PHPMailer; // the true param means it will throw exceptions on errors, which we need to catch
          $mail->IsSMTP(); // telling the class to use SMTP
          $mail->Host       = "mail.ukraine.com.ua"; // SMTP server   
          $mail->SMTPAuth   = true;                  // enable SMTP authentication
          $mail->SMTPSecure = "ssl";                 // sets the prefix to the servier
          $mail->Host       = "mail.ukraine.com.ua";      // sets GMAIL as the SMTP server
          $mail->Port       = 465;                   // set the SMTP port for the GMAIL server
          $mail->Username   = "noreply@quiktrak.eu";  // GMAIL username
          $mail->Password   = "iUDaZ1b09Av5";            // GMAIL password
 
      //$mail->AddAddress('activations@quiktrakglobal.com');   
      //$mail->AddAddress('accounts@quiktrakglobal.com');  
      //$mail->AddAddress('sales@quiktrakglobal.com'); 
      //$mail->AddAddress('vanessa@quiktrakglobal.com');
      //$mail->AddAddress('mark@sinopacific.co'); 
      
          $mail->AddAddress('vanessa@quiktrakglobal.com');
          $mail->AddAddress('Mark@sinopacific.co');
          $mail->AddAddress('Accounts@quiktrakglobal.com');
                       
        
        //  $mail->AddAddress('dmutro.satur@sinopacificukraine.com');
        
          $mail->AddBCC('noreply@quiktrak.eu');
          $mail->SetFrom('noreply@quiktrak.eu', 'Activation Nonautomated - QuikTrak Global');
          $mail->Subject = 'Activation Nonautomated - QuikTrak Global';
          $mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; // optional - MsgHTML will create an alternate automatically
          $mail->MsgHTML($mailBody);
          $mail->Send();         
        
    
  

// write all data to the log_activation.csv
          $today=date("Y-m-d");
          $time=date("H:i:s");
          $file = "../logs/log_activation.csv";


          if(file_exists($file)){$fp = fopen("$file","a")or die("файл не открылся");}else{
            $fp = fopen("$file","w") or die("файл не создался");
          }
          $Message=strip_tags($Message);
          $Message=str_replace(array("\r","\n","\r\n","<br>","<br/>","<br />")," ",$Message);  
          $assetDitails=strip_tags($assetDitails);
          $assetDitails=str_replace(array("\r","\n","\r\n","<br>","<br/>","<br />")," ",$assetDitails);         
           if($paymentType == 1 ){
                $txt = $today.";".$time.";".$LoginName.";".$FirstName.";".$LastName.";".$AccauntName.";".$assetDitails.";".$Country.";"
                .$Suburb.";".$Address.";".$Postcode.";".$CreditCard.";".$CardNumber.";".$CVV.";".$ExpiryDate.";".$NameOnCard.";".$Email.";"
                .$Phone.";".$PurchsedFrom.";".$DatePurchased.";".$customerChoiceText.";".$Warranty.";".$Message;
                for ($i=1; $i <= $DeviceCount ; $i++) {
                  $txt .= ";".$Imei[$i].";".$VehicleDevice[$i].";".$Make[$i].";".$Model[$i].";".$Color[$i].";".$Year[$i];
                }
                $txt .= ";\r\n"; // Исходная строка
            }else {
                $txt = $today.";".$time.";".$LoginName.";".$FirstName.";".$LastName.";".$AccauntName.";".$assetDitails.";".$Country.";"
                .$Suburb.";".$Address.";".$Postcode.";".$BankAccountName.";".$BankName.";".$BSB.";".$AccountNumber.";".$Email.";"
                .$Phone.";".$PurchsedFrom.";".$DatePurchased.";".$customerChoiceText.";".$Warranty.";".$Message;
                for ($i=1; $i <= $DeviceCount ; $i++) {
                  $txt .= ";".$Imei[$i].";".$VehicleDevice[$i].";".$Make[$i].";".$Model[$i].";".$Color[$i].";".$Year[$i];
                }
                $txt .= ";\r\n"; // Исходная строка
            }
            /*$txt = $today.";".$time.";".$LoginName.";".$FirstName.";".$LastName.";".$AccauntName.";".$assetDitails.";".$Country.";"
                .$Suburb.";".$Address.";".$Postcode.";".$Email.";".$Phone.";".$PurchsedFrom.";".$DatePurchased.";".$customerChoiceText.";".$Warranty.";".$Message;
                for ($i=1; $i <= $DeviceCount ; $i++) {
                  $txt .= ";".$Imei[$i].";".$VehicleDevice[$i];
                }
                $txt .= ";\r\n"; // Исходная строка*/
          $csv = fwrite($fp, $txt); // Запись в файл          
          fclose($fp); //Закрытие файла

        

        if (is_file(realpath('../system/index.php'))) {
           require_once(realpath('../system/index.php'));
        }

        $project_type_number = 19;     
        $purchsed_date_conv = strtotime($DatePurchased);   // convert date to int format

        $sql = "INSERT INTO upgrades (project_type_number,upgrade_date,first_name,last_name,account_name,login_name,asset_ditails,country,suburb,address,postcode,payment_type,email,phone,purchsed_from,purchsed_date,chosen_plan,chosen_plan_type,warranty,customer_message) VALUES ( '".$project_type_number."','".time()."','".$FirstName."','".$LastName."','".$AccauntName."','".$LoginName."','".$assetDitails."','".$Country."','".$Suburb."','".$Address."','".$Postcode."','".$paymentType."','".$Email."','".$Phone."','".$PurchsedFrom."','".$purchsed_date_conv."','".$customerChoiceText."','".$customerChoice."','".$Warranty."','".$Message."' )";

        $query = $db->query($sql);
        $UserId = $db->getLastId();  //get current user id

        $sql_devices =  "INSERT INTO upgrades_devices VALUES ";
          for ($i=1; $i<=$DeviceCount ; $i++){
            $sql_devices .= " ('".$UserId."','".$Imei[$i]."','".$VehicleDevice[$i]."'),";
          }
        $sql_devices = substr($sql_devices, 0, -1);  // delete last character ','          
        $query = $db->query($sql_devices);    // seve user devices using user id in database 
        
       if ($paymentType == 1) {
          $sql_payment_type = "INSERT INTO upgrades_credit_cards VALUES ('".$UserId."','".$CreditCard."','".$CardNumber."','".$ExpiryDate."','".$NameOnCard."' )";           
        }else{
          $sql_payment_type = "INSERT INTO upgrades_bank_direct VALUES ('".$UserId."','".$BankAccountName."','".$BankName."','".$BSB."','".$AccountNumber."' )";           
        }
        $query = $db->query($sql_payment_type);    // seve user devices using user id in database 



        }else{
        echo json_encode( array( 'ReplyCode' => '1001', 'msg'=>'Input Data Incorrect'), JSON_FORCE_OBJECT );
      }
    }else{
      echo json_encode( array( 'ReplyCode' => '1000', 'msg'=>'Fill in the mandatory fields'), JSON_FORCE_OBJECT );
    }
  }
?>
