<?php
/**
 * Created by PhpStorm.
 * User: dem
 * Date: 4/18/16
 * Time: 12:45 PM
 */

// Configuration
if (is_file(__DIR__.'/config.php')) {
    require_once(__DIR__.'/config.php');
}

function library($class) {
    $file = DIR_LIBRARY . '/' . str_replace('\\', '/', strtolower($class)) . '.php';

    if (is_file($file)) {
        include_once($file);
        return true;
    } else {
        return false;
    }
}

spl_autoload_register('library');
spl_autoload_extensions('.php');
/**
 * Database class [DB].
 * For simple request use $db->query(...)
 * For escape use $db->escape(...)
 */
$db = new DB(DB_DRIVER,DB_HOSTNAME,DB_USERNAME,DB_PASSWORD,DB_DATABASE,DB_PORT);