<?php


// if (isset($_GET['lang'])) {
// 	$userLanguage = $_GET['lang'];
// } else {
// 	$userLanguage = 'en';
// }
// include  'php/' . $userLanguage . '.php';

session_start();

if (isset($_GET['lang'])) {
    $_SESSION['lang'] = $_GET['lang'];
} elseif (!isset($_SESSION['lang'])) {
    $_SESSION['lang'] = 'en';  
}

$userLanguage = $_SESSION['lang'];
include 'php/' . $userLanguage . '.php';


switch ($userLanguage) {
	case 'ua':
			$languageText = 'Українська';
			break;
	case 'esp':
			$languageText = 'español';
			break;
	case 'ru	':
				$languageText = 'Русский';
				break;
	case 'en':
		default:
				$languageText = 'English';
				break;
}
?>

<!DOCTYPE html>
<html lang="en">

<head>

	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width">
	<link rel="shortcut icon" href="images/favicon.png" type="image/x-icon">
	<link rel="stylesheet" type="text/css" href="css/normalize.css" />
	<link rel="stylesheet" type="text/css" href="css/font-awesome.min.css" />
	<link rel="stylesheet" type="text/css" href="css/map-pin.css" />
	<link rel="stylesheet" type="text/css" href="css/fonts.css" />
	<link rel="stylesheet" type="text/css" href="css/animate.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap.css" />
	<link rel="stylesheet" type="text/css" href="css/bootstrap-theme.css" />
	<link rel="stylesheet" type="text/css" href="css/style.css?v=<?php echo filemtime('css/style.css'); ?>" />
	<!--checkboxes styles-->
	<!-- <link rel="stylesheet" type="text/css" href="css/checkboxes.css" /> -->
	<link rel="stylesheet" type="text/css" href="css/bootstrap-checkbox.css" />
	<link rel="stylesheet" href="css/bootstrap-select.min.css">
	<!--slick slider styles-->
	<link rel="stylesheet" type="text/css" href="css/slick.css" />
	<link rel="stylesheet" type="text/css" href="css/slick-theme.css" />
	<link rel="stylesheet" type="text/css" href="css/slick_corrections.css" />

	<link rel="stylesheet" type="text/css" href="css/qtg-style-activation.css" />






	<link rel="stylesheet" type="text/css" href="css/qtg-style.css" />


	<!--modal-slider-->
	<link rel="stylesheet" type="text/css" href="css/modal.css" />

	<?php
	if ($userLanguage !== "en") {
		echo '<link rel="stylesheet" type="text/css" href="css/qtg-style_ua.css" />';
	}
	?>
	<title>QuikTrak Global</title>
</head>

<body>



	<?php include 'header.php'; ?>



	<div class="container  modal-donate-now">
		<div id="modalDonate" class="modal fade">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-body">
						<div class="modal-caption">
							<div class="step-1">

								<div class="col-xs-12">
									<h3><?php echo $lang['ukraine_update']; ?></h3>
									<div class="qtg-text-decoration"></div>
								</div>
								<!-- <div class="col-xs-12 text-ident"> -->

								<div class="col-xs-12 ">

									<p><?php echo $lang['as_many_of_you_may']; ?> </p>
									<p><?php echo $lang['today_ukraine_is_involved_in']; ?></p>
									<p><?php echo $lang['this_war_has_displaced_more']; ?></p>
									<p><?php echo $lang['whilst_we_continue_to_provide']; ?></p>

								</div>


								<div class="col-xs-12 ">


									<div class="form-group">
										<div class="checkbox">
											<label for="modalDonateCheckbox" class="" style="padding-left:0px">
												<input class="security-checkbox" id="modalDonateCheckbox" type="checkbox">
												<span class="cr"><i class="cr-icon fa fa-check"></i></span>
												<?php echo $lang['dont_show_again']; ?>
											</label>
										</div>
									</div>
								</div>


								<div class="col-xs-12   " style="  ">
									<button onclick="toDonate()" class="button_send_second button_send w-100">
										<p class="submitText"><?php echo $lang['donate_now']; ?></p>
										<img alt="" src="images/quiktrakglobal/ajax-loader.gif" class="preloader vis_hidden">
									</button>

								</div>

							</div>




							<div class="step-2 display-none">

								<div class="col-xs-12">
									<h3><?php echo $lang['donate']; ?></h3>
									<div class="qtg-text-decoration"></div>
								</div>



								<div class="col-xs-12 ">

									<p><?php echo $lang['choose_the_usd_amount_to']; ?></p>
									<div class="input-container">
										<a href='https://buy.stripe.com/6oE5nif0Xazwd8c5kl' target="_blank" class="text-center button_send_second button_send">$20.00</a>
									</div>
									<div class="input-container">
										<a href='https://buy.stripe.com/bIY1725qnbDA9W03ce' target="_blank" class="text-center button_send_second button_send">$50.00</a>
									</div>
									<div class="input-container">
										<a href='https://buy.stripe.com/6oEcPKg51cHE7NSaEE' target="_blank" class="text-center button_send_second button_send">$100.00</a>
									</div>
									<div class="input-container">
										<a href='https://buy.stripe.com/9AQdTO3ifbDAgkofZ1' target="_blank" class="text-center button_send_second button_send">$200.00</a>
									</div>
									<div class="input-container">
										<a href='https://buy.stripe.com/5kA02Y1a7230gkoaEI' target="_blank" class="text-center button_send_second button_send">$500.00</a>
									</div>

									<div id="error-message"></div>


								</div>




							</div>



							<button type="button" class="close close-modal-donate modal-closer" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">
									<img src="images/Close.png">
								</span>
							</button>
						</div>
					</div><!-- /.modal-content -->
				</div><!-- /.modal-dialog -->
			</div><!-- /.modal -->
		</div><!-- /.container -->
	</div>


	<div class="container modal-enquire-now">
		<div class="modal fade" id="lightbox1">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-body">
						<div class="modal-caption">

							<form class="salesForm1" id="salesForm1" name="salesForm1">

								<div class="col-xs-12">
									<h4><?php echo $lang['services_enquiry']; ?></h4>
									<div class="qtg-text-decoration"></div>
								</div>
								<!-- <div class="col-xs-12 text-ident"> -->

								<div class="col-xs-12 ">
									<h5><?php echo $lang['enter_your_details']; ?></h5>
									<div class="col-xs-12  nopadding align-left contact-form-m" style="">
										<div class="col-xs-12 nopadding dscrp mb-15">
											<?php echo $lang['please_fill_out_the_contact']; ?>
										</div>
										<div class="col-xs-12 col-md-6 nopadding form-group">
											<input type="text" id="salesName1" class="form-control" name="salesName1" autocomplete="off" maxlength="200" placeholder="<?php echo $lang['name']; ?>" required>
										</div>
										<div class="col-xs-12 col-md-6 form-group salesEmailWrapper">
											<input type="email" id="salesEmail1" class="form-control" name="salesEmail1" autocomplete="off" maxlength="200" placeholder="E-mail" required>
										</div>
										<div class="col-xs-12 col-md-6 nopadding form-group">
											<input type="text" id="salesPhone1" class="form-control only_numbers" name="salesPhone1" autocomplete="off" maxlength="200" placeholder="<?php echo $lang['phone']; ?>" required>
										</div>
										<div class="col-xs-12 col-md-6 form-group salesEmailWrapper">
											<div class="row nomargin">
												<div class="form-group form-group">
													<select id="salesCountry1" name="salesCountry1" class="selectpicker form-control btn-big qtg-select" data-live-search="true" data-size="7" required>
														<?php include 'country-list.php'; ?>
													</select>
												</div>
											</div>
										</div>
										<div class="col-xs-12 col-md-6 nopadding form-group">
											<input type="text" id="salesState1" class="form-control" name="salesState1" autocomplete="off" maxlength="200" placeholder="State / Province" required>
										</div>
										<div class="col-xs-12 col-md-6 form-group salesEmailWrapper">
											<div class="row nomargin">
												<div class="form-group form-group">
													<select id="salesPlan1" name="salesPlan1" class="selectpicker form-control btn-big qtg-select" data-live-search="false" data-size="7" required>
														<option value="trackonly"><?php echo $lang['track_only']; ?></option>
														<option value="monitored"><?php echo $lang['monitored']; ?></option>
														<option value="loc8"><?php echo $lang['loc8_1']; ?></option>
													</select>
												</div>
											</div>
										</div>




									</div>

									<div class="col-xs-12 send-but" style="margin-left:-15px; ">
										<button type="submit" class="button_send_second button_send sales<?php echo $lang['send']; ?>" id="sales<?php echo $lang['send']; ?>1">
											<p class="submitText"><?php echo $lang['enquire_now']; ?></p>
											<img alt="" src="images/quiktrakglobal/ajax-loader.gif" class="preloader vis_hidden">
										</button>
										<div class="salesInfo1" style="margin-top:15px"></div>
									</div>
								</div>
								<!--/contact form-->
							</form>

							<button type="button" class="close modal-closer" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">
									<img src="images/Close.png">
								</span>
							</button>
						</div>
					</div><!-- /.modal-content -->
				</div><!-- /.modal-dialog -->
			</div><!-- /.modal -->
		</div><!-- /.container -->
	</div>

	<section class="bg_block_one qtg_bg_block_one" id="bg_block_one">
		<div class="container">
			<div class="col-xs-12 block_one_caption">
				<div class="caption" style="padding-top:70px">

					<div style="color:rgb(255,255,255);font-size:1.6em;font-weight:lighter"><?php echo $lang['thank_you_for_visiting']; ?> <b><?php echo $lang['quiktrak_global']; ?></b><br><?php echo $lang['your_complete_gps_location_tracking']; ?></div>
					<div class="qtg-text-decoration"></div>

					<div class="" style="color:rgb(255,255,255);font-weight:300px"><?php echo $lang['for_all_your_tracking_fleet']; ?></div>
				</div>
			</div>
		</div>
	</section>

	<section class="bg_block_two bg_block_fon" id="bg_block_two">
		<div class="container">
			<div class="col-xs-12"><br><br>
				<h4><?php echo $lang['contacts']; ?></h4>
				<div class="qtg-text-decoration"></div>
			</div>
			<div class="col-xs-12 col-sm-9" style="margin-bottom:45px"><?php echo $lang['quiktrak_global_has_offices_in']; ?>
			</div>
			<div class="col-xs-12 col-sm-3">
				<div class="form-group">
					<select name="map-country-select" id="map-country-select" class="selectpicker form-control qtg-select" title="<?php echo $lang['select_country']; ?>" data-size="6">
						<optgroup label="<?php echo $lang['australia']; ?>">  
							<option value="melbourne"><?php echo $lang['melbourne']; ?></option>
							<option value="perth"><?php echo $lang['perth']; ?></option>
							<option value="sydney"><?php echo $lang['sydney']; ?></option>
						</optgroup>
						<option value="canada"><?php echo $lang['canada']; ?></option>
						<option value="chile"><?php echo $lang['chile']; ?></option>
						<option value="china"><?php echo $lang['china']; ?></option>
						<option value="colombia"><?php echo $lang['colombia']; ?></option>
						<option value="hongKong"><?php echo $lang['hong_kong']; ?></option>
						<option value="mexico"><?php echo $lang['mexico']; ?></option>
						<option value="peru"><?php echo $lang['peru']; ?></option>
						<option value="safrica"><?php echo $lang['south_africa']; ?></option>
						<!-- <option value="equador">Equador</option> -->
						<option value="spain"><?php echo $lang['spain']; ?></option>
						<!-- <option value="italy">Italy</option> -->
						<!-- <option value="thailand">Thailand</option> -->
						<option value="uae"><?php echo $lang['united_arab_emirates']; ?></option>
						<option value="england"><?php echo $lang['england']; ?></option>
						<optgroup label="Ukraine">
							<option value="dnipro"><?php echo $lang['dnipro']; ?></option>
							<option value="kiev"><?php echo $lang['kiev']; ?></option>
						</optgroup>
						<option value="usa"><?php echo $lang['usa']; ?></option>
						<option value="zambia"><?php echo $lang['zambia']; ?></option>
						<option value="auckland"><?php echo $lang['new_zealand']; ?></option>
						<option value="moscow"><?php echo $lang['russia']; ?></option>
					</select>
				</div>
			</div>


			<div class="col-xs-12" style="margin-top:45px;">
				<div class="map_container">
					<img class="hidden-xs " src="images/quiktrakglobal/map.png" class="qtg-map">

					<div class="pin pin-canada" data-select="canada">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['canada']; ?>, <?php echo $lang['vancouver']; ?></div>
								<div class="divider"></div>
								<ul>
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
									<!--<li>tel. +1 800 678 4173</li>-->
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-usa" data-select="usa">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['usa']; ?>, <?php echo $lang['fort_lauderdale_florida']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrakglobal.com/" target="_blank">quiktrakglobal.com</a></li>
									<li>usa@quiktrakglobal.com</li> -->
									<!--<li>tel. +1 800 678 4173</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-mexico" data-select="mexico">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['mexico']; ?>, <?php echo $lang['mexico']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrakglobal.com/" target="_blank">quiktrakglobal.com</a></li>
									<li>mexico@quiktrakglobal.com</li> -->
									<!--<li>tel. +1 800 678 4173</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-colombia" data-select="colombia">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['colombia']; ?>, <?php echo $lang['cali_and_bogota']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrakcolombia.com/" target="_blank">quiktrakcolombia.com</a></li>
									<li>colombia@quiktrakglobal.com</li> -->
									<!--<li>tel. + 57 2 382 7107</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- <div class="pin pin-equador" data-select="equador">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption">Equador</div>
								<div class="divider"></div>
								<ul>
									<li><a href="http://quiktrakecuador.com/" target="_blank">quiktrakecuador.com</a></li>
									<li>equador@quiktrakglobal.com</li>
									<li>tel. +1 800 678 4173</li>
								</ul>
							</div>
						</div>
					</div> -->
					<div class="pin pin-peru" data-select="peru">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['peru']; ?>, <?php echo $lang['lima']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrakperu.com/" target="_blank">quiktrakperu.com</a></li>
									<li>peru@quiktrakglobal.com</li> -->
									<!--<li>tel. +1 800 678 4173</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-chile" data-select="chile">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['chile']; ?>, <?php echo $lang['santiago_and_antofagasta']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrakchile.com/" target="_blank">quiktrakchile.com</a></li>
									<li>chile@quiktrakglobal.com</li> -->
									<!--<li>tel. +56 (2) 22051827</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-england" data-select="england">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['london_and_york']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrak.eu/" target="_blank">quiktrak.eu</a></li>
									<li>UK@quiktrakglobal.com</li> -->
									<!--<li>tel. +1 800 678 4173</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-spain" data-select="spain">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['spain']; ?>, <?php echo $lang['barcelona']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrak.eu/" target="_blank">quiktrak.eu</a></li>
									<li>spain@quiktrakglobal.com</li> -->
									<!--<li>tel. +1 800 678 4173</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- <div class="pin pin-italy" data-select="italy">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption">Italy</div>
								<div class="divider"></div>
								<ul>
									<li><a href="http://quiktrak.eu/" target="_blank">quiktrak.eu</a></li>
									<li>italy@quiktrakglobal.com</li>
									<li>tel. +1 800 678 4173</li>
								</ul>
							</div>
						</div>
					</div> -->
					<div class="pin pin-kiev" data-select="kiev">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['ukraine']; ?>, <?php echo $lang['kiev']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="https://quiktrakukraine.com/" target="_blank">quiktrakukraine.com</a></li>
									<li>ukraine@quiktrakglobal.com</li> -->
									<!--<li>tel. +38 050 588 7130</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-dnipro" data-select="dnipro">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['ukraine']; ?>, <?php echo $lang['dnipro']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="https://quiktrakukraine.com/" target="_blank">quiktrakukraine.com</a></li>
									<li>ukraine@quiktrakglobal.com</li> -->
									<!--<li>tel. +38 050 588 7130</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-zambia" data-select="zambia">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['zambia']; ?>, <?php echo $lang['lusaka']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrakzambia.com/" target="_blank">quiktrakzambia.com</a></li>
									<li>zambia@quiktrakglobal.com</li> -->
									<!--<li>tel. +260 969 818 088</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-africa" data-select="safrica">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['south_africa']; ?>, <?php echo $lang['johannesburg']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrakzambia.com/" target="_blank">quiktrakzambia.com</a></li>
									<li>africa@quiktrakglobal.com</li> -->
									<!--<li>tel. +260 969 818 088</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-oae" data-select="uae">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['UAE_dubai']; ?> </div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrakglobal.com/" target="_blank">quiktrakglobal.com</a></li>
									<li>uae@quiktrakglobal.com</li> -->
									<!--<li>tel. +260 969 818 088</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-dalian" data-select="china">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['china']; ?>, <?php echo $lang['dalian_and_shenzhen']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrak.net/" target="_blank">quiktrak.net</a></li>
									<li>china@quiktrakglobal.com</li> -->
									<!--<li>tel. +56 229382284</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-changzhou" data-select="hongKong">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['hong_kong']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrak.net/" target="_blank">quiktrak.net</a></li>
									<li>hongkong@quiktrakglobal.com</li> -->
									<!--<li>tel. +56 229382284</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- <div class="pin pin-thailand" data-select="thailand">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption">Thailand</div>
								<div class="divider"></div>
								<ul>
									<li><a href="http://quiktrak.co/" target="_blank">quiktrak.co</a></li>
									<li>thailand@quiktrakglobal.com</li>
									<li>tel. +86 755 2683 3660</li>
								</ul>
							</div>
						</div>
					</div> -->
					<div class="pin pin-perth" data-select="perth">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['australia']; ?>, <?php echo $lang['perth']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrak.com.au/" target="_blank">quiktrak.com.au</a></li>
									<li>australia@quiktrakglobal.com</li> -->
									<!--<li>tel. +61 8 9467 7181</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-melbourne" data-select="melbourne">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['australia']; ?>, <?php echo $lang['melbourne']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrak.com.au/" target="_blank">quiktrak.com.au</a></li>
									<li>australia@quiktrakglobal.com</li> -->
									<!--<li>tel. +61 8 9467 7181</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-sydney" data-select="sydney">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['australia']; ?>, <?php echo $lang['sydney']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrak.com.au/" target="_blank">quiktrak.com.au</a></li>
									<li>australia@quiktrakglobal.com</li> -->
									<!--<li>tel. +61 8 9467 7181</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="pin pin-auckland" data-select="auckland">
						<div class="pin-container ">
							<span class="icon icon-pin"></span>
							<div class="pin-details animated fadeIn">
								<div class="pin-details-caption"><?php echo $lang['auckland']; ?>, <?php echo $lang['new_zealand']; ?></div>
								<div class="divider"></div>
								<ul>
									<!-- <li><a href="http://quiktrak.com.au/" target="_blank">quiktrak.com.au</a></li>
									<li>nz@quiktrakglobal.com</li> -->
									<!--<li>tel. +61 8 9467 7181</li>-->
									<li><a href="https://www.quiktrak.com.au/" target="_blank">www.quiktrak.com.au</a></li>
									<li>mark@sinopacific.co</li>
								</ul>
							</div>
						</div>
					</div>
				 

				</div>

			</div>

			<!--<img src="images/quiktrakglobal/map.png" class="qtg-map">-->
		</div>
	</section>

	<section class="bg_block_one qtg_bg_block_free" id="bg_block_one">
		<div class="container">


			<div class="block_demo">
				<div class="block_demo__title" style=""><b><?php echo $lang['want_to_see_how_it']; ?></b></div>
				<div  class="block_demo__specspan" style="color:rgb(255,255,255);font-weight:300;letter-spacing: .1em;display: inline-block;vertical-align: middle;"><?php echo $lang['just_view_our']; ?></div>
				<div class="red-line"></div>
				<div class="free" style=""><b><?php echo $lang['free']; ?></b></div>
				<div class="red-line red-line-second"></div>
				<div  class="block_demo__specspan" style="color:rgb(255,255,255);font-weight:300; letter-spacing: .1em;display: inline-block;vertical-align: middle;"><?php echo $lang['demo_today']; ?></div>
				<div class="mt-10 pl-5">
					<a target="_blank" href="https://cartrack.co/" class="button_send_second demo_button">
						<p><?php echo $lang['demo']; ?></p>
					</a>
				</div>
			</div>

		</div>
	</section>






	<section class="bg_block_three bg_block_fon" id="bg_block_three">
		<div class="container">
			<div class="col-xs-12 col-md-4 col-lg-3">
				<h4><?php echo $lang['about_us']; ?></h4>
				<div class="qtg-text-decoration"></div>
			</div>
			<div class="col-xs-12 text-ident">

				<div class="row">
					<div class="col-xs-12 col-sm-6 align-left">
						<p class="margin-bottom-0"><?php echo $lang['personnel_come_from_a_wide']; ?></p>
						<p class="margin-bottom-0" style=" margin-top: 5px;">
							<b><?php echo $lang['quiktrak_2']; ?></b> <?php echo $lang['continues_to_strive_to_be']; ?>
						</p>
						<p class="margin-bottom-0" style=" margin-top: 5px;">
							<b><?php echo $lang['our_mission']; ?></b> <?php echo $lang['is_to_provide_market_leading']; ?>
						</p>

					</div>
					<div class="hidden-xs col-sm-6 align-right">
						<img src="images/quiktrakglobal/aboutus.png" alt="">
					</div>
				</div>

			</div>
		</div>
	</section>

	<div class="container modal-presentation">
		<div class="modal fade" id="presentation-p">
			<div class="modal-dialog">
				<iframe width="100%" height="625" src="https://www.youtube.com/embed/Ao35g3ip39w" frameborder="0" allowfullscreen></iframe>
			</div><!-- /.modal -->
		</div><!-- /.container -->
	</div>
	<div class="container modal-presentation">
		<div class="modal fade" id="presentation-s">
			<div class="modal-dialog">
				<iframe width="100%" height="625" src="https://www.youtube.com/embed/TJ8BOUb-YDw" frameborder="0" allowfullscreen></iframe>
			</div><!-- /.modal -->
		</div><!-- /.container -->
	</div>
	<div class="container modal-presentation">
		<div class="modal fade" id="presentation-qp">
			<div class="modal-dialog">
				<iframe width="100%" height="625" src="https://www.youtube.com/embed/s5pZZV1ZboU" frameborder="0" allowfullscreen></iframe>
			</div><!-- /.modal -->
		</div><!-- /.container -->
	</div>
	<div class="container modal-presentation">
		<div class="modal fade" id="presentation-is">
			<div class="modal-dialog">
				<iframe width="100%" height="625" src="https://www.youtube.com/embed/DHnx-T-wM04" frameborder="0" allowfullscreen></iframe>
			</div><!-- /.modal -->
		</div><!-- /.container -->
	</div>

	<section class="bg_block_eight" id="bg_block_four">
		<div class="container">
			<div class="col-xs-12">
				<h4 style="color:rgb(255,255,255);"><?php echo $lang['distributor_program']; ?></h4>
				<div class="qtg-text-decoration"></div>
			</div>



			<form action="php/request.php" enctype="multipart/form-data" id="requestForm" name="requestForm">
				<div class="col-xs-12 col-sm-6 col-md-4 checkboxes nopadding">
					<div class="col-xs-12 font bold align-left font-size-16" style="color:rgb(255,255,255);font-size:1em">
						<?php echo $lang['upload_your_company_logo']; ?>
					</div>
					<div class="upload-logo-button button_upload_first" style="padding:0px;margin-top:20px">
						<div style="font-size: 18px;font-family: 'OpenSans-Bold';color: #fff;padding-top:5px;margin-bottom: 0;text-align: center;text-transform: uppercase>"><?php echo $lang['upload']; ?></div>
						<input type="file" name="upFile" id="imgInp" size="1" style="width:200px !important;">
					</div>
					<div class="upload-logo-descr" style="padding:15px; margin-top:-20px">
						<?php echo $lang['upload_your_image_here_all']; ?>
					</div>
				</div>

				<div class="col-xs-12 col-sm-12 col-md-4 logo-preview mb-15">
					<img id="target" src="images/logo_preview.png" alt="your logo" />
				</div>
				<div class="col-xs-12 col-sm-12 col-md-4 " style="" id="checkboxes-sum">
					<div class="col-xs-12 font bold align-left font-size-16 nopadding mb-10" style="color:rgb(255,255,255);font-size:1em">
						<?php echo $lang['platforms_required']; ?>
					</div>
					<div class="checkbox">
						<label style="color:rgb(255,255,255);font-weight:400;font-size:1em;padding-left:0px;color:white;" for="checkbox-1" class="">
							<input name="soft" id="checkbox-1" type="checkbox" value="1500" style="">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							<?php echo $lang['software_tracking_rebrand']; ?>
						</label>
					</div>
					<div class="checkbox">

						<label style="color:rgb(255,255,255);font-weight:400;font-size:1em;padding-left:0px;color:white;" for="checkbox-2" class="">
							<input name="ios" id="checkbox-2" type="checkbox" value="750" style="">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							<?php echo $lang['ios_application']; ?>
						</label>
					</div>
					<div class="checkbox">

						<label style="color:rgb(255,255,255);font-weight:400;font-size:1em;padding-left:0px;color:white;" for="checkbox-3" class="">
							<input name="android" id="checkbox-3" type="checkbox" value="750" style="">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							<?php echo $lang['android_application']; ?>
						</label>
					</div>
					<div class="checkbox">
						<label style="color:rgb(255,255,255);font-weight:400;font-size:1em;padding-left:0px;color:white;" for="checkbox-4" class="">
							<input name="web" id="checkbox-4" type="checkbox" value="3000" style="">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							<?php echo $lang['website']; ?>
						</label>
					</div>
				</div>

				<div class="col-xs-12 description nopadding">
					<div class="col-xs-12 font bold align-left font-size-16" style="color:rgb(255,255,255);font-size:1em">
						<?php echo $lang['description']; ?>
					</div>
					<div class="col-xs-12">
						<textarea name="request_description" id="request_description" class="mandatory" placeholder="<?php echo $lang['provide_a_short_desc']; ?>" id="" cols="30" rows="10" maxlength="1000"></textarea>
					</div>
				</div>

				<div class="col-xs-12 total-sum">
					<div id="result" style="color:rgb(255,255,255);">
						<?php echo $lang['the_cost_of_your_order']; ?> <em style="color:rgb(255,255,255);">0</em><span style="color:rgb(255,255,255);font-family: OpenSans-Regular; font-size: 24px">$</span>
					</div>
				</div>

				<div class="col-xs-12 nopadding">

					<div class="col-xs-12 font bold align-left font-size-16" style="color:rgb(255,255,255);font-size:1em;padding-bottom:5px;"><?php echo $lang['contact_form_1']; ?></div>
					<div class="col-xs-12 dscrp" style="padding-bottom:8px; color: #a2a2a2;font-family: OpenSans-Italic;"><?php echo $lang['please_fill_out_the_contact_1']; ?></div>

					<div class="col-xs-12 col-sm-6 col-md-8 nopadding align-left contact-form-m">

						<div class="col-xs-12">
							<input type="text" id="request_name" class="mandatory" name="request_name" autocomplete="off" maxlength="200" placeholder="<?php echo $lang['name']; ?>">
						</div>
						<div class="col-xs-12 col-md-6">
							<input type="text" id="request_email" class="" name="request_email" autocomplete="off" maxlength="200" placeholder="E-mail">
						</div>
						<div class="col-xs-12 col-md-6">
							<input type="text" id="request_phone" class="mandatory only_numbers" name="request_phone" autocomplete="off" maxlength="200" placeholder="<?php echo $lang['phone']; ?>">
						</div>

					</div>
					<div class="col-xs-12 col-sm-6 col-md-4 ">
						<div class="checkbox">
							<label for="checkbox-5" class="" style="padding-left:0px;color:white;">
								<input id="checkbox-5" name="purchase" type="checkbox" value="1" style="">
								<span class="cr"><i class="cr-icon fa fa-check"></i></span>
								<?php echo $lang['i_would_like_to_purchase']; ?>
							</label>
						</div>
						<div class="checkbox">

							<label for="checkbox-6" class="" style="padding-left:0px;color:white;">
								<input id="checkbox-6" name="consultant" type="checkbox" value="1" style="">
								<span class="cr"><i class="cr-icon fa fa-check"></i></span>
								<?php echo $lang['i_would_like_to_speak']; ?>
							</label>
						</div>
					</div>
					<div class="col-xs-12 send-but">
						<button type="submit" class="button_send_first button_send_second request<?php echo $lang['send']; ?>" id="request<?php echo $lang['send']; ?>">
							<p class="submitText"><?php echo $lang['send']; ?></p>
							<img alt="" src="images/quiktrakglobal/ajax-loader.gif" class="preloader vis_hidden">
						</button>
						<div class="requestInfo mt-15"></div>
					</div>
				</div>
			</form>
		</div>
	</section>






	<section class="bg_block_five bg_block_fon" id="bg_block_five">
		<div class="container">
			<div class="col-xs-12">
				<h4><?php echo $lang['products']; ?></h4>
				<div class="qtg-text-decoration"></div>
			</div>
			<div class="content">
				<div class="col-xs-12 first-intro">
					<br>
					<p> <?php echo $lang['quiktrak_strives_to_provide_market']; ?> <a href="pdf/products-cat.pdf" target="_blank"><?php echo $lang['catalogue']; ?></a> <?php echo $lang['today']; ?></p>
					<br><br>
				</div>

			</div>
		</div>
	</section>





	<section class="bg_block_eight bg_block_footer" style="padding-top:0px;padding-bottom:0px;">
		<div class="container show_block" style="padding:0px;margin:0px;">
			<div class="hidden-xs hidden-sm col-md-6 nopadding align-left contact-form-m solution_bg" style="overflow: hidden;">
				<!-- <img class="solution_img" src="images/quiktrakglobal/solution_img1.jpg" style="">					 -->
			</div>
			<div class="col-xs-12 col-sm-12 col-md-6 nopadding align-right contact-form-m;">
				<div class="col-xs-12 col-sm-6 nopadding align-left contact-form-m" style="padding-left:0px;margin-left:0px;">
					<div class="bs-example" style="">
						<div class="panel-group" id="accordion">
							<div class="panel panel-default">
								<div class="panel-heading active">
									<h4 class="panel-title">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseOne"><?php echo $lang['products']; ?></a>
									</h4>
								</div>
								<div id="collapseOne" class="panel-collapse collapse in">
									<div class="panel-body">
										<ul>
											<li><a href="javascript:setSolution(1)" class="active"><?php echo $lang['automotivemotorcycle']; ?></a></li>
											<li><a href="javascript:setSolution(2)"><?php echo $lang['marine']; ?></a></li>
											<li><a href="javascript:setSolution(3)"><?php echo $lang['plantequipment']; ?></a></li>
											<li><a href="javascript:setSolution(4)"><?php echo $lang['fleet']; ?></a></li>
											<li><a href="javascript:setSolution(5)"><?php echo $lang['pet']; ?></a></li>
										</ul>
									</div>
								</div>
							</div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseTwo" onclick="javascript:setSolution(6)" style="cursor:pointer"><?php echo $lang['software']; ?></a>
									</h4>
								</div>
								<div id="collapseTwo" class="panel-collapse collapse">

								</div>
							</div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseThree"><?php echo $lang['android_and_ios_apps']; ?></a>
									</h4>
								</div>
								<div id="collapseThree" class="panel-collapse collapse">
									<div class="panel-body">
										<ul>
											<li><a href="javascript:setSolution(7)"><?php echo $lang['quiktrak_2']; ?></a></li>
											<li><a href="javascript:setSolution(8)"><?php echo $lang['quikprotect']; ?></a></li>
											<li><a href="javascript:setSolution(9)"><?php echo $lang['boatwatch']; ?></a></li>
											<!-- <li><a href="javascript:setSolution(10)">Boat<?php echo $lang['protect']; ?></a></li> -->
										</ul>
									</div>
								</div>
							</div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseFour" onclick="javascript:setSolution(11)" style="cursor:pointer"><?php echo $lang['imns_sim_technology']; ?></a>
									</h4>
								</div>
								<div id="collapseFour" class="panel-collapse collapse">

								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xs-12 col-sm-6 nopadding align-left contact-form-m" style="padding-left:0px;margin-left:0px;">
					<div class="" style="">
						<div class="wrapper_solution_info wrapper_solution_info_1 active">
							<div class="wrapper_solution_ico">
								<img class="solution_ico" src="images/quiktrakglobal/solution_ico1.png">
								<div class="qtg-text-decoration" style="height:2px;width:50px;"></div>
							</div>
							<span class="solution_info"><?php echo $lang['quikprotect_is_a_revolutionary_asset']; ?></span>

							<div class="col-xs-12 nopadding" align="left">
								<a href="#presentation-p" data-toggle="modal" class="presentation-all button_send_second presentation_button" width="300px">
									<p><?php echo $lang['presentation']; ?></p>
								</a>
							</div>
						</div>
						
						<div class="wrapper_solution_info wrapper_solution_info_2">
							<div class="wrapper_solution_ico">
								<img class="solution_ico" src="images/quiktrakglobal/solution_ico2.png">
								<div class="qtg-text-decoration" style="height:2px;width:50px;"></div>
							</div>
							<span class="solution_info"><?php echo $lang['boatprotect_is_a_revolutionary_asset']; ?></span>
							<div class="col-xs-12 nopadding" align="left">
								<a href="#presentation-p" data-toggle="modal" class="presentation-all button_send_second presentation_button" width="300px">
									<p><?php echo $lang['presentation']; ?></p>
								</a>
							</div>
						</div>
						<div class="wrapper_solution_info wrapper_solution_info_3">
							<div class="wrapper_solution_ico">
								<img class="solution_ico" src="images/quiktrakglobal/solution_ico3.png">
								<div class="qtg-text-decoration" style="height:2px;width:50px;"></div>
							</div>
							<span class="solution_info"><?php echo $lang['plantprotect_is_a_revolutionary_asset']; ?></span>
							<div class="col-xs-12 nopadding" align="left">
								<a href="#presentation-p" data-toggle="modal" class="presentation-all button_send_second presentation_button" width="300px">
									<p><?php echo $lang['presentation']; ?></p>
								</a>
							</div>
						</div>
						<div class="wrapper_solution_info wrapper_solution_info_4">
							<div class="wrapper_solution_ico">
								<img class="solution_ico" src="images/quiktrakglobal/solution_ico4.png">
								<div class="qtg-text-decoration" style="height:2px;width:50px;"></div>
							</div>
							<span class="solution_info"><?php echo $lang['fleetprotect_is_a_revolutionary_asset']; ?></span>
							<div class="col-xs-12 nopadding" align="left">
								<a href="#presentation-p" data-toggle="modal" class="presentation-all button_send_second presentation_button" width="300px">
									<p><?php echo $lang['presentation']; ?></p>
								</a>
							</div>
						</div>
						<div class="wrapper_solution_info wrapper_solution_info_5">
							<div class="wrapper_solution_ico">
								<img class="solution_ico" src="images/quiktrakglobal/solution_ico5.png">
								<div class="qtg-text-decoration" style="height:2px;width:50px;"></div>
							</div>
							<span class="solution_info"><?php echo $lang['our_personal_tracking_range_is']; ?></span>
							<div class="col-xs-12 nopadding" align="left">
								<a href="#presentation-p" data-toggle="modal" class="presentation-all button_send_second presentation_button" width="300px">
									<p><?php echo $lang['presentation']; ?></p>
								</a>
							</div>
						</div>
						<div class="wrapper_solution_info wrapper_solution_info_6">
							<div class="wrapper_solution_ico">
								<img class="solution_ico" src="images/quiktrakglobal/solution_ico6.png">
								<div class="qtg-text-decoration" style="height:2px;width:50px;"></div>
							</div>
							<span class="solution_info"><?php echo $lang['our_fleet_security_and_tracking']; ?><br><?php echo $lang['quiktrak_staff_are_able_to']; ?><br><?php echo $lang['our_services_provide_you_with']; ?><br>
								<ul>
									<li><?php echo $lang['full_own_branding']; ?></li>
									<li><?php echo $lang['multilingual_as_required']; ?></li>
									<li><?php echo $lang['247_online_support']; ?></li>
									<li><?php echo $lang['full_customization_as_required']; ?></li>
									<li><?php echo $lang['homogelation_of_any_gps_device']; ?></li>
									<li><?php echo $lang['managed_backed_up_and_mirrored']; ?>
							</span>
							<div class="col-xs-12 nopadding" align="left">
								<a href="#presentation-s" data-toggle="modal" class="presentation-all button_send_second presentation_button" width="300px">
									<p><?php echo $lang['presentation']; ?></p>
								</a>
							</div>
						</div>
						<div class="wrapper_solution_info wrapper_solution_info_7">
							<div class="wrapper_solution_ico">
								<img class="solution_ico" src="images/quiktrakglobal/solution_ico7.png">
								<div class="qtg-text-decoration" style="height:2px;width:50px;"></div>
							</div>
							<span class="solution_info"><?php echo $lang['quiktrak_gps_tracker_allows_clients']; ?></span>
							<div class="col-xs-12 nopadding" align="left">
								<a target="_blank" href="pdf/qt-app.pdf" class="presentation-all button_send_second presentation_button" width="300px">
									<p><?php echo $lang['presentation']; ?></p>
								</a>
							</div>
							<div class="app_links">
								<a target="_blank" href="https://apps.apple.com/us/app/quiktrak-pro/id1505742400?ls=1" class="mr-15"><img src="images/quiktrakglobal/btn_ios.png" alt=""></a>
								<a target="_blank" href="https://play.google.com/store/apps/details?id=com.quiktrak.pro"><img src="images/quiktrakglobal/btn_android.png" alt=""></a>
							</div>
						</div>
						<div class="wrapper_solution_info wrapper_solution_info_8">
							<div class="wrapper_solution_ico">
								<img class="solution_ico" src="images/quiktrakglobal/solution_ico8.png">
								<div class="qtg-text-decoration" style="height:2px;width:50px;"></div>
							</div>
							<span class="solution_info"><?php echo $lang['quikprotect_is_a_world_leading']; ?></span>
							<div class="col-xs-12 nopadding" align="left">
								<a href="#presentation-qp" data-toggle="modal" class="presentation-all button_send_second presentation_button" width="300px">
									<p><?php echo $lang['presentation']; ?></p>
								</a>
							</div>
							<div class="app_links">
								<a target="_blank" href="https://apps.apple.com/us/app/quiktrak-pro/id1505742400?ls=1" class="mr-15"><img src="images/quiktrakglobal/btn_ios.png" alt=""></a>
								<a target="_blank" href="https://play.google.com/store/apps/details?id=com.quiktrak.pro"><img src="images/quiktrakglobal/btn_android.png" alt=""></a>
							</div>
						</div>
						<div class="wrapper_solution_info wrapper_solution_info_9">
							<div class="wrapper_solution_ico">
								<img class="solution_ico" src="images/quiktrakglobal/solution_ico9.png">
								<div class="qtg-text-decoration" style="height:2px;width:50px;"></div>
							</div>
							<span class="solution_info"><?php echo $lang['boatwatch_when_an_instant_notification']; ?></span>
							<div class="app_links">
								<a target="_blank" href="https://apps.apple.com/us/app/boatwatch-gps-pro/id6444918742" class="mr-15"><img src="images/quiktrakglobal/btn_ios.png" alt=""></a>
								<a target="_blank" href="https://play.google.com/store/apps/details?id=com.boatwatch.gps"><img src="images/quiktrakglobal/btn_android.png" alt=""></a>
							</div>
						</div>
						<div class="wrapper_solution_info wrapper_solution_info_10">
							<div class="wrapper_solution_ico">
								<img class="solution_ico" src="images/quiktrakglobal/solution_ico10.png">
								<div class="qtg-text-decoration" style="height:2px;width:50px;"></div>
							</div>
							<span class="solution_info"><?php echo $lang['boatprotect_revolutionary_location_alarming_and']; ?></span>
							<div class="app_links">
								<a target="_blank" href="https://itunes.apple.com/us/app/boatprotect/id1210397419?ls=1&mt=8" class="mr-15"><img src="images/quiktrakglobal/btn_ios.png" alt=""></a>
								<a target="_blank" href="https://play.google.com/store/apps/details?id=com.quiktrak.boatprotect"><img src="images/quiktrakglobal/btn_android.png" alt=""></a>
							</div>
						</div>
						<div class="wrapper_solution_info wrapper_solution_info_11">
							<div class="wrapper_solution_ico">
								<img class="solution_ico" src="images/quiktrakglobal/solution_ico11.png">
								<div class="qtg-text-decoration" style="height:2px;width:50px;"></div>
							</div>
							<span class="solution_info"><?php echo $lang['quiktrak_global_service_offer_a']; ?></span>
							<div class="col-xs-12 nopadding" align="left">
								<a href="#presentation-is" data-toggle="modal" class="presentation-all button_send_second presentation_button" width="300px">
									<p><?php echo $lang['presentation']; ?></p>
								</a>
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>

	</section>

	

 
<section class="bg_block_fon" id="bg_block_nine">
    <div class="container">
        <div class="col-xs-12">
            <br><br>
            <h4><?php echo $lang['solutions']; ?></h4>
            <div class="qtg-text-decoration"></div>
        </div>

        <div class="col-xs-12">
					<div class="table-responsive_1">
					<table class="service-plan-table">
                <thead>
                    <tr>
                        <th></th>
                        <th><div class="service-plan-wrapper">QProtect<div class="qtg-text-decoration"></div></div></th>
                        <th><div class="service-plan-wrapper">Loc8<div class="qtg-text-decoration"></div></div></th>
                        <th><div class="service-plan-wrapper">Track<div class="qtg-text-decoration"></div></div></th>
                        <th><div class="service-plan-wrapper">Watch<div class="qtg-text-decoration"></div></div></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <th><?php echo $lang['update_interval']; ?></th>
                        <td><div class="service-plan-wrapper"><?php echo $lang['hourly']; ?></div></td>
                        <td><div class="service-plan-wrapper"><?php echo $lang['10_min']; ?></div></td>
                        <td><div class="service-plan-wrapper"><?php echo $lang['30_sec']; ?>*</div></td>
                        <td><div class="service-plan-wrapper"><?php echo $lang['30_sec']; ?>*</div></td>
                    </tr>
                    <tr>
                        <th><?php echo $lang['inform_on_demand']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png">**</div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png">**</div></td>
                        <td><div class="service-plan-wrapper">N/A</div></td>
                        <td><div class="service-plan-wrapper">N/A</div></td>
                    </tr>
                    <tr>
                        <th><?php echo $lang['smart_phone_app_access']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th><?php echo $lang['online_supprt_email_ts']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th><?php echo $lang['theft_report_assist']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th><?php echo $lang['alert_notif']; ?>***</th>
                        <td><div class="service-plan-wrapper"><?php echo $lang['in_app']; ?></div></td>
                        <td><div class="service-plan-wrapper"><?php echo $lang['in_app']; ?></div></td>
                        <td><div class="service-plan-wrapper"><?php echo $lang['in_app_email']; ?></div></td>
                        <td><div class="service-plan-wrapper"><?php echo $lang['in_app_email_call']; ?></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp; <?php echo $lang['low_battery']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp; <?php echo $lang['power_disconnect']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp; <?php echo $lang['alarm_input']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp; <?php echo $lang['geolock']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp; <?php echo $lang['impact_crash']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp; <?php echo $lang['enter_exit_geofence']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp; <?php echo $lang['sped_street_preset']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp; <?php echo $lang['ignition_on_off']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp; <?php echo $lang['harsh_acc_braking']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper">0</div></td>
                        <td><div class="service-plan-wrapper">0</div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp; <?php echo $lang['aux_inputs']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp; <?php echo $lang['tilt_shock']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp; <?php echo $lang['custom_integration']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th><?php echo

 $lang['offline_alert_no_data']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th><?php echo $lang['add_options_driver_id']; ?>***</th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th><?php echo $lang['remote_immob_trigger']; ?></th>
                        <td><div class="service-plan-wrapper">0</div></td>
                        <td><div class="service-plan-wrapper">0</div></td>
                        <td><div class="service-plan-wrapper">0</div></td>
                        <td><div class="service-plan-wrapper">0</div></td>
                    </tr>
                    <tr>
                        <th><?php echo $lang['website_access']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th class="text-uppercase"><?php echo $lang['historical_reporting']; ?></th>
                        <td><div class="service-plan-wrapper text-light">0</div></td>
                        <td><div class="service-plan-wrapper text-light">0</div></td>
                        <td><div class="service-plan-wrapper text-light">0</div></td>
                        <td><div class="service-plan-wrapper text-light">0</div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp; <?php echo $lang['route_playback']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['act_and_use']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['trip']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['alarms_alerts']; ?></th>
                        <td><div class="service-plan-wrapper">0</div></td>
                        <td><div class="service-plan-wrapper">0</div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['geofencing']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['overview']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['runtime_and_ignition']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['idle_logs']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['input_pto_reporting']; ?>***</th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['obdii_records']; ?>***</th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['servicing_logs']; ?>***</th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['driver_records']; ?>***</th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['ivms_records']; ?>***</th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th><?php echo $lang['service_inrerval_reminders_ddmeh']; ?></th>
                        <td><div class="service-plan-wrapper text-light">0</div></td>
                        <td><div class="service-plan-wrapper text-light">0</div></td>
                        <td><div class="service-plan-wrapper text-light">0</div></td>
                        <td><div class="service-plan-wrapper text-light">0</div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['asset_servicing']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['tyre_rotations_replece']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['reg_renewal']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['insurance_renewal']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['custom_reminders']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th><?php echo $lang['compilence_reporting']; ?></th>
                        <td><div class="service-plan-wrapper text-light">0</div></td>
                        <td><div class="service-plan-wrapper text-light">0</div></td>
                        <td><div class="service-plan-wrapper text-light">0</div></td>
                        <td><div class="service-plan-wrapper text-light">0</div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['fringe_benefit_tax']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                    <tr>
                        <th>&#8226;&nbsp;<?php echo $lang['offroad_usage']; ?></th>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/no.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                        <td><div class="service-plan-wrapper"><img src="images/yes.png"></div></td>
                    </tr>
                </tbody>
            </table>
					</div>
            
						<p>* Updates based on asset usage and direction change.</p>
						<p>** Positional, status and alarms utilise a prepaid credit solution. Review the quikprotect product guide for further information.</p>
						<p>*** Products capabilities and features vary based on the hardware, fitment options and additional components.</p>
							
		

        </div>
				<div class="col-xs-12 no-padding block_divider"></div>
		</div>
	</section>


<section class="bg_block_fon" id="bg_block_eight">
		<div class="container support_img">
			<div class="col-xs-12"><br><br>
				<h4><?php echo $lang['client_support']; ?></h4>
				<div class="qtg-text-decoration"></div>
			</div>
			<form class="col-xs-12 supportForm" id="supportForm">
				<div class=" nopadding align-left contact-form-m mb-10" style="">
					<h5><?php echo $lang['enter_your_details']; ?></h5>
					<div class="dscrp"><?php echo $lang['please_fill_out_the_contact']; ?><br>
						<i style="color:rgb(221,39,42)"><?php echo $lang['mandatory_fields']; ?></i>
					</div>
				</div>
				<div class="col-xs-12 col-sm-6 col-md-4 align-left contact-form-m support-form-left" style="">
					<div class="col-xs-12 nopadding form-group">
						<input type="text" id="supportName" class="mandatory form-control" name="supportName" autocomplete="off" maxlength="200" placeholder="<?php echo $lang['name_of_contact']; ?>" required>
					</div>
					<div class="col-xs-12 nopadding form-group">
						<input type="text" id="supportAccountName" class="mandatory form-control" name="supportAccountName" autocomplete="off" maxlength="200" placeholder="<?php echo $lang['account_name']; ?>" required>
					</div>
					<div class="col-xs-12 nopadding form-group">
						<input type="text" id="supportLoginName" class="mandatory form-control" name="supportLoginName" autocomplete="off" maxlength="200" placeholder="<?php echo $lang['login_name']; ?>" required>
					</div>
					<div class="col-xs-12 nopadding form-group">
						<input type="text" id="supportIMEI" class="mandatory form-control" name="supportIMEI" autocomplete="off" maxlength="200" placeholder="IMEI*" required>
					</div>
					<div class="col-xs-12 nopadding form-group">
						<input type="text" id="supportAssetName" class="mandatory form-control" name="supportAssetName" autocomplete="off" maxlength="200" placeholder="Asset name*" required>
					</div>
				</div>
				<div class="col-xs-12 col-sm-6 col-md-4 contact-form-m support-form-right" style="">
					<div class="col-xs-12 nopadding form-group">
						<input type="email" id="supportEmail" class="mandatory form-control" name="supportEmail" autocomplete="off" maxlength="200" placeholder="Email*" required>
					</div>
					<div class="col-xs-12 nopadding form-group">
						<input type="text" id="supportPhone" class="mandatory form-control only_numbers" name="supportPhone" autocomplete="off" maxlength="200" placeholder="Phone*" required>
					</div>
				 	<div class="form-group">
						<select name="supportService" id="supportService" class="selectpicker form-control qtg-select" title="Select Service*" required>
							<!-- <option disabled value="00"> (<span style="font-size:12px;">Select from the list</span>)*</option>	 -->
							<option value="3">m2mglobaltech.com</option>
							<option value="4">pro.easytrack.quiktrak.co</option>
							<option value="5">siguelo.cl</option>
							<option value="6">nuevo.quiktrak.cl</option>
							<option value="7">login.m-protekt.com.au</option>
							<option value="8">ukraine.quiktrak.eu</option>
							<option value="9">cube.quiktrak.co</option>
							<option value="10">ttc.quiktrak.co</option>
							<option value="11">cargoguard.co</option>
							<option value="12">quiktrak.co</option>

						</select>
					</div>
					<div class="form-group" >
						<select name="supportServicePlan" id="supportServicePlan" class="selectpicker form-control qtg-select" title="Select Service Plan*" required>
							<!-- <option disabled value="00">Device type (<span style="font-size:12px;">Select from the list</span>)*</option> -->
							<option value="1">Tracking</option>
							<option value="2">Alarming</option>
							<option value="3">Personal / Portable</option>
						</select>
					</div>
					<div class="form-group" >
						<select name="supportTypeIssue" id="supportTypeIssue" class="selectpicker form-control qtg-select" title="Select Type of issue*" required>
							<!-- <option disabled value="00">Type of issue (<span style="font-size:12px;">Select from the list</span>)*</option> -->
							<option value="2">Device issue</option>
							<option value="1">Software issue</option>
							<option value="10">Accounts</option>
							<option value="11">Other</option>
						</select>
					</div>
				</div>
				<div class="xs-hidden sm-hidden col-md-4">
					<!-- <img src="images/quiktrakglobal/support_img.png" alt=""> -->
				</div>
				<div class="col-xs-12 col-sm-12 col-md-8 nopadding form-group support_text">
					<textarea name="supportNotes" id="supportNotes" class="form-control" maxlength="1000" placeholder="Notes*" required></textarea>
				</div>
				<!--send button-->
				<div class="col-xs-12 send-but support-form-left"" style="">
					<button type="submit" class="button_send_second button_send1 supportSend" id="supportSend">
						<p class="submitText">Send</p>
						<img alt="" src="images/quiktrakglobal/ajax-loader.gif" class="preloader vis_hidden">
					</button>
					<div class="supportInfo" style="margin-top:15px"></div>
				</div>
					<!--/send button-->
			</form>
				<!--/contact form-->
		</div>

	</section>

<!--second block(product solutions)-->


	<?php include 'footer.php'; ?>

	<script src="js/jquery-1.12.0.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<script src="js/jquery.viewportchecker.min.js"></script>
	<script src="js/validator.min.js"></script>

	<script src="js/sales_form.js"></script>
	<script src="js/sales_form1.js"></script>
	<script src="js/request_form.js"></script>
	<script src="js/support_form.js"></script>


	<!-- MENU INDICATION and SCROLLING-->
	<!-- <script src="js/waypoints.min.js" type="text/javascript"></script> -->
	<!-- <script src="js/navbar2.js" type="text/javascript"></script> -->

	<!-- <script src="js/languages.js" type="text/javascript"></script> -->
<script src="js/bootstrap-select.min.js"></script>

	<script>
		var mobile_flag;

		$(function() {
			var started_w = $(window).width();
			check_mobile(started_w);
		});
		$(window).resize(function(){
			var window_w = $(window).width();
			check_mobile(window_w);
		});

		function check_mobile(w){
			if (w > 892) {
				mobile_flag = 0;
			}else{
				mobile_flag = 1;
			};
		}
		$('.scroll_to a').on('click', function () {
			if (mobile_flag) {
				$('button.navbar-toggle').click();
			};
		});
	</script>


<!-- animated show of elements -->
	<!-- <script>
		$(function() {

			$('.bg_block_logo h4, .bg_block_logo p').addClass("hide_block").viewportChecker({
				classToAdd: 'show_block animated fadeIn',
				repeat: false,
				offset: 100
			});

			$('.bg_block_three .row').addClass("hide_block").viewportChecker({
				classToAdd: 'show_block animated fadeInUp',
				repeat: false,
				offset: 100
			});

			$('.block_four_left_wrapper').addClass("hide_block").viewportChecker({
				classToAdd: 'show_block animated fadeInRight',
				repeat: false,
				offset: 100
			});
			$('.block_four_right_wrapper').addClass("hide_block").viewportChecker({
				classToAdd: 'show_block animated fadeInLeft',
				repeat: false,
				offset: 100
			});

			$('.app-links').addClass("hide_block").viewportChecker({
				classToAdd: 'show_block animated lightSpeedIn',
				repeat: false,
				offset: 200
			});

			$('.bg_block_five h5, .bg_block_five p, .bg_block_five ul').addClass("hide_block").viewportChecker({
				classToAdd: 'show_block animated fadeInUp',
				repeat: false,
				offset: 100
			});

			$('.pad-gif').addClass("hide_block").viewportChecker({
				classToAdd: 'show_block animated flipInY',
				repeat: false,
				offset: 200
			});

			$('.bg_block_six').addClass("hide_block").viewportChecker({
				classToAdd: 'show_block animated slideInUp',
				repeat: false,
				offset: 300
			});

			$('.bg_block_eight h5, .block_eight_text p').addClass("hide_block").viewportChecker({
				classToAdd: 'show_block animated fadeInUp',
				repeat: false,
				offset: 100
			});

			$('.bg_block_eight input, .bg_block_eight textarea, .bg_block_eight .button_send').addClass("hide_block").viewportChecker({
				classToAdd: 'show_block animated fadeInRight',
				repeat: false,
				offset: 100
			});

		});
	</script> -->



	<!--checkboxes scripts-->

<script>
	$(document).ready(function(){
		/*$('input').iCheck({
			checkboxClass: 'icheckbox_flat-blue',

			radioClass: 'iradio_flat-blue'
		});*/
		var RequsetForm = new Request({
			formId: 'requestFor',
			sendButtonId: 'requestSend'
		});

	});
</script>
	<!--total sum-->
	<script>
		$(function(){
			$('#checkboxes-sum input:checkbox').on("change", function(){
				var summ = 0;
				$('#checkboxes-sum input:checkbox:checked').each(function(index, element){
					var add = parseInt($(element).val(), 10);
					if(!isNaN(add))
						summ += add;
				});
				$("#result em").text(summ);
			})
		});
	</script>

	<!--upload avatar-->
	<script>
		function readURL(input) {
			if (input.files && input.files[0]) {
				var reader = new FileReader();
				reader.onload = function (e) {
					$('#target').attr('src', e.target.result);
				}

				reader.readAsDataURL(input.files[0]);
			}
		}

		$("#imgInp").change(function(){
			readURL(this);
		});
	</script>

	<!-- HelloPreload -->
	<script type="text/javascript" src="js/helloPreloader.js"></script>
	<!--  HelloPreload -->

<script>

	function setSolution(arg) {
	  	/*var solution_info = [
	  		'QuikProtect is a revolutionary Asset Recovery Device designed to provide users with a cost effective, reliable and robust solution to their on demand tracking APP driven notification needs. Utilising our revolutionary Intelligent Multi Network Switching SIM we are able to provide clients with the greatest level of coverage. In the event your car or truck has been stolen QuikProtect is designed to allow you to seamlessly locate your asset on demand or commission live tracking for a fast recovery! The best part is QuikProtect has NO MANDATORY ONGOING FEES! Get Protected and sleep easy knowing at the touch of a button you can locate your asset !',
	  		'BoatProtect is a revolutionary Asset Recovery Device designed to provide users with a cost effective, reliable and robust solution to their on demand tracking APP driven notification needs. Utilising our revolutionary Intelligent Multi Network Switching SIM we are able to provide clients with the greatest level of coverage. In the event your boat has been stolen BoatProtect is designed to allow you to seamlessly locate your asset on demand or commission live tracking for a fast recovery! The best part is BoatProtect has NO MANDATORY ONGOING FEES! Get Protected and sleep easy knowing at the touch of a button you can locate your asset! BoatProtect is ideal for all marine applications.',
	  		'PlantProtect is a revolutionary Asset Recovery Device designed to provide users with a cost effective, reliable and robust solution to their on demand tracking APP driven notification needs. Utilising our revolutionary Intelligent Multi Network Switching SIM we are able to provide clients with the greatest level of coverage. In the event your plant or equipment has been stolen PlantProtect is designed to allow you to seamlessly locate your asset on demand or commission live tracking for a fast recovery! The best part is PlantProtect has NO MANDATORY ONGOING FEES! Get Protected and sleep easy knowing at the touch of a button you can locate your asset! PlanProtect is ideal for all Plant and Equipment applications.',
	  		'FleetProtect is a revolutionary Asset Recovery Device designed to provide users with a cost effective, reliable and robust solution to their on demand tracking APP driven notification needs. Utilising our revolutionary Intelligent Multi Network Switching SIM we are able to provide clients with the greatest level of coverage. In the event your fleet has been stolen FleetProtect is designed to allow you to seamlessly locate your asset on demand or commission live tracking for a fast recovery! The best part is FleetProtect has NO MANDATORY ONGOING FEES! Get Protected and sleep easy knowing at the touch of a button you can locate your asset! FleetProtect is ideal for all Fleet applications.',
	  		'Our personal tracking range is designed to provide the right unit for the right application. Contact one of our sales staff today to discuss what option is right for you. Whether it be for lone workers, young children or the elderly alike our personal solutions will provide a robust and reliable solution to tackle all of the challenges thrown its way. Never worry about your staff or loved ones again, keep track of their movements and locations with our Personal range today!',
	  		'Our fleet, security and tracking software is managed and licensed by our dedicated software team across 2 continents. We guarantee to ensure you maintain complete control over your business and assets.<br>QuikTrak staff are able to offer 24/7 online support for you, your distributors, and your clients leaving you to spend your time doing what makes you money, growing your business.<br>Our services provide you with:<br><ul><li>• Full own branding;</li><li>• Multilingual as required;</li><li>• 24/7 Online support;</li><li>• Full customization as required;</li><li>• Homogelation of any GPS device you, or your clients use;</li><li>• Managed, backed up and mirrored cluster arrayed servers for maximum security, and zero downtime.',
	  		'QuikTrak gps tracker allows clients to log into their gps tracking account, modify their asset information and view the real time location of their asset, including historical playback.',
	  		'QuikProtect is a world leading vehicle location and recovery system providing maximum protection against vehicle theft and ensuring immediate location for speedy recovery. Live service with push notification and tracking system.',
	  		'BoatWatch when an instant notification is crucial to your safety of your pride and joy !',
	  		'BoatProtect revolutionary location, alarming and tracking solutions for all your security needs !',
	  		'QuikTrak Global service offer a world leading data transmission technology called Intelligent Multiple Network Switching (IMNS) sim technology. IMNS sims are able to operate on any GSM network worldwide, and are able to switch between these networks to receive the best data transmission. By seeking out the network which will deliver the least congested and strongest data signal, IMNS sims are able to deliver the most stable, and efficeint data transmission. Coupling this technology with the use of QuikTrak´s worldwide private APN QuikTrak Global is a world leader in secure, and reliable data transmission for machine 2 machine applications.'
	  	];		*/

		$('.solution_bg').css('background-image','url("images/1920/solution_img'+arg+'.jpg")');
		$('.wrapper_solution_info').removeClass('active');
		$('.wrapper_solution_info_'+arg).addClass('active');
		//$('.solution_ico').attr('src','images/quiktrakglobal/solution_ico'+arg+'.png');
		//$('.solution_info').html(solution_info[arg-1]);


		solutinonBgCorrection();
	}

  	$('#accordion').on('click', '.panel-title a', function(){
  		$('.panel-heading').removeClass('active');
  		$('.panel-body a').removeClass('active');
  		$(this).closest('.panel-heading').addClass('active');
  	});
  	$('#accordion').on('click', '.panel-body a', function(){
  		$('.panel-body a').removeClass('active');
  		$(this).addClass('active');
  	});

  $(window).resize(function(){
		solutinonBgCorrection();
	});

	$(function() {
		solutinonBgCorrection();
	});

	function solutinonBgCorrection(){
		var solBg = $('.solution_bg');
		var heightBgContainer = solBg.closest('.container').height();
		solBg.height(heightBgContainer+'px');
	}

	function presentation(arg){
		$('.presentation-all').addClass('display-none');
		$('#presentation'+arg).removeClass('display-none');
	}
	$(document).ready(function() {
			$('#presentation-video-popup').on('hidden.bs.modal', function (e) {
				var videoElement = document.getElementById('presentation-video');
				videoElement.pause();   
				videoElement.currentTime = 0;  
			});
		});

</script>

<script src="js/map-details.js"></script>

<?php include_once("google-analitycs.php") ?>

</body>
</html>
