/**
 * Created by dem on 8/5/16.
 */
'use strict';

var send_request = 1;
function Request (options){
    this.options = options || {
        formId: 'requestForm',
        sendButtonId: 'requestSend'
        };

        this.eventListener();
}

Request.prototype.eventListener = function () {
    let self = this;

    $('#requestForm').on("submit", function (e) {
        $('.requestInfo').empty();
        self.cancelEvent(e);
        let data = new FormData(this);
        let url = 'php/request.php';

        var valid_request = 1;
        
        if(white_spaces.test($('#request_name').val())){            
            $('#request_name').removeClass('error_field');
        }else{
            valid_request=0;
            $('#request_name').addClass('error_field');
        }
            
        if(white_spaces.test($('#request_phone').val())){           
            $('#request_phone').removeClass('error_field');
        }else{
            valid_request=0;
            $('#request_phone').addClass('error_field');
        }

        if(white_spaces.test($('#request_description').val())){           
            $('#request_description').removeClass('error_field');
        }else{
            valid_request=0;
            $('#request_description').addClass('error_field');
        }

        if(filteremail.test($('#request_email').val())){
            $('#request_email').removeClass('error_field');// устанавливаем рамку обычного цвета   
        }else{
            valid_request=0;
            $('#request_email').addClass('error_field');            
        }

        $('.mandatory').blur(function(){
            if(white_spaces.test($(this).val())){
                $(this).removeClass('error_field'); 
            }else {         
                $(this).addClass('error_field');
            }
        }); 
        $('#request_email').blur(function(){
            if(filteremail.test($(this).val())){
                $(this).removeClass('error_field'); 
            }else {         
                $(this).addClass('error_field');
            }
        });

        if (send_request == 1) {
            if (valid_request == 1) {
                self.sendForm(url, data);
            };
           
        };
        
        
        return false;
    })
};

Request.prototype.sendForm = function (action, data) {   
    
    let self = this;
    let sendBObj = $('#'+self.options.sendButtonId);
       $.ajax({
            url: action,
            data: data,
            type: "POST",
            dataType: "json",
            beforeSend: function(xhr) {
                sendBObj.prop('disabled', true);
                send_request = 0;
                $('.requestSend').toggleClass('disabled');
                $('.requestSend .submitText, .requestSend .preloader').toggleClass('vis_hidden');   
            },
            success: function (data) {  
                send_request = 1;
                $('.requestSend').toggleClass('disabled');
                $('.requestSend .submitText, .requestSend .preloader').toggleClass('vis_hidden');              
               
                if (data['ReplyCode'] == 1){                   
                    $('.requestInfo').html('<div class="success">'+data['msg']+'</div>');

                    $('#request_description').val('');
                    $('#request_name').val('');
                    $('#request_phone').val('');
                    $('#request_email').val('');
                    $('#target').attr('src','images/logo_preview.png');                   
                                                    

                }else{
                    $('.salesInfo').html('<div class="with-errors">'+data['msg']+'</div>');
                }
                sendBObj.prop('disabled', false);
            },
            error: function(XMLHttpRequest, textStatus, errorThrown){ 
               $('.requestSend').toggleClass('disabled');
                $('.requestSend .submitText, .requestSend .preloader').toggleClass('vis_hidden');               
                $('.requestInfo').html('<div class="with-errors">Error, please try again later</div>');                                                               
                send_request = 1;
                sendBObj.prop('disabled', false);
            },
            contentType: false,
            processData: false
        });
};

Request.prototype.cancelEvent = function(event) {
    event = event || window.event;
    if (event) {
        event = event.originalEvent || event;

        if (event.stopPropagation) event.stopPropagation();
        if (event.preventDefault) event.preventDefault();
        event.returnValue = false;
        event.cancelBubble = true
    }

    return false
};