<!DOCTYPE html>
<html lang="en">
<head>
  <?php include 'google-analitics.php'; ?>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="title" content="QuikTrak">
  <meta name="keywords" content="Gps Tracker, GPS, Tracking, Tracker, Fleet, Fleet Tracking, Monitor, Monitoring, Cost Effective, Alarms, Location, Low Cost GPS">

  <link rel="stylesheet" href="css/bootstrap.min.css">
  <link rel="stylesheet" href="css/bootstrap-select.min.css">
  <link rel="stylesheet" href="css/animate.css">
  <link rel="stylesheet" href="css/font.css">
  <link rel="shortcut icon" href="img/fav.png" type="image/x-icon">
  <link rel="stylesheet" href="css/media.css?v=<?php echo filemtime('css/media.css'); ?>" />
  <link rel="stylesheet" href="css/main.css?v=<?php echo filemtime('css/main.css'); ?>" />


  <title>QuikTrak</title>


</head>
<body class="page">
	<?php include 'google-analitics-after-body.php'; ?>
  <!-- preloader -->
  <div id="p_prldr">
    <div class="contpre">
      <span class="svg_anm"></span>
    </div>
  </div>

  <div class="page__wrapper">

    <!-- header -->
    <div class="header__wrapper">
      <div class="container header__container">
        <div class="header__row">
          <div class="header__item">
            <img class="header__atga" src="img/footer/atga_logo.svg" alt="logo">
          </div>
          <div class="header__item">
            <img class="header__qt" src="img/footer/qt_logo.svg" alt="logo">
          </div>
          <div class="header__item conn-inner">
            <div class="header__link-p">Domestic calls: <a class="header__link-conn" target="_blank" href="tel:1300885461">1300 885 461</a></div>
			<div class="header__link-p">International calls: <a class="header__link-conn" target="_blank" href="tel:+61409779650">+61409779650</a></div>
			<div  class="header__link-p">Email: <a class="header__link-conn" target="_blank" href="mailto:support@quiktrak.com.au">support@quiktrak.com.au</a></div>
          </div>
          <div class="header__item activation-inner">
            <!-- <a class="header__activation" target="_blank" href="#" data-toggle="modal" data-target="#myModal2">activation</a> -->
            <a class="header__activation" target="_blank" href="https://app.quikprotect.co/activation2/" >activation</a>
            <a class="header__support" target="_blank" href="https://support.quiktrak.eu/">support</a>
          </div>
        </div>
        <div class="header__row">
          <nav class="navbar">
            <div class="container-fluid">
              <div class="navbar-header">
                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
                  <span class="header__menu">
                    <img class="header__icon-menu" src="img/menu.svg" alt="menu">
                  </span>
                </button>
              </div>
              <div id="navbar" class="navbar-collapse collapse" aria-expanded="false">
                <ul class="header__nav nav navbar-nav">
                  <li class="header__li">
                    <a class="header__nav-link" href="index.php">Home</a>
                  </li>
                  <li class="header__li dropdown">
                    <a href="#" class="dropdown-toggle header__nav-link" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">Asset Types <span class="caret"></span></a>
                    <ul class="header__drop-menu dropdown-menu">
                      <li class="header__drop-li"><a class="header__drop-link" data-product="0" href="product.php?product=0">Automotive and Motorcycle</a></li>
                      <li class="header__drop-li"><a class="header__drop-link" data-product="1" href="product.php?product=1">Marine</a></li>
                      <li class="header__drop-li"><a class="header__drop-link" data-product="2" href="product.php?product=2">Plant and Equipment/Machinery</a></li>
                      <li class="header__drop-li"><a class="header__drop-link" data-product="3" href="product.php?product=3">Fleet</a></li>
                      <li class="header__drop-li"><a class="header__drop-link" data-product="4" href="product.php?product=4">Pet and Personal</a></li>
                    </ul>
                  </li>
                  <li class="header__li">
                    <a class="header__nav-link" href="plans.php#plans">SOLUTION TYPES</a>
                  </li>
                  <li class="header__li">
                    <a class="header__nav-link" href="faq.php#faq">FAQ</a>
                  </li>
                  <li class="header__li scroll_to">
                    <a class="header__nav-link" href="#"  data-section="#contact">Contact Us</a>
                  </li>
                  <li class="header__li dropdown">
                    <a href="#" class="dropdown-toggle header__nav-link" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">User Guides <span class="caret"></span></a>
                    <ul class="header__drop-menu dropdown-menu">
                     <!--  <li class="header__drop-li"><a class="header__drop-link" target="_blank" href="/pdf/manuals/qp-app-manual.pdf">QP App Manual</a></li>
           <li class="header__drop-li"><a class="header__drop-link" target="_blank" href="/pdf/manuals/qt-app-manual.pdf">QT App Manual</a></li> -->
           <li class="header__drop-li"><a class="header__drop-link" target="_blank" href="/pdf/manuals/qt-pro-app.pdf">QT PRO App Manual</a></li>
                      <li class="header__drop-li"><a class="header__drop-link" target="_blank" href="/pdf/manuals/customer-user-manual.pdf">Software Manual</a></li>                      
                    </ul>
                    </li>
                  <li class="header__li dropdown">
                    <a href="#" class="dropdown-toggle header__nav-link" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">Product Brochure <span class="caret"></span></a>
                    <ul class="header__drop-menu dropdown-menu">
                      <li class="header__drop-li"><a class="header__drop-link" target="_blank" href="/pdf/brochures/fleettrack.pdf">FleetTrack</a></li>
                      <li class="header__drop-li"><a class="header__drop-link" target="_blank" href="/pdf/brochures/fleetwatch.pdf">FleetWatch</a></li>
                     <!-- <li class="header__drop-li"><a class="header__drop-link" target="_blank" href="/pdf/brochures/qtee500.pdf">QuikTrak - QTee500</a></li>  -->
                      <li class="header__drop-li"><a class="header__drop-link" target="_blank" href="/pdf/brochures/4gqtlte500.pdf">QuikTrak - 4G QT LTE 500</a></li>                    
                    </ul>
                  </li>
                  <li class="header__li hidden-elem">
                    <!-- <a class="header__activation-nav" target="_blank" href="#" data-toggle="modal" data-target="#myModal2">activation</a> -->
                    <a class="header__activation-nav" target="_blank" href="https://app.quikprotect.co/activation2/" >activation</a>
                  </li>
                  <li class="header__li hidden-elem">
                    <a class="header__support-nav" target="_blank" href="https://support.quiktrak.eu/">support</a>
                  </li>
                  <li class="header__li hidden-elem">
                    <div class="header__login2" href="#">login
                      <div class="header__drop-login2">
                        <a target="_blank" class="header__login-drop-link2" href="http://m3.quikprotect.co/">Dealer</a>
                        <a target="_blank" class="header__login-drop-link2" href="#" data-toggle="modal" data-target="#installerApps">Installer</a>
                        <a target="_blank" class="header__login-drop-link2" href="https://quiktrak.co/">Client</a>
                        <a target="_blank" class="header__login-drop-link2" href="http://m.quikprotect.co/">QuikProtect</a>
                        <a target="_blank" class="header__login-drop-link2" href="http://webapp.quikloc8.co/">QuikLoc8</a>
                      </div>
                    </div>
                  </li>
                  <li class="header__li hidden-elem">
                    <div class="header__link-p2">International calls: <a class="header__link-conn2" target="_blank" href="tel: +61894677181"> +61 8 9467 7181</a></div>
                  </li>
                  <li class="header__li hidden-elem">
                    <div  class="header__link-p2">Email: <a class="header__link-conn2" target="_blank" href="mailto:sales@quiktrak.com.au"> sales@quiktrak.com.au</a></div>
                  </li>
                </ul>
              </div>
            </div>
          </nav>
          <div class="header__login" href="#">login
            <div class="header__drop-login">
              <a target="_blank" class="header__login-drop-link" href="http://m3.quikprotect.co/">Dealer</a>
              <a target="_blank" class="header__login-drop-link" href="#" data-toggle="modal" data-target="#installerApps">Installer</a>
              <a target="_blank" class="header__login-drop-link" href="https://quiktrak.co/">Client</a>
              <a target="_blank" class="header__login-drop-link" href="http://m.quikprotect.co/">QuikProtect</a>
              <a target="_blank" class="header__login-drop-link" href="http://webapp.quikloc8.co/">QuikLoc8</a>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- start -->
    <div class="start__wrapper">
      <div id="myCarousel" class="carousel slide" data-ride="carousel">

        <!-- Indicators -->
        <ol class="carousel-indicators">
          <li data-target="#myCarousel" data-slide-to="0" class="active"></li>
          <li data-target="#myCarousel" data-slide-to="1"></li>
          <li data-target="#myCarousel" data-slide-to="2"></li>
        </ol>
        <!-- Wrapper for slides -->
        <div class="carousel-inner">
          <div class="item active">
            <div class="car"></div>
          </div>

          <div class="item">
            <div class="boat"></div>
          </div>

          <div class="item">
            <div class="truck"></div>
          </div>
        </div>
      </div>
    </div>

    <!-- service -->
    <div class="service__wrapper" id="plans">
      <div class="service__container container">
        <div class="service__row-title">
          <h2 class="service__title-caption animated  full-visible">Solution Types</h2>
        </div>
        <div class="service__row">
           <!--<div class="service__inner service__left animated col-xs-12 col-sm-6 col-md-6 col-lg-3 ">
            <div class="service__row-inner">
              <div class="service__title-block">
                <h4 class="service__caption protect-color">Protect</h4>
              </div>
              <div class="service__line-block"></div>
              <ul class="service__ul">
                <li class="service__li">IMNS SIM technology</li>
                <li class="service__li">10 FREE location credits</li>
                <li class="service__li">24 month hardware warranty </li>
                <li class="service__li">Emergency response centre access</li>
                <li class="service__li">Online support - via ticketing system</li>
                <li class="service__li">IOS and Android apps</li>
                <li class="service__li">Location/status on demand</li>
                <li class="service__li">Geofence/Geolock alarms</li>
                <li class="service__li">Customised instant alarms</li>
                <li class="service__li">In-App push notifications</li>
                <li class="service__li service__li--disabled">Route optimised updating</li>
                <li class="service__li service__li--disabled">Live tracking</li>
                <li class="service__li service__li--disabled">Statistical reporting </li>
                <li class="service__li service__li--disabled">Historical reporting</li>
                <li class="service__li service__li--disabled">E-mail notifications</li>
              </ul>
              <div class="service__btn-block">
                <a href="#" data-toggle="modal" data-target="#myModal2" class="service__btn service__btn-protect">free</a>
              </div>
            </div>
           </div>-->
           <div class="service__inner service__right animated col-xs-12 col-sm-6 col-md-6 col-lg-4 ">
            <div class="service__row-inner">
              <div class="service__title-block">
                <h4 class="service__caption loc-color">Loc8</h4>
              </div>
              <div class="service__line-block"></div>
              <ul class="service__ul">				
              	<li class="service__li orange">Hourly updates</li>
				<li class="service__li sub_service__li"><span class="sub__li color-orange">-</span> Location</li>
				<li class="service__li sub_service__li"><span class="sub__li color-orange">-</span> Status</li>
				<li class="service__li sub_service__li"><span class="sub__li color-orange">-</span> Speed</li>
				<li class="service__li sub_service__li"><span class="sub__li color-orange">-</span> Direction</li>
				<li class="service__li sub_service__li"><span class="sub__li color-orange">-</span> Engine hours</li>
				<li class="service__li sub_service__li"><span class="sub__li color-orange">-</span> Mileage</li>
				<li class="service__li orange">Instant inapp alarm notifications</li>
				<li class="service__li"><span class="sub__li color-orange">-</span> Ignition on/off</li>
				<li class="service__li"><span class="sub__li color-orange">-</span> Low battery</li>
				<li class="service__li"><span class="sub__li color-orange">-</span> Battery disconnection</li>
				<li class="service__li"><span class="sub__li color-orange">-</span> Custom inputs</li>
				<li class="service__li"><span class="sub__li color-orange">-</span> Impact/Crash</li>
				<li class="service__li"><span class="sub__li color-orange">-</span> Geolock/Geofence</li>
				<li class="service__li orange">10 FREE credits</li>
				<li class="service__li orange">Service and interval reminders</li>
				<li class="service__li orange">IMNS sim technology  –  improved coverage using multiple networks</li>
				<li class="service__li orange">Smartphone (IOS and ANDROID) and Web interface</li>
				<li class="service__li orange">Online support</li>
				<li class="service__li orange">Theft recovery assistance and reporting</li>
				<li class="service__li orange">24-month hardware warranty</li>
				
              	<!--<li class="service__li">Once hourly updates</li>
                <li class="service__li">IMNS SIM Technology</li>
                <li class="service__li">10 FREE credits</li>
                <li class="service__li">24 months hardware warranty</li>
                <li class="service__li">Emergency response centre access</li>
                <li class="service__li">Online support - via ticketing system</li>
                <li class="service__li">IOS and ANDROID apps</li>
                <li class="service__li">Web interface</li>
                <li class="service__li">Flexible set update intervals - including location, status and mileage/engine hours</li>
                <li class="service__li">Geolock alarms</li>
                <li class="service__li">Customised instant alarms</li>
                <li class="service__li">In-App push notifications</li>
                <li class="service__li  service__li--disabled">Route optimised updating</li>
                <li class="service__li  service__li--disabled">Live tracking</li>
                <li class="service__li  service__li--disabled">Statistical reporting</li>
                <li class="service__li  service__li--disabled">Historical reporting</li>
                <li class="service__li  service__li--disabled">E-mail notifications</li>-->
              </ul>
              <div class="service__btn-block">
                <a href="#" data-toggle="modal" data-target="#enquire" class="service__btn service__btn-loc">$11.00/month</a>
              </div>
            </div>
           </div>
           <div class="service__inner service__center animated col-xs-12 col-sm-6 col-md-6 col-lg-4 ">
            <div class="service__row-inner">
              <div class="service__title-block">
                <h4 class="service__caption track-color">Track</h4>
              </div>
              <div class="service__line-block"></div>
              <ul class="service__ul">
              	<li class="service__li blue">Turn by turn updates – max 60 seconds</li>
				<li class="service__li blue">Historical and statistical reporting</li>
				<li class="service__li sub_service__li"><span class="sub__li color-blue">-</span> Overview</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Route playback</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Activity and usage</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Runtime/ignition</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Geofencing and alarms</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Trip and FBT</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Driver fatigue</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Alarms</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Automated reports</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Servicing and interval</li>
				<li class="service__li blue">Instant alarm and notifications</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Ignition on/off</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Low battery</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Battery disconnection</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Custom inputs</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Impact/Crash</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Geolock/Geofence</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Driver fatigue and excessive idling</li>
				<li class="service__li blue">Service and interval reminders</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Mechanical services</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Tire check/rotations</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Registration and insurance renewal</li>
				<li class="service__li"><span class="sub__li color-blue">-</span> Customised reminders</li>
				<li class="service__li blue">Inapp and email notifications</li>
				<li class="service__li blue">Website and smartphone (IOS and ANDROID) access</li>
				<li class="service__li blue">IMNS sim technology – improved coverage using multiple networks</li>
				<li class="service__li blue">Online support</li>
				<li class="service__li blue">Theft recovery assistance and reporting</li>
				<li class="service__li blue">24-month hardware warranty</li>
				<!--<li class="service__li">60 second, turn by turn updates</li>
                <li class="service__li">IMNS SIM technology</li>
                <li class="service__li">24 month hardware warranty </li>
                <li class="service__li">Emergency response centre access</li>
                <li class="service__li">Online support - via ticketing system</li>
                <li class="service__li">IOS and Android apps</li>
                <li class="service__li">Web interface</li>
                <li class="service__li">Geofence/Geolock alarms</li>
                <li class="service__li">Customised instant alarms</li>
                <li class="service__li">Route optimised updating</li>
                <li class="service__li">Live tracking</li>
                <li class="service__li">Statistical reporting </li>
                <li class="service__li">Historical reporting</li>
                <li class="service__li">In-App push notifications</li>
                <li class="service__li">E-mail notifications</li>
                <li class="service__li service__li--disabled">Phone call notifications</li>-->
              </ul>
              <div class="service__btn-block">
                <a href="#" data-toggle="modal" data-target="#myModal2" class="service__btn service__btn-track">$19.00/month</a>
              </div>
            </div>
           </div>
           <div class="service__inner service__right animated col-xs-12 col-sm-6 col-md-6 col-lg-4 ">
            <div class="service__row-inner">
              <div class="service__title-block">
                <h4 class="service__caption full-color">Watch</h4>
              </div>
              <div class="service__line-block"></div>
              <ul class="service__ul">
              	<li class="service__li red">Turn by turn updates – max 60 seconds</li>
				<li class="service__li red">Historical and statistical reporting</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Overview</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Route playback</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Activity and usage</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Runtime/ignition</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Geofencing and alarms</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Trip and FBT</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Driver fatigue</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Alarms</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Automated reports</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Servicing and interval</li>
				<li class="service__li red">Instant alarm and notifications</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Ignition on/off</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Low battery</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Battery disconnection</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Custom inputs</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Impact/Crash</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Geolock/Geofence</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Driver fatigue and excessive idling</li>
				<li class="service__li red">Service and interval reminders</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Mechanical services</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Tire check/rotations</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Registration and insurance renewal</li>
				<li class="service__li"><span class="sub__li color-red">-</span> Customised reminders</li>
				<li class="service__li red">Quiktrak Automated Response Call notifications for theft alarms</li>
				<li class="service__li red">Inapp and email notifications</li>
				<li class="service__li red">Website and smartphone (IOS and ANDROID) access</li>
				<li class="service__li red">IMNS sim technology – improved coverage using multiple networks</li>
				<li class="service__li red">Online support</li>
				<li class="service__li red">Theft recovery assistance and reporting</li>
				<li class="service__li red">24-month hardware warranty</li>
				<!--
				<li class="service__li">60 second, turn by turn updates</li>
                <li class="service__li">IMNS SIM technology</li>
                <li class="service__li">24 month hardware warranty </li>
                <li class="service__li">Alarm Monitoring Centre and In App theft reporting</li>
                <li class="service__li">IOS and Android apps</li>
                <li class="service__li">Web interface</li>
                <li class="service__li">Geofence/Geolock alarms</li>
                <li class="service__li">Customised instant alarms</li>
                <li class="service__li">Route optimised updating</li>
                <li class="service__li">Live tracking</li>
                <li class="service__li">Statistical reporting </li>
                <li class="service__li">Historical reporting</li>
                <li class="service__li">In-App push notifications</li>
                <li class="service__li">E-mail notifications</li>
                <li class="service__li">Phone call notifications</li>-->
              </ul>
              <div class="service__btn-block">
                <a href="#" data-toggle="modal" data-target="#myModal2" class="service__btn service__btn-full">$33.00/month</a>
              </div>
            </div>
           </div>
        </div>
		<p class="contact__desc">Didn't find the plan you are looking for? Contact us today to discuss your options further.</p>
      </div>
    </div>

    <!-- contact -->
    <div class="contact__wrapper animated" id="contact">
      <div class="container contact__container">
        <div class="contact__top-block">
          <h2 class="contact__caption">Contact Us</h2>
          <p class="contact__desc">If you have any questions or comments, please leave us a message below and we will get back to you as soon as we can!</p>
        </div>
        <form class="contact__form">
          <div class="contact__row-two">
            <div class="contact__form-group-two form-group">
              <input class="contact__form-control form-control" placeholder="Name" type="text" id="contactName" name="Name" required>
            </div>
            <div class="contact__form-group-two form-group">
              <input class="contact__form-control form-control" placeholder="E-mail" type="email" id="contactEmail" name="Email" required>
            </div>
          </div>
          <div class="contact__row-two">
            <div class="contact__form-group-two form-group">
              <input class="contact__form-control form-control" type="tel" placeholder="Phone" id="contactPhone" name="Phone" required>
            </div>
            <div class="contact__form-group-two form-group">
              <select id="contactDep" class="contact__select form-control selectpicker" required>
                <!-- <option class="bs-title-option" value>Department</option> -->
                <option value="Sales">Sales</option>
                <option value="Customer support">Customer support</option>
                <option value="Accounts">Accounts</option>
              </select>
            </div>
          </div>
          <div class="contact__row">
            <div class="contact__from-group form-group">
              <textarea id="contactDesc" placeholder="Message" class="contact__textarea form-control" name="name" rows="8" cols="80" required></textarea>
            </div>
          </div>
          <div class="contact__btn-block">
            <button type="submit" class="contact__send">
              <p class="submitText">send message</p>
              <img src="img/ajax-loader.gif" class="preloader vis_hidden" alt="loader">
            </button>
            <div class="loginInfo"></div>
          </div>
        </form>
      </div>
    </div>

    <!-- footer -->
    <div class="footer__wrapper">
      <div class="footer__container container">
        <div class="footer__row">
          <div class="footer__block-1 col-lg-6 col-md-6 col-sm-7">
            <img class="footer__atga" src="img/footer/atga_logo.svg" alt="logo">
            <img class="footer__qt" src="img/footer/qt_logo.svg" alt="logo">
          </div>
          <div class="footer__block-2 col-lg-6 col-md-6 col-sm-5">
            <!-- <div class="footer__link-p">Phone: <a class="footer__link-conn" target="_blank" href="tel:1300885461"> 1300 885 461</a></div> -->
            <div class="footer__link-p">Domestic calls: <a class="footer__link-conn" target="_blank" href="tel:1300885461">1300 885 461</a></div>
			<div class="footer__link-p">International calls: <a class="footer__link-conn" target="_blank" href="tel:+61409779650">+61409779650</a></div>
			<div class="footer__link-p">Email: <a class="footer__link-conn" target="_blank" href="mailto:support@quiktrak.com.au">support@quiktrak.com.au</a></div>
          </div>
        </div>
        <div class="footer__row2">
          <div class="footer__item col-lg-2 col-md-3 col-sm-4 col-xs-6">
            <a class="footer__link" href="index.php">Home</a>
            <a class="footer__link footer__prod" href="plans.php#plans">Solution Types</a>
            <a class="footer__link footer__prod" href="faq.php#faq">FAQ</a>
            <a class="footer__link footer__prod" data-product="4" href="product.php?product=4">Pet and Personal</a>
          </div>
          <div class="footer__item item-transform col-lg-2 col-md-3 col-sm-4 col-xs-6">
            <a class="footer__link footer__prod" data-product="0" href="product.php?product=0">Automotive and Motorcycle</a>
            <a class="footer__link footer__prod" data-product="1" href="product.php?product=1">Marine</a>
            <a class="footer__link footer__prod" data-product="2" href="product.php?product=2">Plant and Equipment/Machinery</a>
            <a class="footer__link footer__prod" data-product="3" href="product.php?product=3">Fleet</a>
          </div>
          <div class="footer__item item-align col-lg-8 col-md-6 col-sm-4 col-xs-6">
            <a class="footer__link" href="legal.php#legal">Terms and Conditions</a>
            <a class="footer__link" href="online-purchasing.php#policy">Online Purchasing Policy</a>
			<a class="footer__link" href="gps-disclosure.php#gps-disclosure">GPS Disclosure</a>
          </div>
        </div>
        <div class="footer__res">
          <p class="footer__copy">Copyright Automotive Technology Group Australia Pty Ltd, all rights reserved.</p>
        </div>
      </div>
    </div>

    <!-- Modal -->
    <div id="myModal2" class="modal fade" role="dialog">
      <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"><img class="modal-img-close" src="img/icon_close.svg" alt=""></button>
            <h4 class="activationModal__caption">Activation</h4>
          </div>
          <div class="activationModal__modal-body modal-body">
            <p class="activationModal__desc">New clients are clients who have not purchased a QuikTrak system before.</p>
            <p class="activationModal__desc">Existing clients are clients who have purchased a QuikTrak system before and wish to add another to their account.</p>
            <div class="activationModal__btn-block">
              <!-- <a class="activationModal__btn" href="activations_ec.php#ec_form">yes, existing customer</a>
              <a class="activationModal__btn-two" href="activations_nc.php#nc_form">no, new customer</a> -->
              <a class="activationModal__btn" target="_blank" href="http://app.quikprotect.co/activation2/activate.php">yes, existing customer</a>
              <a class="activationModal__btn-two" target="_blank" href="http://app.quikprotect.co/activation2/register.php">no, new customer</a>
            </div>
          </div>
        </div>

      </div>
    </div>

    <!-- Modal Trailers -->
    <div id="trailers" class="modal fade" role="dialog">
      <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"><img class="modal-img-close" src="img/icon_close.svg" alt=""></button>
            <h4 class="activationModal__caption">Coming soon...</h4>
          </div>
          <div class="activationModal__modal-body modal-body">
          </div>
        </div>

      </div>
    </div>

    <!-- Modal blog -->
    <div id="blog" class="modal fade" role="dialog">
      <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"><img class="modal-img-close" src="img/icon_close.svg" alt=""></button>
            <h4 class="activationModal__caption">Coming soon...</h4>
          </div>
          <div class="activationModal__modal-body modal-body">
          </div>
        </div>

      </div>
    </div>

    <!-- Modal enquire -->
    <div id="enquire" class="modal fade" role="dialog">
      <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
              <img class="modal-img-close" src="img/icon_close.svg" alt="">
            </button>
            <h4 class="enquire__caption">Services Enquiry</h4>
            <p class="enquire__desc">Please fill out the contact form and a member of our sales team will contact you shortly.</p>
          </div>
          <div class="activationModal__modal-body modal-body">
            <form class="enquire__form">
              <div class="enquire__row-two">
                <div class="enquire__form-group-two form-group">
                  <input class="enquire__form-control form-control" placeholder="Name" type="text" id="enquireName" name="enquireName" required>
                </div>
                <div class="enquire__form-group-two form-group">
                  <input class="enquire__form-control form-control" placeholder="E-mail" type="email" id="enquireEmail" name="enquireEmail" required>
                </div>
              </div>
              <div class="enquire__row-two">
                <div class="enquire__form-group-two form-group">
                  <input class="enquire__form-control form-control" type="tel" placeholder="Phone" id="enquirePhone" name="enquirePhone" required>
                </div>
                <div class="enquire__form-group-two form-group">
                  <input class="enquire__form-control form-control" type="text" placeholder="State / Province" id="enquireState" name="enquireState" required>
                </div>
              </div>

              <div class="enquire__btn-block">
                <button type="submit" class="enquire__send">
                  <p class="submitText">enquire now</p>
                  <img src="img/ajax-loader.gif" class="preloader enquire__preloader vis_hidden" alt="loader">
                </button>
                <div class="enquireloginInfo"></div>
              </div>
            </form>
          </div>
        </div>

      </div>
    </div>


    <!-- Modal InstallerApps -->
    <div id="installerApps" class="modal fade" role="dialog">
      <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal__apps-content modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
              <img class="modal__close-btn" src="img/icon_close.svg" alt="">
            </button>
          </div>
          <div class="modal__apps-body modal-body">
            <div class="modal__title">
              <h2 class="modal__caption">Login</h2>
              <p class="modal__desc">To login as Installer, please install one of below apps</p>
            </div>
            <div class="modal__btn-block">
              <a class="modal__ios" target="_blank" href="https://itunes.apple.com/ua/app/gps-installer/id1293224753?mt=8">
                <img class="modal__ios-img" src="img/modalApps/app_store.png" alt="apps">
              </a>
              <a class="maodal__google" target="_blank" href="https://play.google.com/store/apps/details?id=com.sinopacific.installergps">
                <img class="modal__google-img" src="img/modalApps/google.png" alt="apps">
              </a>
            </div>
          </div>
        </div>

      </div>
    </div>

  </div>





    <!-- script -->
    <script src="js/jquery-3.2.1.min.js?v=<?=filemtime('js/jquery-3.2.1.min.js'); ?>"></script>
    <script src="js/jquery.viewportchecker.min.js?v=<?=filemtime('js/jquery.viewportchecker.min.js'); ?>"></script>
    <script src="js/bootstrap.min.js?v=<?=filemtime('js/bootstrap.min.js'); ?>"></script>
    <script src="js/bootstrap-select.min.js?v=<?=filemtime('js/bootstrap-select.min.js'); ?>"></script>
    <script src="js/validator.min.js?v=<?=filemtime('js/validator.min.js'); ?>"></script>
    <script src="js/main.js?v=<?=filemtime('js/main.js'); ?>"></script>
    <script src="js/animated.js?v=<?=filemtime('js/animated.js'); ?>"></script>
    <script src="js/contact-val.js?v=<?=filemtime('js/contact-val.js'); ?>"></script>
    <script src="js/enquire.js?v=<?=filemtime('js/enquire.js'); ?>"></script>
    <script src="js/scroll-to.js?v=<?=filemtime('js/scroll-to.js'); ?>"></script>
    <script src="js/other.js?v=<?=filemtime('js/other.js'); ?>"></script>



</body>
</html>
