  <!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">

  <title>Support</title>
  <link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

  <link rel="stylesheet" href="css/bootstrap.min.css">
  <link rel="stylesheet" href="css/bootstrap-select.min.css">
  <link rel="stylesheet" type="text/css" href="css/materialPreloader.min.css" />
  <link rel="stylesheet" href="css/jquery.uploadPreviewer.css">
  <link rel="stylesheet" href="css/font.css">
  <link rel="stylesheet" href="css/main.css?v=<?php echo filemtime('css/main.css'); ?>">
  <link rel="stylesheet" href="css/media.css?v=<?php echo filemtime('css/media.css'); ?>">
</head>
<body id="body_template">


  <script id="template" type="text/template7">
    <div class="page__wrapper">

      <div class="support__container container"> 
  		<div class="support__top-block align-center" style="text-align:center">
  			<!--<a href="">  
               <?php if($_GET['s']!='31'){ ?><img src="img/logo/<?php echo $_GET['s'];?>.png" alt="" style="width: 200px"><?php } ?>
            </a>-->
  		</div>
        <div class="support__top-block d-flex justify-content-between flex-wrap align-center">
        <h1 class="support__caption">{{Language.MSG_1}}</h1>
          <h2 class="support__lang-block">
            {{Language.MSG_2}}
            <div class="support__lang-dropdown">
              <a class="support__link-lang support__link-lang-en" href="?LG=EN">English</a>
              <a class="support__link-lang support__link-lang-es" href="?LG=ES">Españól</a>
              <a class="support__link-lang support__link-lang-ua" href="?LG=UA">Українська</a>
              <a class="support__link-lang support__link-lang-ru" href="?LG=RU">Русский</a>
            </div>
          </h2>
        </div>
        <div class="support__form-block">
          <form enctype="multipart/form-data" class="support__form">
            <input type="hidden" name="Service" id="service" value="<?php echo $_GET['s'];?>">

            <h2 class="form__caption">{{Language.MSG_3}} <span class="form__mandatory">({{Language.MSG_4}})</span></h2>
            <div class="form__line-block"></div>
            <div class="form__row d-flex justify-content-between flex-wrap">
              <div class="form-group form__group-two">
                <input class="form-control form__control-two clearAfter" type="text" name="Name" placeholder="{{Language.MSG_5}}" required>
              </div>
              <div class="form-group form__group-two">
                <input class="form-control form__control-two clearAfter" type="text" name="Login" placeholder="{{Language.MSG_6}}" required>
              </div>
            </div>
            <div class="form-group form__group">
              <input class="form-control form__control clearAfter" type="text" name="Account" placeholder="{{Language.MSG_7}}" required>
            </div>
            <div class="form__row d-flex justify-content-between flex-wrap">
              <div class="form-group form__group-two">
                <input class="form-control form__control-two clearAfter" type="email" name="Email" placeholder="{{Language.MSG_8}}" required>
              </div>
              <div class="form-group form__group-two">
                <input class="form-control form__control-two clearAfter only_numbers" type="tel" name="Phone" placeholder="{{Language.MSG_9}}">
              </div>
            </div>

            <h2 class="form__caption">{{Language.MSG_36}}<span class="form__mandatory"> ({{Language.MSG_4}})</span></h2>
            <div class="form__line-block"></div>
            <div class="form__row d-flex justify-content-between flex-wrap">
              <div class="form-group form__group-two">
                <input  data-toggle="tooltip" data-placement="bottom" title="This can be found under the EDIT option for the asset details" class="form-control form__control-two clearAfter" maxlength="16" type="text" name="IMEI" placeholder="{{Language.MSG_10}}" required>
              </div>
              <div class="form-group form__group-two">
                <input class="form-control form__control-two clearAfter" type="text" name="Asset" placeholder="{{Language.MSG_11}}" required>
                
              </div>
            </div>

            <div class="form__row d-flex justify-content-between flex-wrap">
              <div class="form-group form__group-two">
                <select class="form-control form__issue selectpicker" name="DeviceType" id="deviceType" title="{{Language.MSG_41}}">
                    {{#DeviceTypeList}}
                    <option value="{{Val}}">{{Text}}</option>
                    {{/DeviceTypeList}}
                  <!--<option value="1">QPROTECT</option>
                  <option value="2">LOC8</option>
                  <option value="4">TRAK</option>
                  <option value="5">PLANTWATCH</option>
                  <option value="6">CARWATCH</option>
                  <option value="7">FLEETWATCH</option>
                  <option value="8">BOATWATCH</option>
                  <option value="3">{{Language.MSG_15}}</option>-->
                </select>
              </div>
              <div class="form-group form__group-two">
                <select class="form-control form__device selectpicker" title="{{Language.MSG_20}}" name="IssueType" id="TypeIssue" required>
                  <option value="2">{{Language.MSG_16}}</option>
                  <option value="1">{{Language.MSG_17}}</option>
                  <option value="10">{{Language.MSG_18}}</option>
                  <option value="11">{{Language.MSG_19}}</option>
                </select>
              </div>
            </div>

            <div class="form__line-block"></div>
            <div class="form__innerSelectBlock displayNone" id="issueContainer">
              <div class="form__row d-flex justify-content-between flex-wrap">
                <div class="form__group-two">
                  <div id="IssueErrorBlock">
                    <select class="form-control form__device2 selectpicker" name="TypeIssueError" id="TypeIssueError">
                      <option value="1">{{Language.MSG_20}}</option>
                    </select>
                  </div>
                  <div class="form-group form__upload">
                    <input id="file_upload" name="userfile" type="file" class="form-control clearAfter">
                  </div>
                </div>

                <div class="form-group form__group-two form__text-block">
                  <textarea class="form-control form__textarea clearAfter" name="Textarea" placeholder="{{Language.MSG_32}}" id="textareaError"></textarea>
                </div>

              </div>
              <div class="form__line-block"></div>
            </div>
            <div class="form__btn-block">
              <button class="form__btn-send btn" type="submit">
                <p class="submit_text">{{Language.MSG_34}}</p>
                <img class="preloader vis_hidden" src="img/5.svg" alt="loader">
              </button>
              <div class="info"></div>
            </div>

          </form>
        </div>
      </div>

    </div>
  </script>


  <!-- main script -->
  <script src="js/jquery-3.3.1.min.js"></script>

  <script src="js/jquery.uploadPreviewer.js"></script>
  <script src="https://unpkg.com/popper.js/dist/umd/popper.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script src="js/bootstrap-select.min.js"></script>
  <script src="js/materialPreloader.min.js"></script>
  <script src="js/template7.min.js"></script>

  <!-- custom script -->
  <script src="js/selectron.js"></script>

  <!-- validation form -->
  <script src="js/validator.min.js"></script>
  <script src="js/maskedinput.js"></script>

  <!-- other scripts -->
  <script type="text/javascript">

    function GetURLParameter(sParam){//console.log('***',sParam);
        var sParameterName = '';
        var sPageURL = window.location.search.substring(1);
        var sURLVariables = sPageURL.split('&');
        for (var i = 0; i < sURLVariables.length; i++)
        {
            sParameterName = sURLVariables[i].split('=');
            if (sParameterName[0] == sParam)
            {
                return sParameterName[1];
            }
        }
    }

      var LanguagePackages = {
        'RU': {
          'MSG_1':'Поддержка',
          'MSG_2':'Язык',
          'MSG_3':'Персональная информация',
          'MSG_4':'*Обязательные поля',
          'MSG_5':'Имя*',
          'MSG_6':'Логин*',
          'MSG_7':'Имя Аккаунта*',
          'MSG_8':'Email*',
          'MSG_9':'Номер телефона ',
          'MSG_10':'IMEI* ',
          'MSG_11':'Имя устройства*',
          'MSG_12':'Сервис*',
          'MSG_13':'Тип устройства',
          'MSG_14':'Тип вопроса*',
          'MSG_15':'Не знаю',
          'MSG_16':'Проблемы с устройством',
          'MSG_17':'Проблема с программным обеспечением',
          'MSG_18':'Проблема з аккаунтом',
          'MSG_19':'Другие',
          'MSG_20':'Выберите из списка',
          'MSG_21':'Устройство в не сети',
          'MSG_22':'Устройство не обновляется',
          'MSG_23':'Неправильная локация',
          'MSG_24':'Забыли пароль',
          'MSG_25':'Не можете войти в систему',
          'MSG_26':'Программное обеспечение не загружается',
          'MSG_27':'Отчеты не поступают',
          'MSG_28':'Счет неправильный',
          'MSG_29':'Счет не получил',
          'MSG_30':'Обновить детали платежа',
          'MSG_31':'Оплатить счёт',
          'MSG_32':'Заметки*',
          'MSG_33':'Добавить файл',
          'MSG_34':'Отправить',
          'MSG_35':'Имя',
          'MSG_36':'Информация об Активах',
          'MSG_37':'Only image file is allowed.',
          'MSG_38':'File with this name alredy added.',
          'MSG_39':'File size should not be more than 2 MB.',
          'MSG_40':'You reached maximum number of attachments.',
          'MSG_41':'Выберите тип устройства',
          'MSG_42':'Выберите Сервис',



        },
        'EN': {
          'MSG_1':'Support',
          'MSG_2':'LANGUAGE',
          'MSG_3':'Personal Info',
          'MSG_4':'*Mandatory fields',
          'MSG_5':'Name*',
          'MSG_6':'Login Name*',
          'MSG_7':'Account Name*',
          'MSG_8':'Email*',
          'MSG_9':'Phone',
          'MSG_10':'IMEI* ',
          'MSG_11':'Asset Name*',
          'MSG_12':'Service*',
          'MSG_13':'Type of issue*',
          'MSG_14':'Type of question*',
          'MSG_15':"Don't know",
          'MSG_16':'Device issue',
          'MSG_17':'Software issue',
          'MSG_18':'Accounts',
          'MSG_19':'Other',
          'MSG_20':'Select from the list',
          'MSG_21':'Unit offline',
          'MSG_22':'Unit not updating',
          'MSG_23':'Unit wrong location',
          'MSG_24':'Forgotten Password',
          'MSG_25':"Can't Login",
          'MSG_26':'Software not loading',
          'MSG_27':'Reports not running',
          'MSG_28':'Invoice incorrect',
          'MSG_29':'Invoice not received',
          'MSG_30':'Update payment details',
          'MSG_31':'Pay Invoice',
          'MSG_32':'Notes*',
          'MSG_33':'Upload File',
          'MSG_34':'Send',
          'MSG_35':'Name',
          'MSG_36':'Asset Info',
          'MSG_37':'Only image file is allowed.',
          'MSG_38':'File with this name alredy added.',
          'MSG_39':'File size should not be more than 2 MB.',
          'MSG_40':'You reached maximum number of attachments.',
          'MSG_41':'Select Device Type',
          'MSG_42':'Select Service',
        },
        'ES': {
          'MSG_1':'Apoyo',
          'MSG_2':'Idioma',
          'MSG_3':'Información personal',
          'MSG_4':'*Campos obligatorios',
          'MSG_5':'Nombre* ',
          'MSG_6':'Nombre de usuario*',
          'MSG_7':'Nombre de la cuenta*',
          'MSG_8':'Email*',
          'MSG_9':'Teléfono',
          'MSG_10':'IMEI* ',
          'MSG_11':'Nombre del activo*',
          'MSG_12':'Servicio*',
          'MSG_13':'Tipo de dispositivo*',
          'MSG_14':'Tipo de problema*',
          'MSG_15':"No lo sé",
          'MSG_16':'Problema con el dispositivo',
          'MSG_17':'Problema de software',
          'MSG_18':'Cuentas',
          'MSG_19':'Otros',
          'MSG_20':'Seleccione en el listado',
          'MSG_21':'Dispositivo fuera de línea',
          'MSG_22':'El dispositivo no actualiza su posición',
          'MSG_23':'Dispositivo con ubicación errónea',
          'MSG_24':'Olvidé mi contraseña',
          'MSG_25':"No puedo conectarme a mi cuenta",
          'MSG_26':'No carga el software en la página',
          'MSG_27':'Los reportes estadísticos no funcionan',
          'MSG_28':'La boleta/factura presenta errores',
          'MSG_29':'No he recibido mi boleta/factura',
          'MSG_30':'Quiero actualizar los datos de facturación',
          'MSG_31':'Quiero pagar mi boleta/factura',
          'MSG_32':'Notas*',
          'MSG_33':'Upload File',
          'MSG_34':'Enviar',
          'MSG_36':'Información de activos',
          'MSG_37':'Only image file is allowed.',
          'MSG_38':'File with this name alredy added.',
          'MSG_39':'File size should not be more than 2 MB.',
          'MSG_40':'You reached maximum number of attachments.',
          'MSG_41':'Seleccionar tipo de dispositivo',
          'MSG_42':'Seleccionar servicio',

        },
        'UA': {
          'MSG_1':'Підтримка',
          'MSG_2':'Мова',
          'MSG_3':'Персональна інформація',
          'MSG_4':"*Обов'язкови поля",
          'MSG_5':"Ім'я*",
          'MSG_6':'Логін*',
          'MSG_7':"Ім'я Аккаунта*",
          'MSG_8':'Email*',
          'MSG_9':'Номер телефону',
          'MSG_10':'IMEI* ',
          'MSG_11':"Ім'я пристрою*",
          'MSG_12':'Сервіс*',
          'MSG_13':'Тип пристрою',
          'MSG_14':'Тип питання*',
          'MSG_15':'Не знаю',
          'MSG_16':'Проблема з пристроєм',
          'MSG_17':'Проблема с программним забезпеченням',
          'MSG_18':'Проблема з аккаунтом',
          'MSG_19':'Інші',
          'MSG_20':'Оберіть зі списка',
          'MSG_21':'Пристрій не в мережі',
          'MSG_22':'Пристрій не оновлюється',
          'MSG_23':'Неправільная локація',
          'MSG_24':'Забули пароль',
          'MSG_25':'Не можете увійти до системи',
          'MSG_26':'Программне забезпеченння не завантажується',
          'MSG_27':'Звіти не надходять',
          'MSG_28':'Невірний рахунок',
          'MSG_29':'Не отримав рахунок',
          'MSG_30':'Обновити деталі платежу',
          'MSG_31':'Сплатити Рахунок',
          'MSG_32':'Примітка*',
          'MSG_33':'Завантажити файл',
          'MSG_34':'Відправити',
          'MSG_36':'Інформація про Активи',
          'MSG_37':'Only image file is allowed.',
          'MSG_38':'File with this name alredy added.',
          'MSG_39':'File size should not be more than 2 MB.',
          'MSG_40':'You reached maximum number of attachments.',
          'MSG_41':'Виберіть Тип Пристрою',
          'MSG_42':'Виберіть Сервіс',

        }
      };

      var lang = navigator.browserLanguage ? navigator.browserLanguage.toLowerCase() : navigator.language.toLowerCase();
      //console.log(lang);
      if(lang.indexOf("en") >= 0) {
       lang = "EN";
      }
      else if(lang.indexOf("es") >= 0) {
       lang = "ES";
      }
      else if(lang.indexOf("uk") >= 0 || lang.indexOf("ua") >= 0) {
       lang = "UA";
      }
      else if(lang.indexOf("ru") >= 0) {
       lang = "RU";
      }
      else {
       lang = "EN";
      }
    // console.log(lang);
      var getLang = GetURLParameter('LG');

      if(getLang){
        lang = getLang;
      }

      var LANGUAGE = LanguagePackages[lang];
      //Template7.global = LanguagePackages[lang];
      // console.log(LANGUAGE);

      $(function() {
          var s = GetURLParameter('s');
          if (s){
              s = parseInt(s);
          }

          var templateData = {
            Language: LANGUAGE
          };
          var deviceTypeList = {
            1: [
                {
                    Val: 1,
                    Text: 'QPROTECT',
                },
                {
                    Val: 2,
                    Text: 'LOC8',
                },
                {
                    Val: 3,
                    Text: LANGUAGE.MSG_15,
                },
                {
                    Val: 4,
                    Text: 'TRAK',
                },
                {
                    Val: 5,
                    Text: 'PLANTWATCH',
                },
                {
                    Val: 6,
                    Text: 'CARWATCH',
                },
                {
                    Val: 7,
                    Text: 'FLEETWATCH',
                },
                {
                    Val: 8,
                    Text: 'BOATWATCH',
                },
            ],
            2: [
                {
                    Val: 9,
                    Text: 'AIS Live Tracking',
                },
            ]
          };

        switch (s) {
            case 2:
                templateData.DeviceTypeList = deviceTypeList[s];
                break;
            default:
                templateData.DeviceTypeList = deviceTypeList[1];
        }

        var template = $('#template').html();
        // compile it with Template7
        var compiledTemplate = Template7.compile(template);
        var html = compiledTemplate(templateData);
        var body = $('#body_template');
        body.append(html);
      });
  </script>
  <script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
  <script src="js/support.js?v=<?php echo filemtime('js/support.js'); ?>"></script>

</body>
</html>
